/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.git.GitBlameAndLinecountCalculator;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.GitScanner;
import com.atlassian.fisheye.git.client.GitContext;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.Version;

public class GitRepositoryEngine
extends BaseRepositoryEngine<GitScanner, GitCache> {
    public static final Version GIT_BASE_VERSION = new Version("1.6.6");
    private final GitContext context;

    public GitRepositoryEngine(RepositoryConfig config, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        super(config, upgradeManager, indexingContext);
        this.context = new GitContext(config);
    }

    @Override
    protected GitScanner createScanner() throws DbException {
        return new GitScanner(this);
    }

    @Override
    protected BlameAndLinecountCalculator initLinecountCalculator() {
        return new GitBlameAndLinecountCalculator(this);
    }

    public GitContext getContext() {
        return this.context;
    }

    @Override
    protected GitCache createCache(long cacheSerial) {
        return new GitCache(cacheSerial, this.getDiskCacheVersion(), this.context, this.context.getName(), this.getDatabaseHandle(), this.getIndexConnection(), this.getLicenseEnforcer(), this.getIndexingContext());
    }

    @Override
    protected void ensureCorrectScmVersion() throws ConfigException {
        Version version = this.context.determineGitVersion();
        GitRepositoryEngine.validateGitVersion(version);
    }

    public static void validateGitVersion(Version gitVersion) throws ConfigException {
        if (gitVersion.compareTo(GIT_BASE_VERSION) < 0) {
            throw new ConfigException("You must use a git version of " + GIT_BASE_VERSION + " or later - you have " + gitVersion);
        }
    }

    @Override
    public String getDisplayRevision(String revision) {
        return DvcsUtils.truncateHash(revision);
    }

    @Override
    public long getEffectivePollPeriod() {
        long pollPeriod = super.getEffectivePollPeriod();
        if (pollPeriod == 0L) {
            boolean needsToFinishChangesetReindexing;
            boolean needsToFinishManifestUpgrading = !((GitCache)this.getInternalRevisionCache()).hasScanProperty(CommonProperties.GIT_MANIFEST_UPGRADE.value);
            boolean bl = needsToFinishChangesetReindexing = ((GitCache)this.getInternalRevisionCache()).getScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, 0L) != 0L;
            if (needsToFinishManifestUpgrading || needsToFinishChangesetReindexing) {
                pollPeriod = 60000L;
            }
        }
        return pollPeriod;
    }

    @Override
    public String getLink(RevInfoKey revInfoKey) {
        return "";
    }

    @Override
    public void requestFullscan() {
    }

    @Override
    protected long getPollPeriod() {
        return this.context.getScmConfig().getPollPeriod();
    }
}

