/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.git;

import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.git.client.GitBlameParser;
import com.atlassian.fisheye.git.client.GitClientManifestDAO;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.fisheye.git.client.GitListTreeOutputHandler;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitChangeSetDAO;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.git.db.GitRevInfoDAO;
import com.atlassian.fisheye.git.db.GitStringTables;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.CommonManifestDAOImpl;
import com.atlassian.utils.process.CopyOutputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.BlameInfo;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.FileRevisionImpl;
import com.cenqua.fisheye.rep.GitTreeNode;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GitCache
extends DvcsCache<GitRevInfo, GitChangeSet, GitStringTables> {
    private final GitContext context;
    private final GitRevInfoDAO fileRevDAO;
    private final GitChangeSetDAO csDAO;
    private final GitClientManifestDAO manifestDAO;
    private final CommonManifestDAO commonManifestDAO;

    protected GitCache() {
        super(null, 0L, 0, null, null, null, null, null, null, null);
        this.context = null;
        this.fileRevDAO = null;
        this.csDAO = null;
        this.manifestDAO = null;
        this.commonManifestDAO = null;
    }

    public GitCache(long cacheSerial, int version, GitContext context, String repositoryName, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext) {
        super(context.getConfig().getStatus(), cacheSerial, version, dbh, luceneConnection, new GitStringTables(dbh), licenseEnforcer, indexingContext, repositoryName, context);
        this.context = context;
        this.fileRevDAO = new GitRevInfoDAO(this.getRepositoryName(), this.getInfDb(), (GitStringTables)this.getStringTables(), this.getLicenseEnforcer());
        this.csDAO = new GitChangeSetDAO(context.getConfig().getStatus(), this.getInfDb(), (GitStringTables)this.getStringTables(), this.fileRevDAO, this.getLicenseEnforcer());
        this.fileRevDAO.setChangeSetDAO(this.csDAO);
        this.manifestDAO = new GitClientManifestDAO(this);
        this.commonManifestDAO = new CommonManifestDAOImpl(dbh, (CommonStringTables)this.getStringTables());
    }

    protected Charset getEncoding() {
        return this.context.getScmConfig().getEncoding();
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, OutputStream outputStream) throws IOException, DbException {
        try {
            GitRevInfo revInfo = (GitRevInfo)this.getFileRevision(key);
            if (!revInfo.getDestHash().equals("0000000000000000000000000000000000000000")) {
                GitCommandBuilder command = new GitCommandBuilder("cat-file", "blob");
                command.append(revInfo.getDestHash());
                CopyOutputHandler copyHandler = new CopyOutputHandler(outputStream);
                this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)copyHandler);
            }
        }
        catch (DvcsProcessException e2) {
            throw new DbException("Unable to get content for " + key, e2);
        }
        finally {
            outputStream.flush();
        }
    }

    private String resolveRevisionForContentHash(Path path, String contentHash) throws DbException {
        List<String> longContentHashes = this.fileRevDAO.resolveContentHash(contentHash);
        FileRevisionImpl found = null;
        for (String longContentHash : longContentHashes) {
            List<GitRevInfo> revs = this.getFileRevisionsForContentHash(longContentHash, path);
            if (revs.size() <= 0) continue;
            if (found != null) {
                Logs.APP_LOG.error((Object)("While resolving a commit id, the short content hash '" + contentHash + "' resolved into more than one full hash for the path '" + path.getPath() + "'. You should supply a full content hash to ensure FishEye uses the correct one."));
            }
            found = (GitRevInfo)Ordering.from(FileRevision.NEWEST_FIRST_COMPARATOR).min(revs);
        }
        if (found != null) {
            return found.getChangeSetId();
        }
        return null;
    }

    @Override
    public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> patchRevisions) throws DbException {
        HashMap<Path, String> resolvedCache = new HashMap<Path, String>();
        for (Path path : patchRevisions.keySet()) {
            RevisionIdentifier revision = patchRevisions.get(path);
            String commitHash = null;
            if (HashMatchType.COMMIT.equals((Object)revision.getType())) {
                commitHash = this.csDAO.getLongCommitHash(revision.getId());
                if (commitHash != null) {
                    String contentHash = this.getContentHashForPathAtRevision(path, commitHash);
                    if (contentHash != null) {
                        commitHash = this.resolveRevisionForContentHash(path, contentHash);
                    } else {
                        Logs.APP_LOG.error((Object)("While anchoring a patch, the content hash '" + contentHash + "' was resolved" + " from commit hash '" + commitHash + "' and path '" + path + "', but could not be resolevd" + " back to a commit hash"));
                        commitHash = null;
                    }
                }
            } else {
                commitHash = this.resolveRevisionForContentHash(path, revision.getId());
            }
            if (commitHash == null) continue;
            resolvedCache.put(path, commitHash);
        }
        return resolvedCache;
    }

    @Override
    public Blame getBlameFallback(final RevInfoKey revInfoKey) throws DbException, IOException {
        GitCommandBuilder command = new GitCommandBuilder("blame", "-l", "-p");
        command.append(revInfoKey.getRev());
        command.append("--");
        command.append(this.context.getServerPath(revInfoKey.getPath()));
        final ArrayList<BlameChunk> blameChunks = new ArrayList<BlameChunk>();
        try {
            this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)new GitBlameParser(this.getEncoding()){

                @Override
                protected void startChunk(String commit, String filename, int originalLine, int lineNum, int length) throws DbException {
                    FileRevision fileRevision;
                    Path path = GitCache.this.context.getLocalPath(filename);
                    RevInfoKey key = new RevInfoKey(path, commit);
                    int revid = GitCache.this.getRevId(key);
                    if ((long)revid == -1L) {
                        fileRevision = null;
                    } else {
                        fileRevision = GitCache.this.getFileRevision(revid, true);
                        if (fileRevision == null) {
                            Logs.APP_LOG.warn((Object)("Unable to find file revision for " + key + ", line = " + lineNum + ", length = " + length));
                        }
                    }
                    BlameInfo info = fileRevision != null ? new BlameInfo(fileRevision) : new SyntheticBlameInfo(commit, DvcsUtils.truncateHash(commit), revInfoKey.getPath());
                    BlameChunk chunk = new BlameChunk(info, lineNum - 1, originalLine - 1, length);
                    if (fileRevision != null) {
                        chunk.setRevId(fileRevision.getRevID());
                    }
                    blameChunks.add(chunk);
                }
            });
        }
        catch (DvcsProcessException e2) {
            throw new DbException(e2);
        }
        return new Blame(blameChunks);
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.GIT;
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public GitRevInfoDAO getFileRevisionDAO() {
        return this.fileRevDAO;
    }

    @Override
    protected GitRevInfo getFileRevisionAtManifest(Path path, String csid) {
        String longHash = this.getLongHash(csid);
        if (longHash == null) {
            return null;
        }
        CommonManifest manifest = this.commonManifestDAO.load(longHash);
        if (manifest != null) {
            String commit = manifest.getPathCommit(path);
            if (commit == null) {
                Logs.APP_LOG.debug((Object)("The path '" + path + "' does not exist at commit hash '" + longHash + "'"));
                return null;
            }
            return (GitRevInfo)this.getFileRevision(new RevInfoKey(path, commit));
        }
        String contentHash = this.getContentHashForPathAtRevision(path, longHash);
        if (contentHash != null) {
            String revisionHash = this.resolveRevisionForContentHash(path, contentHash);
            if (revisionHash != null) {
                RevInfoKey rkey = new RevInfoKey(path, revisionHash);
                return (GitRevInfo)this.getFileRevision(rkey);
            }
            Logs.APP_LOG.debug((Object)("Could not resolve a revision for content hash: " + contentHash + ", processing path " + path + " at commit hash '" + csid + "'"));
            return null;
        }
        Logs.APP_LOG.debug((Object)("The path '" + path + "' does not exist at commit hash '" + csid + "'"));
        return null;
    }

    public CommonManifestDAO getCommonManifestDAO() {
        return this.commonManifestDAO;
    }

    @Override
    public GitChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    public GitContext getContext() {
        return this.context;
    }

    @Override
    public Manifest<GitRevInfo> getManifest(String csid) throws DbException {
        return this.manifestDAO.load(csid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitRevInfo getFileRevisionAtManifest(Path path, String contentHash, String csid, boolean allowGitContentHashResolvingHeuristic) throws DbException {
        Timer timer = new Timer("Getting file revisions for content hash " + contentHash + " at path " + path);
        try {
            StringBuilder hashMatches;
            List<GitRevInfo> candidateRevInfos = this.getFileRevisionsForContentHash(contentHash, path);
            if (candidateRevInfos.isEmpty()) {
                Logs.APP_LOG.debug((Object)("No file revisions found for content hash: " + contentHash));
                GitRevInfo gitRevInfo = null;
                return gitRevInfo;
            }
            if (candidateRevInfos.size() == 1) {
                GitRevInfo gitRevInfo = candidateRevInfos.get(0);
                return gitRevInfo;
            }
            if (allowGitContentHashResolvingHeuristic && AppConfig.Hacks.ENABLE_GIT_CONTENT_HASH_RESOLVING_HEURISTIC) {
                GitRevInfo gitRevInfo = candidateRevInfos.get(candidateRevInfos.size() - 1);
                return gitRevInfo;
            }
            if (csid != null) {
                for (GitRevInfo gitRevInfo : candidateRevInfos) {
                    if (!csid.equals(gitRevInfo.getRevision())) continue;
                    GitRevInfo gitRevInfo2 = gitRevInfo;
                    return gitRevInfo2;
                }
            }
            if (Logs.APP_LOG.isDebugEnabled()) {
                hashMatches = new StringBuilder().append(candidateRevInfos.size()).append(" (");
                for (GitRevInfo candidate : candidateRevInfos) {
                    hashMatches.append(candidate.getRevision()).append(" ");
                }
                hashMatches.append(")");
                String string = "getFileRevisionAtManifest: path " + path + ", csid " + csid + ", content hash " + contentHash + ": candidates " + hashMatches;
                Logs.APP_LOG.debug((Object)string);
            }
            if (csid == null) {
                Logs.APP_LOG.debug((Object)("getFileRevisionAtManifest: null csid looking up " + path + ", " + contentHash));
                hashMatches = null;
                return hashMatches;
            }
            GitRevInfo result = this.searchAncestryForParentRevInfoWithContentHash(path, contentHash, csid);
            if (result == null) {
                StringBuilder stringBuilder = new StringBuilder("Inconsistent state while finding the revision for file at path ").append(path).append(" at changeset ").append(csid).append(". No revision returned by git.").append("Content hash was: ").append(contentHash);
                Logs.APP_LOG.warn((Object)stringBuilder);
            }
            GitRevInfo gitRevInfo = result;
            return gitRevInfo;
        }
        finally {
            timer.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitRevInfo searchAncestryForParentRevInfoWithContentHash(Path path, String contentHash, String csid) throws DbException {
        Timer timer = new Timer("searching changeset ancestry of " + csid + " for " + path + " and contenthash " + contentHash);
        Map<String, Integer> revisions = this.fileRevDAO.getPathRevisions(path);
        int count = 0;
        try {
            GraphIterator<String> it = this.csDAO.iterateAncestors(csid);
            while (it.hasNext()) {
                ++count;
                String csId = (String)it.next();
                Integer revid = revisions.get(csId);
                if (revid == null) continue;
                it.prune();
                if (!contentHash.equals(this.fileRevDAO.getDestHash(revid))) continue;
                GitRevInfo gitRevInfo = (GitRevInfo)this.fileRevDAO.loadLazy(revid);
                return gitRevInfo;
            }
        }
        finally {
            timer.end("traversed " + count + " changesets.");
        }
        return null;
    }

    private List<GitRevInfo> getFileRevisionsForContentHash(String contentHash, Path path) {
        return this.fileRevDAO.getFileRevisionsForContentHash(contentHash, path);
    }

    private String getContentHashForPathAtRevision(Path path, String commitHash) throws DbException {
        Preconditions.checkNotNull((Object)commitHash, (Object)"Cannot lookup content hash for a null commit hash");
        GitCommandBuilder command = new GitCommandBuilder("ls-tree", new String[0]);
        command.append(commitHash);
        command.append(this.context.getServerPath(path));
        try {
            GitListTreeOutputHandler handler = new GitListTreeOutputHandler(this.getEncoding(), command.toString());
            this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)handler);
            for (GitTreeNode node : handler.getTreeNodes()) {
                if (!node.getName().equals(path.getPath())) continue;
                return node.getNodeHash();
            }
        }
        catch (DvcsProcessException ex) {
            throw new DbException(ex);
        }
        return null;
    }
}

