/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.event;

import com.atlassian.annotations.Internal;
import com.cenqua.fisheye.rep.BranchChange;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

@Internal
public class RepositoryScanProcessedEvent {
    private final String repository;
    private final Set<String> changesetIds;
    private final Set<BranchChange> branchChanges;

    public RepositoryScanProcessedEvent(String repository, Iterable<String> changesetIds, Iterable<BranchChange> branchChanges) {
        this.repository = (String)Preconditions.checkNotNull((Object)repository);
        this.changesetIds = (Set)Preconditions.checkNotNull((Object)ImmutableSet.copyOf(changesetIds));
        this.branchChanges = (Set)Preconditions.checkNotNull((Object)ImmutableSet.copyOf(branchChanges));
    }

    public String getRepository() {
        return this.repository;
    }

    public Set<String> getChangesetIds() {
        return this.changesetIds;
    }

    public Set<BranchChange> getBranchChanges() {
        return this.branchChanges;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("repository", (Object)this.repository).add("changesetIds", this.changesetIds).add("branchChanges", this.branchChanges).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.repository, this.changesetIds, this.branchChanges});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryScanProcessedEvent other = (RepositoryScanProcessedEvent)obj;
        return Objects.equal((Object)this.repository, (Object)other.repository) && Objects.equal(this.changesetIds, other.changesetIds) && Objects.equal(this.branchChanges, other.branchChanges);
    }

    public boolean hasItems() {
        return !this.changesetIds.isEmpty() || !this.branchChanges.isEmpty();
    }
}

