/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.AsynchronousAbleEventDispatcher;
import com.atlassian.event.internal.DirectEventExecutorFactory;
import com.atlassian.event.internal.EventThreadPoolConfigurationImpl;
import com.atlassian.event.internal.LockFreeEventPublisher;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.fisheye.event.FishEyeListenerHandlersConfiguration;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.logging.Logs;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="eventPublisher")
@AvailableToPlugins(value=EventPublisher.class)
public class FisheyeEventPublisher
implements EventPublisher {
    private static final Logger log = Logs.APP_LOG;
    private final EventPublisher delegate = new LockFreeEventPublisher((EventDispatcher)new AsynchronousAbleEventDispatcher((EventExecutorFactory)new DirectEventExecutorFactory((EventThreadPoolConfiguration)new EventThreadPoolConfigurationImpl())), (ListenerHandlersConfiguration)new FishEyeListenerHandlersConfiguration());

    public void publish(Object event) {
        EventPublication eventPublication = new EventPublication(event);
        if (HibernateUtil.enqueueEvent(eventPublication)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Queued event " + event));
            }
        } else {
            eventPublication.publish();
        }
    }

    public void register(Object listener) {
        this.delegate.register(listener);
    }

    public void unregister(Object listener) {
        this.delegate.unregister(listener);
    }

    public void unregisterAll() {
        this.delegate.unregisterAll();
    }

    public class EventPublication {
        private final Object event;

        private EventPublication(Object event) {
            this.event = event;
        }

        public void publish() {
            if (log.isTraceEnabled()) {
                log.trace((Object)("About to publish event " + this.event));
            }
            FisheyeEventPublisher.this.delegate.publish(this.event);
        }

        public String toString() {
            return "EventPublication{event=" + this.event + '}';
        }
    }
}

