/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.handler;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.NamedProcessHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class StatusProcessHandler
extends NamedProcessHandler {
    private List<String> errorBuffer = new ArrayList<String>();
    private List<String> stdOutBuffer = new ArrayList<String>();

    public StatusProcessHandler(String repoName, Charset encoding, final RepositoryStatus status) {
        super(repoName);
        BaseLineOutputHandler outputHandler = new BaseLineOutputHandler(encoding){

            protected void processLine(int lineNum, String line) {
                StatusProcessHandler.this.stdOutBuffer.add(line);
                status.setMessage(line);
            }
        };
        this.setOutputHandler((OutputHandler)outputHandler);
        BaseLineOutputHandler errorHandler = new BaseLineOutputHandler(encoding){

            protected void processLine(int lineNum, String line) {
                StatusProcessHandler.this.errorBuffer.add(line);
                status.setMessage(line);
            }
        };
        this.setErrorHandler((OutputHandler)errorHandler);
    }

    public void logErrors() {
        for (String error : this.errorBuffer) {
            Logs.APP_LOG.error((Object)("git Error Output: " + error));
        }
    }

    public String getError() {
        return this.errorBuffer.toString();
    }

    public String getStdOut() {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (String str : this.stdOutBuffer) {
            result.append(sep).append(str);
            sep = "\n";
        }
        return result.toString();
    }
}

