/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.db;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.dag.GraphUtils;
import com.atlassian.fisheye.db.BaseFileRevisionDAO;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public abstract class DvcsRevInfoDAO<F extends DvcsRevInfo, T extends CommonStringTables>
extends BaseFileRevisionDAO<F, T> {
    public DvcsRevInfoDAO(String repositoryName, InfinityDbHandle dbh, T stringTables, LicenseEnforcer licenseEnforcer) {
        super(repositoryName, dbh, stringTables, licenseEnforcer);
    }

    @Override
    public int insertNew(F revInfo, AncestorLink ancestorLink, boolean storeDiffs) throws DbException, LicensePolicyException {
        int revid = this.commonDAO.insertNew((CommonFileRevisionInput)revInfo, ancestorLink, storeDiffs, this.isStoreSuffixPaths());
        if (((CommonFileRevision)revInfo).isDead() && ((CommonFileRevision)revInfo).getBranch() != null) {
            this.markForBranch(CommonSchema.E_BRANCH_TO_DEL_REVID, revid, ((CommonFileRevision)revInfo).getBranch());
        }
        return revid;
    }

    private void markForBranch(I entity, int revid, String branch) throws DbException {
        try {
            this.dbh.get().b(y.a().a(entity).b(branch).b((long)revid));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public String getLatestPathChange(Path path, Date upto) throws DbException {
        long pathId = this.commonDAO.getStringTables().pathDB.find(path.getPath());
        if (pathId == -1L) {
            return null;
        }
        y pathIndex = y.a().a(DvcsSchema.I_PATHID_COMMIT).b(pathId);
        int pl = pathIndex.e();
        if (upto != null) {
            pathIndex.b(upto.getTime());
        } else {
            pathIndex.j();
        }
        ac db = this.dbh.get();
        String commit = null;
        try {
            if (db.c(pathIndex, pl)) {
                pathIndex.w(pl);
                long commitId = pathIndex.v(pathIndex.w(pl));
                commit = this.stringTables.changeSetIdDB.get(commitId);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return commit;
    }

    public String getLatestPathChange(Path path) throws DbException {
        return this.getLatestPathChange(path, null);
    }

    public int getLatestPathRevid(Path path) throws DbException {
        String commit = this.getLatestPathChange(path);
        if (commit == null) {
            return -1;
        }
        return this.getRevId(path, commit);
    }

    public Map<String, Integer> getPathRevisions(Path path) throws DbException {
        return this.commonDAO.getPathRevisions(path);
    }

    public void clearHeadMarkersForBranch(String branchName) throws DbException {
        ac db = this.dbh.get();
        long branchId = this.stringTables.branchDB.find(branchName);
        y cuInverse = y.a(CommonSchema.E_REVID_TO_HEAD_IN_BRANCHES);
        y cu = y.a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(branchName);
        int pl = cu.e();
        try {
            while (db.a(cu, pl)) {
                long revId = cu.v(pl);
                cuInverse.f().a(CommonSchema.E_REVID_TO_HEAD_IN_BRANCHES).b(revId);
                int invRevL = cuInverse.e();
                cuInverse.b(branchId);
                db.c(cuInverse);
                db.c(cu);
                cuInverse.d(invRevL);
                if (db.a(cuInverse, invRevL)) continue;
                cuInverse.f().a(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).b(revId);
                db.c(cuInverse);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
            y.c(cuInverse);
        }
    }

    public void rebuildHeadsMarkersForBranch(final String branchName, Manifest<F> manifest) throws DbException {
        this.clearHeadMarkersForBranch(branchName);
        final ac db = this.dbh.get();
        final y cu = y.a();
        y cu2 = y.a();
        final HashSet<Path> headPaths = new HashSet<Path>();
        try {
            final long branchId = this.stringTables.branchDB.find(branchName);
            manifest.visitFileRevisions(new Visitor<F>(){

                @Override
                public void visit(F rev) {
                    try {
                        db.b(cu.f().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(branchName).b((long)((CommonFileRevision)rev).getRevID()));
                        db.b(cu.f().a(CommonSchema.E_REVID_TO_HEAD_IN_BRANCHES).b((long)((CommonFileRevision)rev).getRevID()).b(branchId));
                        db.b(cu.f().a(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).b((long)((CommonFileRevision)rev).getRevID()));
                    }
                    catch (IOException e2) {
                        throw new DbException(e2);
                    }
                    headPaths.add(((CommonFileRevision)rev).getPath());
                }
            });
            cu2.a(CommonSchema.E_BRANCH_TO_DEL_REVID).b(branchName);
            int pl = cu2.e();
            cu2.j();
            while (db.c(cu2, pl)) {
                int revid = (int)cu2.v(pl);
                RevInfoKey key = this.getKey(revid);
                if (key == null || headPaths.contains(key.getPath())) continue;
                headPaths.add(key.getPath());
                db.b(cu.f().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(branchName).b((long)revid));
                db.b(cu.f().a(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).b((long)revid));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
            y.c(cu2);
        }
    }

    public F getAncestorAtRevision(F fileRev, String revision) throws DbException {
        GraphIterator<F> it = GraphUtils.iterateBreadthFirst(Collections.singleton(fileRev), new AncestorProvider(), new FileRevIdProvider());
        while (it.hasNext()) {
            DvcsRevInfo rev = (DvcsRevInfo)it.next();
            if (!revision.equals(rev.getRevision())) continue;
            return (F)rev;
        }
        return null;
    }

    @Override
    public String getDisplayRevision(int revid) {
        String displayRevision = super.getDisplayRevision(revid);
        if (Strings.emptyToNull((String)displayRevision) != null) {
            return DvcsUtils.truncateHash(displayRevision);
        }
        return displayRevision;
    }

    private class FileRevIdProvider
    implements Function<F, Integer> {
        private FileRevIdProvider() {
        }

        public Integer apply(F from) {
            return ((CommonFileRevision)from).getRevID();
        }
    }

    private class AncestorProvider
    implements Function<F, Collection<F>> {
        private AncestorProvider() {
        }

        public Collection<F> apply(F from) {
            ArrayList<DvcsRevInfo> ancestors = new ArrayList<DvcsRevInfo>(((CommonFileRevision)from).getAncestors().size());
            if (((CommonFileRevision)from).getAncestorLink() != null) {
                IntListIterator intListIterator = ((CommonFileRevision)from).getAncestorLink().getRevids().iterator();
                while (intListIterator.hasNext()) {
                    int ancestorId = (Integer)intListIterator.next();
                    DvcsRevInfo parent = (DvcsRevInfo)DvcsRevInfoDAO.this.loadLazy(ancestorId);
                    if (parent != null) {
                        ancestors.add(parent);
                        continue;
                    }
                    Logs.APP_LOG.warn((Object)("Could not load parent " + ancestorId + " for file revision " + ((CommonFileRevision)from).getRevInfoKey() + " (returned null)"));
                }
            }
            return ancestors;
        }
    }
}

