/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.db;

import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DvcsChangeSetDAO<F extends DvcsRevInfo, C extends ChangeSetImpl<F>, T extends CommonStringTables>
extends CommonChangeSetDAO<F, C, T> {
    public DvcsChangeSetDAO(RepositoryStatus status, InfinityDbHandle dbh, T stringTables, DvcsRevInfoDAO<F, T> fileRevDAO, LicenseEnforcer licenseEnforcer) {
        super(status, dbh, stringTables, fileRevDAO, licenseEnforcer);
    }

    @Override
    protected void storeAttributes(EavEntityCu eav, long csDbId, C changeset) throws DbException, IOException {
        super.storeAttributes(eav, csDbId, changeset);
        this.addCommitHash(((ChangeSetImpl)changeset).getId());
    }

    private void addCommitHash(String commitHash) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(DvcsSchema.E_COMMITS).b(commitHash);
            if (!db.a_(cu)) {
                db.e(cu, cu.e());
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public List<String> resolveCommit(String commit) throws DbException {
        ArrayList<String> commits = new ArrayList<String>(1);
        if (commit != null) {
            y cu = y.a();
            try {
                ac db = this.dbh.get();
                cu.a(DvcsSchema.E_COMMITS);
                int pl = cu.e();
                cu.b(commit);
                if (db.a_(cu)) {
                    commits.add(commit);
                } else {
                    boolean continueSearching = true;
                    while (continueSearching) {
                        String candidateCommit;
                        continueSearching = false;
                        if (!db.a(cu, pl) || !(candidateCommit = cu.m(pl)).startsWith(commit)) continue;
                        commits.add(candidateCommit);
                        continueSearching = true;
                    }
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                y.c(cu);
            }
        }
        return commits;
    }

    public String getLongCommitHash(String commit) throws DbException {
        List<String> commits = this.resolveCommit(commit);
        return !commits.isEmpty() ? commits.get(0) : null;
    }
}

