/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.client;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringObfuscator;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DvcsProcessMonitor
implements ProcessMonitor {
    private Logger logger;
    private Priority priority;
    private StringObfuscator obfuscator;

    public DvcsProcessMonitor(Logger logger, Priority priority, StringObfuscator obfuscator) {
        this.logger = logger;
        this.priority = priority;
        this.obfuscator = obfuscator;
    }

    protected String obfuscate(String value) {
        if (this.obfuscator != null) {
            return this.obfuscator.obfuscate(value);
        }
        return value;
    }

    protected String getCommandLine(ExternalProcess process) {
        return this.obfuscate(process.getCommandLine());
    }

    public void onBeforeStart(ExternalProcess process) {
        if (this.logger != null && this.logger.isEnabledFor(this.priority)) {
            this.logger.log(this.priority, (Object)("Starting process: " + this.getCommandLine(process)));
        }
    }

    public void onAfterFinished(ExternalProcess process) {
        if (this.logger != null && this.logger.isEnabledFor(this.priority)) {
            StringBuilder message = new StringBuilder();
            String commandLine = this.getCommandLine(process);
            message.append("Finished process: ").append(commandLine);
            long startTime = process.getStartTime();
            if (startTime != -1L) {
                message.append(" took ").append(System.currentTimeMillis() - startTime).append("ms");
            }
            this.logger.log(this.priority, (Object)message.toString());
        }
    }
}

