/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.client;

import com.atlassian.fecru.security.SshKeyCredentials;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.security.SshWrapper;
import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.cenqua.fisheye.SafeExternalProcessBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class DvcsProcessFactory {
    private final SshKeyManager sshKeyManager;

    public DvcsProcessFactory(SshKeyManager sshKeyManager) {
        this.sshKeyManager = sshKeyManager;
    }

    public abstract DvcsProcessBuilder<?> builder(DvcsScmConfig var1, DvcsCommandBuilder var2, ProcessHandler var3, File var4);

    public class DvcsProcessBuilder<SELF extends DvcsProcessBuilder> {
        protected final DvcsCommandBuilder command;
        protected final ProcessHandler handler;
        protected final File workingDir;
        protected final DvcsScmConfig config;
        protected final List<ProcessMonitor> extraProcessMonitors = Lists.newArrayList();
        protected final Map<String, String> environmentVariables = Maps.newHashMap();
        protected long timeout;

        protected DvcsProcessBuilder(DvcsScmConfig config, DvcsCommandBuilder command, ProcessHandler handler, File workingDir) {
            this.command = command;
            this.handler = handler;
            this.workingDir = workingDir;
            this.config = config;
            this.timeout = config.getCommandTimeout().getValueInMillis();
        }

        public SELF monitor(ProcessMonitor ... extraProcessMonitors) {
            this.extraProcessMonitors.addAll(Arrays.asList(extraProcessMonitors));
            return (SELF)this;
        }

        public SELF timeout(long timeout) {
            this.timeout = timeout;
            return (SELF)this;
        }

        public SELF env(String variable, String value) {
            this.environmentVariables.put(variable, value);
            return (SELF)this;
        }

        public SELF env(Map<String, String> environmentVariables) {
            this.environmentVariables.putAll(environmentVariables);
            return (SELF)this;
        }

        public ExternalProcess build() {
            ExternalProcessBuilder builder = this.initProcessBuilder();
            return builder.build();
        }

        protected ExternalProcessBuilder initProcessBuilder() {
            List<String> commandArgs = this.command.createCommand();
            commandArgs.add(0, this.config.getExecutable());
            ExternalProcessBuilder builder = new SafeExternalProcessBuilder().command(commandArgs, this.workingDir, this.timeout).handler(this.handler).env(this.environmentVariables).addMonitor(new ProcessMonitor[]{DvcsContext.LOGGING_MONITOR}).addMonitor((ProcessMonitor[])Iterables.toArray(this.extraProcessMonitors, ProcessMonitor.class));
            if (this.config.isSshAuthenticatedRepo()) {
                new SshWrapper(DvcsProcessFactory.this.sshKeyManager.getPathToSshExecutable()).setSshWrapperVariables(builder, (SshKeyCredentials)this.config.getCredentials());
            }
            return builder;
        }
    }
}

