/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.client;

import com.atlassian.fisheye.dvcs.client.BaseLineOutputHandler;
import com.atlassian.utils.process.LineReadable;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.Watchdog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

public abstract class DvcsLineOutputHandler
extends BaseLineOutputHandler {
    private Watchdog watchdog;
    private List<Watchdog> outerWatchdogs = new ArrayList<Watchdog>(2);
    private final boolean unicodeLineBreaks;

    protected DvcsLineOutputHandler(Charset encoding, boolean unicodeLineBreaks) {
        super(encoding);
        this.unicodeLineBreaks = unicodeLineBreaks;
    }

    public void setWatchdog(Watchdog watchdog) {
        super.setWatchdog(watchdog);
        this.watchdog = watchdog;
    }

    public Watchdog getWatchdog() {
        return this.watchdog;
    }

    public void clearWatchdogs() {
        this.watchdog = null;
        this.outerWatchdogs.clear();
    }

    public void addOuterWatchdog(Watchdog watchdog) {
        this.outerWatchdogs.add(watchdog);
    }

    protected void resetWatchdog() {
        super.resetWatchdog();
        for (Watchdog outerWatchdog : this.outerWatchdogs) {
            outerWatchdog.resetWatchdog();
        }
    }

    public void process(InputStream output) throws ProcessException {
        if (!this.unicodeLineBreaks) {
            super.process(output);
        } else if (this.getEncoding() == null) {
            this.process(new ScannerLineReader(new BufferedReader(new InputStreamReader(output))));
        } else {
            try {
                this.process(new ScannerLineReader(new BufferedReader(new InputStreamReader(output, this.getEncoding()))));
            }
            catch (UnsupportedEncodingException e2) {
                throw new ProcessException((Throwable)e2);
            }
        }
    }

    protected boolean isCanceled() {
        return this.watchdog != null && super.isCanceled();
    }

    private static class ScannerLineReader
    implements LineReadable {
        private static final String LINE_SEPARATOR_PATTERN_STR = "\r\n|[\n\r\u2028\u2029\u0085]";
        private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r\n|[\n\r\u2028\u2029\u0085]");
        private final Scanner scanner;

        public ScannerLineReader(Readable reader) {
            this.scanner = new Scanner(reader);
            this.scanner.useDelimiter(LINE_SEPARATOR_PATTERN);
        }

        public String readLine() throws IOException {
            return this.scanner.hasNext() ? this.scanner.next() : null;
        }

        public void close() throws IOException {
            this.scanner.close();
        }
    }
}

