/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs.client;

import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fisheye.dvcs.DvcsScmConfig;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsProcessFactory;
import com.atlassian.fisheye.dvcs.client.DvcsProcessMonitor;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringObfuscator;
import com.atlassian.utils.process.StringOutputHandler;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.rep.activity.ActivityLogMonitor;
import com.cenqua.fisheye.util.NamedProcessHandler;
import com.cenqua.fisheye.util.UrlUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public abstract class DvcsContext {
    protected static final String FISHEYE_CLONEPROPS = "fe_clone.properties";
    public static final String CLONE_DIR = "clone";
    public static final StringObfuscator OBFUSCATOR = new StringObfuscator(){
        private static final String WARNING_PATTERN_STRING = "(remote:\\s)?Warning: Permanently added.*? to the list of known hosts.\\s*";

        public String obfuscate(String string) {
            return UrlUtils.obfucscatePasswordsInString(string.replaceAll(WARNING_PATTERN_STRING, ""));
        }
    };
    public static final ProcessMonitor LOGGING_MONITOR = new DvcsProcessMonitor(Logs.APP_LOG, (Priority)Level.DEBUG, OBFUSCATOR);
    private File repoLocation;
    private String path;
    private String name;
    protected RepositoryConfig config;
    protected ProcessMonitor activityMonitor;
    private SshKeyManager sshKeyManager;
    private Set<ExternalProcess> runningProcesses = Sets.newConcurrentHashSet();
    private DvcsProcessFactory dvcsProcessFactory;

    protected DvcsContext() {
    }

    public DvcsContext(RepositoryConfig config) {
        this.config = config;
        this.name = config.getName();
        DvcsScmConfig dvcsConfig = (DvcsScmConfig)config.getScmConfig();
        this.repoLocation = new File(this.getCacheDir(), CLONE_DIR);
        this.path = dvcsConfig.getPath();
        this.activityMonitor = new ActivityLogMonitor(config.getStatus().getRecentActivities(), OBFUSCATOR);
        this.dvcsProcessFactory = dvcsConfig.getDvcsProcessFactory();
    }

    public void storeCloneDetails() throws ConfigException {
        File fePropsFile = new File(this.getRepoLocation(), FISHEYE_CLONEPROPS);
        Properties props = new Properties();
        props.put("location", this.getScmConfig().getRemoteLocation());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fePropsFile);
            props.store(fos, "FishEye DVCS repository info");
        }
        catch (IOException e2) {
            try {
                throw new ConfigException(e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(fos);
                throw throwable;
            }
        }
        IOHelper.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCloneDetails() {
        String string;
        File fePropsFile = new File(this.getRepoLocation(), FISHEYE_CLONEPROPS);
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fePropsFile);
            props.load(fis);
            string = props.getProperty("location");
        }
        catch (IOException e2) {
            try {
                Logs.APP_LOG.debug((Object)"Unable to read DVCS repo info", (Throwable)e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(fis);
                throw throwable;
            }
            IOHelper.close(fis);
            return null;
        }
        IOHelper.close(fis);
        return string;
    }

    public File getCacheDir() {
        return this.config.getCacheDir();
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepositoryConfig getConfig() {
        return this.config;
    }

    public void setConfig(RepositoryConfig config) {
        this.config = config;
    }

    public SshKeyManager getSshKeyManager() {
        if (this.sshKeyManager == null) {
            try {
                this.sshKeyManager = (SshKeyManager)SpringContext.getComponent("sshKeyManager");
            }
            catch (RuntimeException e2) {
                this.config.getStatus().throwOnStopRequested();
                throw e2;
            }
        }
        return this.sshKeyManager;
    }

    public abstract DvcsScmConfig getScmConfig();

    public void setPath(String path) {
        this.path = path;
    }

    public File getRepoLocation() {
        return this.repoLocation;
    }

    public String getPath() {
        return this.path;
    }

    public Path getLocalPath(String serverPath) {
        return new Path(serverPath).getRelativePath(new Path(this.path));
    }

    public abstract Set<Branch> getBranchesInLocalRepo() throws DvcsProcessException;

    protected long getCommandTimeout() {
        DvcsScmConfig dvcsConfig = (DvcsScmConfig)this.config.getScmConfig();
        return dvcsConfig.getCommandTimeout().getValueInMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getServerPath(Path localPath) {
        String serverPath = localPath.isRoot() ? this.path : (this.path.trim().length() == 0 ? localPath.getPath() : this.path + "/" + localPath.getPath());
        return serverPath;
    }

    public abstract String getMainBranchName();

    public boolean isPathInRepo(String serverPath) {
        return this.isPathInRepo(this.getLocalPath(serverPath));
    }

    public boolean isPathInRepo(Path localPath) {
        if (localPath.isAbove()) {
            return false;
        }
        AllowRules allowRules = this.getConfig().getAllowRules();
        if (allowRules != null) {
            Path path = localPath;
            while (!path.isRoot()) {
                if (allowRules.isIgnored(path)) {
                    return false;
                }
                path = path.getParent();
            }
        }
        return true;
    }

    public void executeCommand(DvcsCommandBuilder command, OutputHandler outputHandler) throws DvcsProcessException {
        this.executeWithInput(command, outputHandler, null);
    }

    public void executeWithInput(DvcsCommandBuilder command, OutputHandler outputHandler, InputHandler inputHandler) throws DvcsProcessException {
        NamedProcessHandler handler = new NamedProcessHandler(this.name);
        handler.setOutputHandler(outputHandler);
        StringOutputHandler errors = new StringOutputHandler();
        handler.setErrorHandler((OutputHandler)errors);
        if (inputHandler != null) {
            handler.setInputHandler(inputHandler);
        }
        try {
            this.executeCommand(command, handler);
        }
        catch (ProcessException e2) {
            throw new DvcsProcessException("Error while communicating with VCS: " + OBFUSCATOR.obfuscate(errors.getOutput()), e2);
        }
    }

    public void executeCommand(DvcsCommandBuilder command, PluggableProcessHandler handler) throws ProcessException {
        File repoLocation = this.getRepoLocation();
        if (!repoLocation.exists()) {
            throw new IllegalStateException("Clone has not been created");
        }
        this.executeCommand(command, (ProcessHandler)handler, repoLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(DvcsCommandBuilder command, ProcessHandler handler, File workingDir) throws ProcessException {
        if (this.config.getStatus().isStopRequested()) {
            throw new StopRequestedException();
        }
        ExternalProcess process = ((DvcsProcessFactory.DvcsProcessBuilder)this.dvcsProcessFactory.builder((DvcsScmConfig)this.config.getScmConfig(), command, handler, workingDir).monitor(this.activityMonitor)).build();
        try {
            this.runningProcesses.add(process);
            process.execute();
        }
        finally {
            this.runningProcesses.remove(process);
        }
        if (handler.isCanceled() && this.config.getStatus().isStopRequested()) {
            Logs.APP_LOG.debug((Object)("Execution cancelled: \"" + OBFUSCATOR.obfuscate(process.getCommandLine()) + "\" in [" + workingDir + "]"));
            throw new StopRequestedException();
        }
        if (!handler.succeeded()) {
            throw new ProcessException("While executing: \"" + OBFUSCATOR.obfuscate(process.getCommandLine()) + "\" in [" + workingDir + "]", (Throwable)handler.getException());
        }
    }

    public void cancelRunningProcesses() {
        HashSet<ExternalProcess> processes = new HashSet<ExternalProcess>(this.runningProcesses);
        for (ExternalProcess process : processes) {
            if (!process.isAlive()) continue;
            process.cancel();
        }
    }
}

