/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.atlassian.fecru.security.Credentials;
import com.atlassian.fecru.security.PasswordCredentials;
import com.atlassian.fecru.security.SshKeyCredentials;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.client.DvcsProcessFactory;
import com.atlassian.fisheye.scmapi.BaseScmConfig;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.PasswordAuthenticationType;
import com.cenqua.fisheye.config1.SshKeyAuthenticationType;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.IntervalUtils;
import com.cenqua.fisheye.util.UrlUtils;
import java.io.File;
import java.nio.charset.Charset;

public abstract class DvcsScmConfig
extends BaseScmConfig {
    private static final Interval DEFAULT_COMMAND_TIMEOUT = new Interval(1L, 2);
    private long pollPeriod;
    private String location;
    private String path;
    private int blockSize;
    private Interval commandTimeout;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private Charset encoding;
    private final SshKeyManager sshKeyManager;
    private final DvcsProcessFactory dvcsProcessFactory;

    public DvcsScmConfig(int cacheVersion, RootConfig rootConfig, SshKeyManager sshKeyManager, DvcsProcessFactory dvcsProcessFactory) {
        super(cacheVersion, rootConfig);
        this.sshKeyManager = sshKeyManager;
        this.dvcsProcessFactory = dvcsProcessFactory;
    }

    protected long getDefaultPollPeriod() {
        String defaultPollPeriod = this.defaults != null && this.defaults.isSetUpdater() ? this.defaults.getUpdater().getPolled().getPollPeriod() : null;
        return IntervalUtils.convertStringToLongOrNever(defaultPollPeriod, 60000L);
    }

    public void setPollPeriod(long pollPeriod) {
        this.pollPeriod = pollPeriod;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public static int getDefaultBlockSize() {
        return 1000;
    }

    public void setCommandTimeout(Interval timeout) {
        this.commandTimeout = timeout;
    }

    public static Interval getDefaultCommandTimeout() {
        return DEFAULT_COMMAND_TIMEOUT;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    protected SshKeyManager getSshKeyManager() {
        return this.sshKeyManager;
    }

    protected Credentials createCredentials(PasswordAuthenticationType auth) {
        return new PasswordCredentials(auth.getPassword());
    }

    protected Credentials createCredentials(SshKeyAuthenticationType auth) {
        File privateKey = new File(this.getSshKeyManager().getPrivateKeyPath(auth.getKeyName()));
        return new SshKeyCredentials(privateKey, auth.getPassphrase());
    }

    public String getRemoteLocationWithCredentials() {
        String remoteUrl = this.getRemoteLocation();
        Credentials credentials = this.getCredentials();
        if (credentials instanceof PasswordCredentials) {
            PasswordCredentials basicCred = (PasswordCredentials)credentials;
            remoteUrl = UrlUtils.addAuthentication(remoteUrl, null, basicCred.getPassword());
        }
        return remoteUrl;
    }

    public String getRemoteLocation() {
        return this.getLocation();
    }

    public String getPath() {
        return this.path;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public Interval getCommandTimeout() {
        return this.commandTimeout;
    }

    public abstract String getExecutable();

    public abstract Credentials getCredentials();

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    protected void executeCommand(DvcsCommandBuilder command, PluggableProcessHandler handler, long timeout, ProcessMonitor ... monitors) throws ProcessException {
        ExternalProcess process = ((DvcsProcessFactory.DvcsProcessBuilder)((DvcsProcessFactory.DvcsProcessBuilder)this.dvcsProcessFactory.builder(this, command, (ProcessHandler)handler, null).monitor(monitors)).timeout(timeout)).build();
        process.execute();
        if (!handler.succeeded()) {
            throw new ProcessException("While executing: \"" + UrlUtils.obfucscatePasswordsInString(process.getCommandLine()) + "\"", (Throwable)handler.getException());
        }
    }

    public boolean isSshAuthenticatedRepo() {
        return this.getCredentials() instanceof SshKeyCredentials;
    }

    public DvcsProcessFactory getDvcsProcessFactory() {
        return this.dvcsProcessFactory;
    }
}

