/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.db.PersistentStringSet;
import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.DvcsUtils;
import com.atlassian.fisheye.dvcs.client.DvcsChangeParser;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.BaseRepositoryScanner;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingState;
import com.cenqua.fisheye.rep.LifecycleRepositoryScanner;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.FileUtils;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.BiDiBitSet;
import com.cenqua.fisheye.util.bitset.BitSets;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexWriter;

public abstract class DvcsScanner<F extends DvcsRevInfo, CS extends ChangeSetImpl<F>, C extends DvcsCache<F, CS, T>, T extends CommonStringTables>
extends LifecycleRepositoryScanner<C> {
    private static final int MAX_DELETE_SIZE = 1000;
    private static final Logger log = Logs.loggerFor(DvcsScanner.class);
    protected PersistentStringSet commitsProcessed;
    private Map<String, String> lastCommitProcessedOnBranch = new HashMap<String, String>();
    private String lastNonBranchCommit = null;

    protected DvcsScanner(BaseRepositoryEngine<? extends BaseRepositoryScanner<C>, C> engine) {
        super(engine);
    }

    @Override
    protected void validateRepository() throws ConfigException {
    }

    @Override
    public void start(C newCache) throws DbException, ConfigException {
        super.start(newCache);
        this.commitsProcessed = new PersistentStringSet(((BaseRevisionCache)newCache).getInfDb(), DvcsSchema.E_CHANGESET_ADDED);
    }

    @Override
    public void stop() {
        this.getContext().cancelRunningProcesses();
    }

    protected Set<String> getCommitsProcessed() {
        return this.commitsProcessed;
    }

    protected void addProcessedCommit(String branch, String csid) {
        this.commitsProcessed.add(csid);
        if (branch != null) {
            this.lastCommitProcessedOnBranch.put(branch, csid);
        } else {
            this.lastNonBranchCommit = csid;
        }
    }

    protected abstract boolean slurpCommits(String var1, List<String> var2) throws DvcsProcessException, LicensePolicyException, DbException;

    protected abstract DvcsChangeParser getChangeParser();

    protected abstract String getRevisionContentKey(DvcsRevInfo var1);

    protected String obfuscate(String value) {
        return DvcsContext.OBFUSCATOR.obfuscate(value);
    }

    protected Set<String> getUpdatedCommits() {
        return null;
    }

    protected void resetCommitsProcessed() {
        this.commitsProcessed.clear();
        this.lastCommitProcessedOnBranch.clear();
        this.lastNonBranchCommit = null;
    }

    @Override
    protected boolean updateLocalRepoClone() throws ConfigException {
        boolean updateOccurred = false;
        if (!this.getContext().getRepoLocation().exists()) {
            this.cloneRepo();
            updateOccurred = true;
        } else {
            String repoLocation = this.getContext().getCloneDetails();
            if (!this.getContext().getScmConfig().getRemoteLocation().equals(repoLocation)) {
                this.cloneRepo();
                updateOccurred = true;
            } else {
                this.getStatus().setMessage("Getting updates from " + this.getContext().getScmConfig().getRemoteLocation());
                updateOccurred = this.fetchLatest();
                this.getStatus().setMessage("Updated from " + this.getContext().getScmConfig().getRemoteLocation());
            }
        }
        return updateOccurred;
    }

    protected void cloneRepo() throws ConfigException {
        File cloneLocation = this.getContext().getRepoLocation();
        this.getStatus().setMessage("Cloning repository from " + this.getContext().getScmConfig().getRemoteLocation());
        if (cloneLocation.exists()) {
            FileUtils.deleteTree(cloneLocation);
        } else if (!cloneLocation.getParentFile().exists() && !cloneLocation.getParentFile().mkdirs()) {
            throw new ConfigException("Unable to create directory for dvcs clone: " + cloneLocation.getParentFile());
        }
        this.performClone(cloneLocation);
        this.getStatus().setMessage("Repository cloned from " + this.getContext().getScmConfig().getRemoteLocation());
    }

    protected abstract void performClone(File var1) throws ConfigException;

    @Override
    public long reindexChangesets(Long endChangesetIndex, EggTimer eggTimer) throws DbException {
        List<String> commits = ((DvcsCache)this.getCache()).getCommitList();
        endChangesetIndex = endChangesetIndex == null ? (long)commits.size() : endChangesetIndex + 1L;
        int blockSize = 1000;
        Set<Branch> branches = ((DvcsCache)this.getCache()).getBranches();
        this.getBranchCrossRepoIndexer().indexBranches(Sets.filter(branches, Branch.inState(BranchState.REMOVED)), this.cache, this.getStatus());
        int endBatchIndex = Ints.checkedCast((long)endChangesetIndex);
        while ((long)endBatchIndex > -1L) {
            this.getStatus().throwOnStopRequested();
            int startBatchIndex = Math.max(endBatchIndex - blockSize, 0);
            this.setStatusReindexingChangesets(endBatchIndex, startBatchIndex);
            Timer timer = this.startIndexingTimer(startBatchIndex, endBatchIndex);
            List csidBatch = commits.subList(startBatchIndex, endBatchIndex);
            csidBatch = Lists.reverse(csidBatch);
            Set<String> indexableChangesets = this.indexChangesets(null, csidBatch);
            this.getBranchCrossRepoIndexer().indexBranchesForChangeSetIds(csidBatch, branches, this.cache, this.status);
            this.indexMetadataBatch(indexableChangesets, true);
            this.stopIndexingTimer(timer, csidBatch.size());
            if (eggTimer.isTimeExpired()) {
                return startBatchIndex == 0 ? -1L : Integer.valueOf(startBatchIndex).longValue();
            }
            endBatchIndex -= blockSize;
        }
        return -1L;
    }

    protected abstract Branch prepareBranchToBeStored(@Nullable Branch var1, @Nullable Branch var2);

    protected boolean updateBranchHead(@Nullable Branch branchInCache, @Nullable Branch branchInScm) {
        log.debug((Object)("[updateBranchHead] oldBranch: " + branchInCache + ", newBranch: " + branchInScm));
        if (branchInCache == null || branchInScm == null || !branchInCache.equals(branchInScm)) {
            Branch updatedBranch = this.prepareBranchToBeStored(branchInCache, branchInScm);
            log.debug((Object)("[updateBranchHead] persisting " + updatedBranch));
            ((DvcsCache)this.getCache()).getBranchDAO().store(updatedBranch, true);
            this.getBranchCrossRepoIndexer().indexBranches((Iterable<Branch>)Collections.singleton(updatedBranch), this.getCache(), this.getStatus());
            return true;
        }
        return false;
    }

    protected Set<Branch> getBranchesToSlurp() throws DvcsProcessException, DbException {
        return this.getContext().getBranchesInLocalRepo();
    }

    protected String getRemoteLocationWithCredentials() {
        return this.getContext().getScmConfig().getRemoteLocationWithCredentials();
    }

    protected Map<String, Branch> toBranchMap(Set<Branch> branches) {
        HashMap<String, Branch> branchMap = new HashMap<String, Branch>();
        for (Branch branch : branches) {
            branchMap.put(branch.getName(), branch);
        }
        return branchMap;
    }

    @Override
    protected boolean processRevisions() throws DbException, RepositoryClientException {
        try {
            Branch mainBranch;
            boolean updateOccurred = false;
            Map<String, Branch> previousBranchHeads = this.toBranchMap(Sets.filter(((DvcsCache)this.getCache()).getBranches(), Branch.NOT_REMOVED));
            Map<String, Branch> branchesToSlurp = this.toBranchMap(this.getBranchesToSlurp());
            if (branchesToSlurp.isEmpty()) {
                log.debug((Object)("No branches found in '" + this.getContext().getName() + "'."));
            }
            this.getStatus().clearEngineError();
            if (this.preProcessBranches()) {
                updateOccurred = true;
                ((DvcsCache)this.getCache()).commit();
            }
            if ((mainBranch = branchesToSlurp.get(this.getContext().getMainBranchName())) != null && this.processBranch(mainBranch)) {
                updateOccurred = true;
                ((DvcsCache)this.getCache()).commit();
            }
            for (Branch branch : branchesToSlurp.values()) {
                if (this.isStopRequested()) break;
                if (branch.equals(mainBranch) || !this.processBranch(branch)) continue;
                updateOccurred = true;
                ((DvcsCache)this.getCache()).commit();
            }
            if (!this.isStopRequested()) {
                for (Map.Entry entry : previousBranchHeads.entrySet()) {
                    if (branchesToSlurp.containsKey(entry.getKey())) continue;
                    log.debug((Object)("Late deleting branch " + entry));
                    if (!this.updateBranchHead((Branch)entry.getValue(), null)) continue;
                    updateOccurred = true;
                    ((DvcsCache)this.getCache()).commit();
                }
            }
            if (this.postProcessBranches()) {
                updateOccurred = true;
                ((DvcsCache)this.getCache()).commit();
            }
            if (!this.isStopRequested()) {
                this.getStatus().setMessage("Updating changeset index");
                this.indexScannedChangesets();
                this.getStatus().setMessage("");
                if (!AppConfig.Hacks.DISABLE_TAGS && this.processTags()) {
                    updateOccurred = true;
                }
            }
            if (!this.isStopRequested()) {
                Set<String> newCommits = this.getCommitsProcessed();
                Set<String> set = this.getUpdatedCommits();
                if (set != null && newCommits != null) {
                    set.removeAll(newCommits);
                }
                this.indexChangesets(newCommits, set);
            }
            if (!this.isStopRequested()) {
                Map<String, Branch> currentBranchHeads = this.toBranchMap(((DvcsCache)this.getCache()).getBranches());
                if (updateOccurred && !AppConfig.Hacks.DISABLE_HEAD_DETECION) {
                    this.updateManifestsForBranches(previousBranchHeads, currentBranchHeads);
                }
            }
            if (!this.isStopRequested() && updateOccurred) {
                ((DvcsCache)this.getCache()).setIndexingPhase(IndexingState.INDEXING_METADATA);
                ((DvcsCache)this.getCache()).commit();
            }
            this.resetCommitsProcessed();
            return updateOccurred;
        }
        catch (DvcsProcessException e2) {
            throw new RepositoryClientException(e2);
        }
    }

    protected boolean preProcessBranches() throws DvcsProcessException {
        return false;
    }

    protected boolean postProcessBranches() throws DvcsProcessException {
        return false;
    }

    protected void indexScannedChangesets() {
        Set<String> newCommits = this.getCommitsProcessed();
        this.indexChangesets(newCommits, null);
    }

    protected boolean updateManifestsForBranches(Map<String, Branch> preSlurpBranches, Map<String, Branch> slurpedBranches) throws DvcsProcessException, DbException {
        for (Map.Entry<String, Branch> slurpedBranch : slurpedBranches.entrySet()) {
            Branch curBranch = ((DvcsCache)this.getCache()).getBranch(slurpedBranch.getKey());
            if (curBranch == null || curBranch.getState() == BranchState.REMOVED) continue;
            Branch prevBranch = preSlurpBranches.get(curBranch.getName());
            if (curBranch.getLatestChangeSetId() == null || prevBranch != null && curBranch.getLatestChangeSetId().equals(prevBranch.getLatestChangeSetId())) continue;
            this.getStatus().setMessage("Updating list of head file revisions on branch " + slurpedBranch.getKey());
            Timer timer = new Timer("updating manifest for branch '" + slurpedBranch.getKey() + "'");
            this.updateBranchManifest(prevBranch, curBranch);
            timer.end();
        }
        return true;
    }

    protected void updateBranchManifest(Branch from, Branch to) throws DvcsProcessException {
        if (to != null && to.getLatestChangeSetId() != null) {
            ((DvcsCache)this.getCache()).rebuildHeadsOnBranch(to);
        }
    }

    protected abstract boolean processTags() throws DvcsProcessException, DbException;

    private Branch getOrCreateBranch(String branchName) throws DbException {
        Branch branchInCache = ((DvcsCache)this.getCache()).getBranch(branchName);
        if (branchInCache == null) {
            log.debug((Object)("Created " + branchName));
            branchInCache = new Branch(branchName, null, BranchState.ACTIVE);
            ((DvcsCache)this.getCache()).storeBranch(branchInCache);
        }
        return branchInCache;
    }

    protected void updateBranchHeads() throws DbException {
        for (Map.Entry<String, String> entry : this.lastCommitProcessedOnBranch.entrySet()) {
            Branch oldBranch = this.getOrCreateBranch(entry.getKey());
            String newHeadCsId = entry.getValue();
            if (Objects.equal((Object)oldBranch.getLatestChangeSetId(), (Object)newHeadCsId)) continue;
            Branch newBranch = oldBranch.clone();
            newBranch.setLatestChangeSetId(newHeadCsId);
            this.updateBranchHead(oldBranch, newBranch);
        }
    }

    protected String getLastCommitProcessedDuringBranchIndexing(String branchName, List<String> processedCommits) {
        String lastCommit;
        if (branchName == null) {
            lastCommit = this.lastNonBranchCommit;
        } else {
            lastCommit = this.lastCommitProcessedOnBranch.get(branchName);
            if (lastCommit == null) {
                lastCommit = processedCommits.get(processedCommits.size() - 1);
            }
        }
        return lastCommit;
    }

    protected String getLastNonBranchCommit() {
        return this.lastNonBranchCommit;
    }

    protected boolean processBranch(Branch branchInScm) throws DbException, DvcsProcessException {
        this.getChangeParser().setBranch(branchInScm.getName());
        final Branch branchInCache = this.getOrCreateBranch(branchInScm.getName());
        String currentIndexedHead = branchInCache.getLatestChangeSetId();
        boolean updateOccurred = false;
        String branchHead = branchInScm.getLatestChangeSetId();
        if (currentIndexedHead == null || !DvcsUtils.hashEquals(currentIndexedHead, branchHead)) {
            Timer timer = new Timer("Processing Branch " + branchInScm.getName() + " of " + this.getContext().getName());
            this.getStatus().setMessage("Indexing changes on branch " + branchInScm.getName());
            log.debug((Object)("[" + this.getContext().getName() + "] " + "Branch " + branchInScm.getName() + ": head in SCM is " + branchHead + ", head in FE cache is " + currentIndexedHead));
            final String commitStreamName = branchInScm.getName();
            updateOccurred = this.processCommitStream(commitStreamName, currentIndexedHead, branchHead, new Function<List<String>, String>(){

                public String apply(@Nullable List<String> commits) {
                    DvcsScanner.this.updateBranchHeads();
                    String lastCommit = DvcsScanner.this.getLastCommitProcessedDuringBranchIndexing(commitStreamName, commits);
                    branchInCache.setLatestChangeSetId(lastCommit);
                    return lastCommit;
                }
            });
            timer.end();
        }
        currentIndexedHead = branchInCache.getLatestChangeSetId();
        if (!this.isStopRequested()) {
            if ((currentIndexedHead == null || !DvcsUtils.hashEquals(currentIndexedHead, branchInScm.getLatestChangeSetId())) && ((DvcsCache)this.getCache()).existsChangeSet(branchInScm.getLatestChangeSetId())) {
                this.updateBranchHead(branchInCache, branchInScm);
                ((DvcsCache)this.getCache()).commit();
                updateOccurred = true;
            } else if (!branchInScm.getState().equals((Object)branchInCache.getState())) {
                Branch newBranch = branchInCache.clone();
                newBranch.setState(branchInScm.getState());
                this.updateBranchHead(branchInCache, newBranch);
                updateOccurred = true;
            }
        }
        return updateOccurred;
    }

    protected boolean processCommitStream(String commitStreamName, String commitStreamStart, String commitStreamEnd, Function<List<String>, String> onUpdateFunction) throws DvcsProcessException {
        boolean updateOccurred = false;
        List<String> commits = this.getUnseenCommits(commitStreamStart, commitStreamEnd, commitStreamName);
        while (!(this.isLicenseLimitReached() || commits.isEmpty() || this.isStopRequested())) {
            try {
                updateOccurred |= this.slurpCommits(commitStreamStart, commits);
                this.clearLicensePolicyReached();
            }
            catch (LicensePolicyException e2) {
                updateOccurred = this.setLicensePolicyReached(e2);
            }
            if (updateOccurred && !this.isStopRequested()) {
                this.updateBranchHeads();
                String lastCommit = (String)onUpdateFunction.apply(commits);
                this.getStatus().setMessage("Committing changes " + (commitStreamStart != null ? commitStreamStart : "") + ".." + lastCommit + " on " + commitStreamName);
                log.debug((Object)("[" + this.getContext().getName() + "] " + "Committing changes up to revision " + lastCommit));
                ((DvcsCache)this.getCache()).commit();
                if (commitStreamStart != null && lastCommit.startsWith(commitStreamStart)) break;
                commitStreamStart = lastCommit;
                commits = this.getUnseenCommits(commitStreamStart, commitStreamEnd, commitStreamName);
                continue;
            }
            ((DvcsCache)this.getCache()).rollback();
        }
        return updateOccurred;
    }

    @Override
    protected boolean setLicensePolicyReached(LicensePolicyException e2) {
        boolean breached = super.setLicensePolicyReached(e2);
        if (breached) {
            log.warn((Object)("You may be able to adjust committer names if you have used multiple email addresses per committer. Please see " + LicenseEnforcer.DVCS_DETAILS_LINK));
        }
        return breached;
    }

    protected Set<String> updateChangesetIndex(Collection<String> changesetIds, boolean isUpdate) throws DbException {
        LinkedHashSet<String> indexedChangeSets = new LinkedHashSet<String>();
        if (changesetIds != null && !changesetIds.isEmpty()) {
            Timer t2 = new Timer("updating " + changesetIds.size() + " changesets: isUpdate=" + isUpdate);
            boolean hasPre24Changesets = isUpdate && this.indexingContext.getCrossRepLuceneIndex().getRescanStatus((RevisionCache)this.getCache()).needsPre24ChangesetHandling();
            this.getChangesetIndexer().indexChangesetsAndAuthors(((DvcsCache)this.getCache()).getCrossRepLuceneConnection(), (ChangeSetResolver)this.getCache(), (Iterable<String>)changesetIds, this.getStatus(), isUpdate, (Collection<String>)indexedChangeSets, hasPre24Changesets);
            t2.end();
        }
        return indexedChangeSets;
    }

    protected Set<String> indexChangesets(Collection<String> newCommits, Collection<String> updatedCommits) throws DbException {
        Timer timer = new Timer("Indexing changesets of " + this.getContext().getName());
        Set<String> indexableChangesets = this.updateChangesetIndex(newCommits, false);
        Set<String> updatedChangesets = this.updateChangesetIndex(updatedCommits, true);
        timer.end();
        return Sets.union(indexableChangesets, updatedChangesets);
    }

    @Override
    protected boolean processMetadata() throws DbException {
        Timer timer = new Timer("Processing Metadata of " + this.getContext().getName());
        long start = System.currentTimeMillis();
        boolean updateOccurred = false;
        if (!this.isStopRequested()) {
            int startRevid = (int)((DvcsCache)this.getCache()).getScanProperty(CommonProperties.META_REVID.toString(), 0L) + 1;
            int latestRevid = ((DvcsCache)this.getCache()).getCommonRevInfoDAO().getLatestRevid();
            if (latestRevid != -1 && startRevid <= latestRevid) {
                this.indexMetadata(startRevid, latestRevid);
                if (!this.isStopRequested()) {
                    updateOccurred = true;
                    log.debug((Object)("[" + this.getRepoName() + "]   metadata index took: " + (System.currentTimeMillis() - start) / 1000L + "s. " + (latestRevid - startRevid) + " changesets"));
                } else {
                    ((DvcsCache)this.getCache()).rollback();
                }
            }
        }
        if (!this.isStopRequested()) {
            ((DvcsCache)this.getCache()).setIndexingPhase(IndexingState.INDEXING_CONTENT);
            ((DvcsCache)this.getCache()).commit();
        }
        timer.end();
        return updateOccurred;
    }

    @Override
    protected void resetScmMetaData() {
        ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.META_REVID.toString(), 0L);
        ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.CONTENT_REVID.toString(), 0L);
    }

    protected void indexMetadata(int startRevid, int latestRevid) throws DbException {
        Timer timer = new Timer("Indexing metadata of " + this.getContext().getName());
        BiDiBitSet revidSet = new BiDiBitSet();
        revidSet.set(startRevid, latestRevid + 1);
        CommonRevInfoDAO commonDAO = ((DvcsCache)this.getCache()).getCommonRevInfoDAO();
        HashSet<String> commits = new HashSet<String>();
        while (revidSet.cardinality() != 0) {
            int revid = revidSet.nextSetBit(0);
            RevInfoKey key = commonDAO.getKey(revid);
            commits.add(key.getRev());
            IntList commitRevids = commonDAO.getChangeSetRevids(key.getRev());
            for (Integer commitRevid : commitRevids) {
                revidSet.clear(commitRevid);
            }
            if (commits.size() < this.getContext().getScmConfig().getBlockSize()) continue;
            this.indexMetadataBatch(commits, false);
            int uptoRevid = revidSet.nextSetBit(0) - 1;
            ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.META_REVID.toString(), uptoRevid);
            ((DvcsCache)this.getCache()).commit();
            commits.clear();
        }
        this.indexMetadataBatch(commits, false);
        ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.META_REVID.toString(), latestRevid);
        ((DvcsCache)this.getCache()).commit();
        timer.end();
    }

    private void indexMetadataBatch(Set<String> commits, boolean crossRepoIndexOnly) throws DbException {
        if (commits.isEmpty()) {
            return;
        }
        this.getPathCrossRepoIndexer().indexPathsForChangeSetIds(this.getRepoName(), this.getCache(), (Iterable<String>)commits, this.getPathMatcher(), this.getStatus());
    }

    @Override
    protected boolean processContent() throws DbException, RepositoryClientException {
        try {
            boolean updateOccurred = false;
            if (!this.isStopRequested()) {
                int startRevid = (int)((DvcsCache)this.getCache()).getScanProperty(CommonProperties.CONTENT_REVID.toString(), 0L) + 1;
                int latestRevid = ((DvcsCache)this.getCache()).getCommonRevInfoDAO().getLatestRevid();
                log.info((Object)("[" + this.getRepoName() + "] Indexing content from: " + startRevid + " to " + latestRevid));
                if (latestRevid != -1 && startRevid <= latestRevid) {
                    this.indexContent(startRevid, latestRevid);
                    if (this.isStopRequested()) {
                        ((DvcsCache)this.getCache()).rollback();
                    } else {
                        updateOccurred = true;
                    }
                }
            }
            if (!this.isStopRequested()) {
                ((DvcsCache)this.getCache()).setIndexingPhase(IndexingState.PROCESSING_REVISIONS);
                ((DvcsCache)this.getCache()).commit();
            }
            return updateOccurred;
        }
        catch (DvcsProcessException e2) {
            throw new RepositoryClientException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexContent(int startRevid, int latestRevid) throws DbException, DvcsProcessException {
        log.info((Object)("[" + this.getRepoName() + "] Indexing content from: " + startRevid + " to " + latestRevid));
        Timer timer = new Timer("Indexing Content of " + this.getContext().getName());
        BiDiBitSet revidSet = new BiDiBitSet();
        revidSet.set(startRevid, latestRevid + 1);
        SortedIntSet paths = ((DvcsCache)this.getCache()).getCommonRevInfoDAO().getLongProperySet(DvcsSchema.I_REVID_PATHID, revidSet);
        long lastPathId = ((DvcsCache)this.getCache()).getScanProperty(CommonProperties.CONTENT_LASTPATHID.value, -1L);
        if (lastPathId != -1L) {
            BitSets.clear(paths, 0L, lastPathId);
        }
        boolean indexedOk = false;
        try {
            this.deleteContent(paths);
            this.indexUpdatedContent(paths);
            if (!this.isStopRequested()) {
                indexedOk = true;
            }
        }
        finally {
            if (!indexedOk) {
                this.deleteContent(paths);
            }
        }
        ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.CONTENT_REVID.toString(), latestRevid);
        ((DvcsCache)this.getCache()).commit();
        timer.end();
    }

    private void indexUpdatedContent(SortedIntSet paths) throws DbException, DvcsProcessException {
        Timer timer = new Timer("Indexing Updated Content of " + this.getContext().getName());
        int pathIndex = 0;
        int count = paths.cardinality();
        HashMultimap revisions = HashMultimap.create();
        int pathId = paths.nextSetBit(0);
        while (pathId >= 0 && !this.isStopRequested()) {
            ++pathIndex;
            Path path = ((DvcsCache)this.getCache()).getCommonRevInfoDAO().getPath(pathId);
            String commit = this.getDvcsRevInfoDAO().getLatestPathChange(path);
            int revid = ((DvcsCache)this.getCache()).getCommonRevInfoDAO().getRevId(path, commit);
            DvcsRevInfo revision = (DvcsRevInfo)this.getDvcsRevInfoDAO().load(revid);
            if (revision != null && !revision.isDead()) {
                if (revision.isBinary()) {
                    log.debug((Object)("[" + this.getContext().getName() + "] " + "Not indexing HEAD contents of " + path + " as file is binary"));
                } else if (revision.getFileType() != 1) {
                    log.debug((Object)("[" + this.getContext().getName() + "] " + "Not indexing contents of HEAD of " + path + " as this is not a file"));
                } else {
                    this.getStatus().setMessageForIndexingContent(path, pathIndex, count);
                    revisions.put((Object)this.getRevisionContentKey(revision), (Object)revision);
                    if (revisions.size() >= this.getContext().getScmConfig().getBlockSize()) {
                        this.indexContentBlock((Multimap<String, DvcsRevInfo>)revisions);
                        revisions.clear();
                        ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.CONTENT_LASTPATHID.value, pathId);
                        ((DvcsCache)this.getCache()).commit();
                        BitSets.clear(paths, 0L, pathId);
                    }
                }
            }
            pathId = paths.nextSetBit(pathId + 1);
        }
        this.indexContentBlock((Multimap<String, DvcsRevInfo>)revisions);
        ((DvcsCache)this.getCache()).setScanProperty(CommonProperties.CONTENT_LASTPATHID.value, -1L);
        ((DvcsCache)this.getCache()).commit();
        BitSets.clear(paths, 0L, paths.length() + 1);
        timer.end();
    }

    protected abstract void indexContentBlock(Multimap<String, DvcsRevInfo> var1) throws DbException, DvcsProcessException;

    private void deleteContent(SortedIntSet paths) throws DbException {
        SegmentedIntSet subset = new SegmentedIntSet();
        int pathId = paths.nextSetBit(0);
        while (pathId >= 0 && !this.isStopRequested()) {
            subset.set(pathId);
            if (subset.cardinality() > 1000) {
                this.deleteContentSubSet(subset);
                subset = new SegmentedIntSet();
            }
            pathId = paths.nextSetBit(pathId + 1);
        }
        this.deleteContentSubSet(subset);
    }

    private void deleteContentSubSet(SortedIntSet physicalPaths) throws DbException {
        final Collection<Path> paths = this.getPaths(physicalPaths);
        LuceneConnection<LuceneIndexes> indexConnection = ((DvcsCache)this.getCache()).getLuceneConnection();
        indexConnection.withWriter(LuceneIndexes.CONTENT, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter writer) throws IOException {
                DvcsScanner.this.getIndexer().deleteDocumentsForPaths(writer, paths);
                return null;
            }
        });
    }

    private Collection<Path> getPaths(SortedIntSet physicalPaths) {
        ArrayList<Path> paths = new ArrayList<Path>(physicalPaths.cardinality());
        CommonRevInfoDAO dao = ((DvcsCache)this.getCache()).getCommonRevInfoDAO();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0) {
            paths.add(dao.getPath(physicalPathId));
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        return paths;
    }

    protected abstract List<String> getUnseenCommits(String var1, String var2, String var3) throws DvcsProcessException;

    protected abstract DvcsContext getContext();

    protected abstract DvcsRevInfoDAO<F, T> getDvcsRevInfoDAO();

    protected abstract DvcsChangeSetDAO<F, CS, T> getChangeSetDAO();

    protected abstract boolean fetchLatest() throws ConfigException;

    protected long getPollPeriod() {
        return this.getContext().getScmConfig().getPollPeriod();
    }

    protected Charset getEncoding() {
        return this.getContext().getScmConfig().getEncoding();
    }

    protected String getEncodingName() {
        return this.getEncoding() == null ? null : this.getEncoding().name();
    }
}

