/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;

public class DvcsFileHistory
implements FileHistory {
    private Path path;
    private TreeMultimap<Long, FileRevision> history;
    private Map<String, FileRevision> revMap;
    private DvcsCache cache;

    public DvcsFileHistory(DvcsCache cache, Path path, TreeMultimap<Long, FileRevision> history) {
        this.cache = cache;
        this.path = path;
        this.history = history;
        this.revMap = new HashMap<String, FileRevision>();
        for (FileRevision revision : history.values()) {
            this.revMap.put(revision.getChangeSetId(), revision);
        }
    }

    private FileRevision getLast() {
        if (this.history.isEmpty()) {
            return null;
        }
        NavigableSet fileRevisions = this.history.get(this.history.asMap().lastKey());
        return fileRevisions == null || fileRevisions.isEmpty() ? null : (FileRevision)fileRevisions.last();
    }

    @Override
    public boolean isBinary() {
        FileRevision last = this.getLast();
        return last != null && last.isBinary();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public MinMaxLongRange getDateRange() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Collection<FileRevision> getRevisions() {
        return this.history.values();
    }

    @Override
    public List<FileRevision> getRevisionsSorted() {
        ArrayList<FileRevision> revs = new ArrayList<FileRevision>();
        revs.addAll(this.history.values());
        Collections.reverse(revs);
        return revs;
    }

    @Override
    public FileRevision getRevision(String rev) {
        return this.revMap.get(rev);
    }

    @Override
    public List<FileRevision> getRevisionsForRev(String rev) {
        return Collections.singletonList(this.getRevision(rev));
    }

    @Override
    public String getHead() throws DbException {
        List revisions;
        String mainBranch = this.getMainBranch();
        List<Object> list = revisions = mainBranch == null ? Collections.emptyList() : this.getRevisions(mainBranch);
        if (revisions.isEmpty()) {
            return null;
        }
        return (String)revisions.get(revisions.size() - 1);
    }

    @Override
    public String resolveRevisionFromString(Path lpath, String s2) throws DbException {
        String hash;
        if (s2 == null) {
            return null;
        }
        if (s2.length() < 40 && (hash = this.getCache().getFirstMatchingHashExpansion(s2)) != null) {
            s2 = hash;
            return s2;
        }
        if (this.revMap.containsKey(s2)) {
            return s2;
        }
        ChangeSetDAO dao = this.getCache().getChangeSetDAO();
        List<String> commits = ((DvcsChangeSetDAO)dao).resolveCommit(s2);
        Iterator<String> iterator = commits.iterator();
        if (iterator.hasNext()) {
            String commit = iterator.next();
            return commit;
        }
        if ("HEAD".equals(s2) && (s2 = this.getMainBranch()) == null) {
            return null;
        }
        if (this.getBranches().contains(s2)) {
            List<String> revs = this.getRevisions(s2);
            if (revs.isEmpty()) {
                return null;
            }
            return (String)revs.get(revs.size() - 1);
        }
        for (FileRevision revision : this.history.values()) {
            if (!revision.getTags().contains(s2)) continue;
            return revision.getChangeSetId();
        }
        ChangeSet cs = this.getCache().getChangeSet(s2);
        if (cs != null) {
            String branch = cs.getBranch();
            List<String> fileRevsOnBranch = this.getRevisions(branch);
            List<String> allCommits = this.getCache().getCommitList();
            for (int i2 = allCommits.indexOf(s2); i2 >= 0; --i2) {
                String rev = allCommits.get(i2);
                if (!fileRevsOnBranch.contains(rev)) continue;
                return rev;
            }
        }
        return null;
    }

    @Override
    public String getMainBranch() {
        String mainBranch = this.getCache().getContext().getMainBranchName();
        String firstBranch = null;
        for (FileRevision revision : this.history.values()) {
            String branch = revision.getBranch();
            if (firstBranch == null) {
                firstBranch = branch;
            }
            if (!revision.getBranches().contains(mainBranch) && !revision.getBranchPoints().contains(mainBranch)) continue;
            return mainBranch;
        }
        return firstBranch;
    }

    @Override
    public List<String> getRevisions(String br) {
        ArrayList<String> branchRevisions = new ArrayList<String>();
        for (FileRevision revision : this.history.values()) {
            if (!br.equals(revision.getBranch())) continue;
            branchRevisions.add(revision.getChangeSetId());
        }
        return branchRevisions;
    }

    @Override
    public List<FileRevision> getNonBranchRevisions() {
        ArrayList<FileRevision> nonBranchRevisions = new ArrayList<FileRevision>();
        for (FileRevision revision : this.history.values()) {
            if (revision.getBranch() != null) continue;
            nonBranchRevisions.add(revision);
        }
        return nonBranchRevisions;
    }

    @Override
    public Collection<String> getBranches() {
        HashSet<String> branches = new HashSet<String>();
        for (FileRevision revision : this.history.values()) {
            String branch = revision.getBranch();
            if (branch != null) {
                branches.add(branch);
            }
            branches.addAll(revision.getBranchPoints());
        }
        return branches;
    }

    @Override
    public String getBranchPoint(String branch) {
        for (FileRevision info : this.history.values()) {
            if (!info.getBranchPoints().contains(branch)) continue;
            return info.getRevision();
        }
        return null;
    }

    @Override
    public String getFirstRevisionOnBranch(String branch) {
        for (FileRevision fileRevision : this.history.values()) {
            if (!fileRevision.getBranch().equals(branch)) continue;
            return fileRevision.getRevision();
        }
        return null;
    }

    @Override
    public boolean containsRevision(String revision) {
        return this.revMap.containsKey(revision);
    }

    public DvcsCache getCache() {
        return this.cache;
    }
}

