/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.db.BaseFileRevisionDAO;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.atlassian.fisheye.dvcs.DvcsFileHistory;
import com.atlassian.fisheye.dvcs.client.DvcsContext;
import com.atlassian.fisheye.dvcs.db.DvcsChangeSetDAO;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfoDAO;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseDirInfoCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.ChangesetRevision;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.Manifest;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public abstract class DvcsCache<F extends DvcsRevInfo, C extends ChangeSetImpl<F>, T extends CommonStringTables>
extends BaseDirInfoCache<F, C, T> {
    private String repositoryName;
    private final DvcsContext context;

    protected DvcsCache(RepositoryStatus status, long cacheSerial, int version, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, T stringTables, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext, String repositoryName, DvcsContext context) {
        super(status, cacheSerial, version, dbh, luceneConnection, stringTables, licenseEnforcer, indexingContext, true);
        this.repositoryName = repositoryName;
        this.context = context;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String getDefaultBranch() {
        return this.context.getMainBranchName();
    }

    @Override
    public int getRevId(RevInfoKey key) throws DbException {
        RevInfoKey longKey = key;
        if (key != null && key.getRev() != null && key.getRev().length() < 40) {
            String longHash = this.getLongHash(key.getRev());
            if (longHash == null) {
                return -1;
            }
            longKey = new RevInfoKey(key.getPath(), longHash);
        }
        return super.getRevId(longKey);
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        if (path == null || path.isRoot()) {
            return false;
        }
        FileRevisionDAO dao = this.getFileRevisionDAO();
        int revid = ((DvcsRevInfoDAO)dao).getLatestPathRevid(path);
        return revid != -1 && ((BaseFileRevisionDAO)dao).getFileType(revid) == 1;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public void getTextRevision(RevInfoKey key, OutputStream aOut, String kopt, String symrev) throws IOException, DbException {
        this.getBinaryRevision(key, aOut);
    }

    public String getFirstMatchingHashExpansion(String csid) throws DbException {
        ChangeSetDAO csDAO = this.getChangeSetDAO();
        List<String> commits = ((DvcsChangeSetDAO)csDAO).resolveCommit(csid);
        if (!commits.isEmpty()) {
            return commits.get(0);
        }
        Logs.APP_LOG.debug((Object)("getFirstMatchingHashExpansion: Could not resolve commit hash: " + csid + ". Returning null."));
        return null;
    }

    @Override
    public Charset getTextEncoding(RevInfoKey rkey) throws DbException {
        return this.getContext().getScmConfig().getEncoding();
    }

    public F getFileRevision(int revid) throws DbException {
        return (F)this.getFileRevision(revid, false);
    }

    public F getFileRevision(int revid, boolean lazy) throws DbException {
        return (F)(lazy ? (DvcsRevInfo)((BaseFileRevisionDAO)this.getFileRevisionDAO()).loadLazy(revid) : (DvcsRevInfo)this.getFileRevisionDAO().load(revid));
    }

    public F getFileRevision(RevInfoKey rkey) throws DbException {
        int revid = this.getRevId(rkey);
        if (revid == -1) {
            Logs.APP_LOG.debug((Object)("Unable to find revision for " + rkey));
            return null;
        }
        return (F)this.getFileRevision(revid);
    }

    public F getAncestorAtRevision(F revInfo, String revision) throws DbException {
        return ((DvcsRevInfoDAO)this.getFileRevisionDAO()).getAncestorAtRevision(revInfo, revision);
    }

    @Override
    public C getChangeSet(String csid) throws DbException {
        ChangeSetDAO dao = this.getChangeSetDAO();
        String commit = this.getLongHash(csid);
        if (commit == null) {
            return null;
        }
        return ((CommonChangeSetDAO)dao).load(commit);
    }

    @Override
    public boolean existsChangeSet(String csid) throws DbException {
        String longHash = this.getLongHash(csid);
        return longHash != null && super.existsChangeSet(longHash);
    }

    @Override
    public String getChangeSetId(int revid) throws DbException {
        return ((DvcsRevInfoDAO)this.getFileRevisionDAO()).getDisplayRevision(revid);
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        return this.getFileHistory(path);
    }

    @Override
    public FileHistory getFileHistory(Path path, boolean physicalOnly) throws DbException {
        FileRevisionDAO dao = this.getFileRevisionDAO();
        Map<String, Integer> commits = ((DvcsRevInfoDAO)dao).getPathRevisions(path);
        TreeMultimap history = TreeMultimap.create();
        for (Map.Entry<String, Integer> entry : commits.entrySet()) {
            Integer revid = entry.getValue();
            Object revision = dao.load(revid);
            history.put((Object)revision.getDate(), revision);
        }
        return new DvcsFileHistory(this, path, (TreeMultimap<Long, FileRevision>)history);
    }

    @Override
    public List<String> getSimilarChangeSetIds(String id) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialId) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public String getImpliedBranch(Path path) {
        return null;
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return ((BaseFileRevisionDAO)this.getFileRevisionDAO()).getCommonRevInfoDAO();
    }

    public F getLatestFileRevision(Path path) throws DbException {
        FileRevisionDAO dao = this.getFileRevisionDAO();
        int revid = ((DvcsRevInfoDAO)dao).getLatestPathRevid(path);
        if (revid != -1) {
            return (F)this.getFileRevision(revid, true);
        }
        return null;
    }

    @Override
    public abstract DvcsRevInfoDAO<F, T> getFileRevisionDAO();

    @Override
    public FileRevision findFileRevision(Path path, String revision) throws DbException {
        FileRevision fileRevision;
        if (StringUtils.isEmpty((String)revision)) {
            return null;
        }
        if ("HEAD".equals(revision)) {
            revision = this.getContext().getMainBranchName();
        }
        if ((fileRevision = super.findFileRevision(path, revision)) == null) {
            fileRevision = this.getFileRevisionAtManifest(path, revision);
        }
        return fileRevision;
    }

    protected FileRevision getFileRevisionAtManifest(final Path path, String csid) {
        String longHash = this.getLongHash(csid);
        if (longHash == null || this.getChangeSet(longHash) == null) {
            return null;
        }
        Manifest<F> manifest = this.getManifest(longHash);
        final AtomicReference newest = new AtomicReference();
        manifest.visitFileRevisions(new Visitor<F>(){

            @Override
            public void visit(F fileRevision) {
                if (((CommonFileRevision)fileRevision).getPath().equals(path) && (newest.get() == null || FileRevision.NEWEST_FIRST_COMPARATOR.compare((FileRevision)newest.get(), (FileRevision)fileRevision) > 0)) {
                    newest.set(fileRevision);
                }
            }
        });
        return (FileRevision)newest.get();
    }

    public abstract DvcsChangeSetDAO<F, C, T> getChangeSetDAO();

    protected abstract DvcsContext getContext();

    protected String getLongHash(String commitHash) throws DbException {
        if (commitHash == null) {
            Logs.APP_LOG.debug((Object)"getLongHash: Illegal argument: null");
            return null;
        }
        if (commitHash.length() < 40) {
            return this.getFirstMatchingHashExpansion(commitHash);
        }
        return commitHash;
    }

    @Deprecated
    public List<String> getCommitList() throws DbException {
        return ((CommonChangeSetDAO)this.getChangeSetDAO()).getChangeSetIds();
    }

    public void pruneDeletedTags(Set<Tag> currentTags) throws DvcsProcessException {
        try {
            Set<Tag> allTags = ((CommonChangeSetDAO)this.getChangeSetDAO()).getAllTags();
            allTags.removeAll(currentTags);
            for (Tag tag : allTags) {
                this.removeTag(tag);
            }
        }
        catch (DbException e2) {
            throw new DvcsProcessException("Error while processing deleted tags", e2);
        }
    }

    public void removeTag(Tag tag) throws DbException {
        ((BaseFileRevisionDAO)this.getFileRevisionDAO()).removeTag(tag.getName());
        ((CommonChangeSetDAO)this.getChangeSetDAO()).removeTag(tag);
    }

    public void applyTag(Tag tag) throws DvcsProcessException, DbException {
        ((CommonChangeSetDAO)this.getChangeSetDAO()).addTag(tag);
    }

    public abstract Manifest<F> getManifest(String var1) throws DbException;

    public void rebuildHeadsOnBranch(Branch branch) throws DbException {
        Manifest<F> mf = this.getManifest(branch.getLatestChangeSetId());
        ((DvcsRevInfoDAO)this.getFileRevisionDAO()).rebuildHeadsMarkersForBranch(branch.getName(), mf);
    }

    protected List<F> getFileRevisionParentAt(List<String> csids, List<F> fileRevisions) throws DbException {
        ArrayListMultimap unresolvedParents = ArrayListMultimap.create();
        HashMap result = new HashMap();
        for (DvcsRevInfo rev : fileRevisions) {
            if (rev.getAncestorLink() == null) continue;
            unresolvedParents.putAll((Object)rev.getRevID(), (Iterable)rev.getAncestorLink().getRevids());
        }
        GraphIterator<String> it = ((CommonChangeSetDAO)this.getChangeSetDAO()).iterateAncestors(csids);
        while (it.hasNext() && !unresolvedParents.isEmpty()) {
            Object cs = ((CommonChangeSetDAO)this.getChangeSetDAO()).load((String)it.next());
            Iterator entryIt = unresolvedParents.asMap().entrySet().iterator();
            while (entryIt.hasNext()) {
                final Map.Entry entry = entryIt.next();
                DvcsRevInfo match = (DvcsRevInfo)((ChangeSetImpl)cs).searchRevisions(new Predicate<FileRevision>(){

                    public boolean apply(FileRevision csFileRev) {
                        return ((Collection)entry.getValue()).contains(csFileRev.getRevID());
                    }
                });
                if (match == null) continue;
                result.put(entry.getKey(), match);
                entryIt.remove();
            }
        }
        ArrayList parents = new ArrayList(fileRevisions.size());
        for (DvcsRevInfo fileRev : fileRevisions) {
            parents.add(result.get(fileRev.getRevID()));
        }
        return parents;
    }

    @Override
    public List<ChangesetRevision> getChangesetRevisions(ChangeSet cs, List<FileRevision> revisions) {
        if (cs.getParents().size() > 1) {
            Timer timer = new Timer("retrieving revisions from parent0 for a merge commit");
            ArrayList<DvcsRevInfo> fRevs = new ArrayList<DvcsRevInfo>();
            for (FileRevision r2 : revisions) {
                fRevs.add((DvcsRevInfo)r2);
            }
            List diffRevisions = this.getFileRevisionParentAt(cs.getParents(), fRevs);
            timer.end("done");
            ArrayList<ChangesetRevision> csRevisions = new ArrayList<ChangesetRevision>(revisions.size());
            for (int i2 = 0; i2 < revisions.size(); ++i2) {
                if (diffRevisions.get(i2) == null && revisions.get(i2).getAncestorLink() != null) {
                    Logs.APP_LOG.warn((Object)("Could not determine parent for " + revisions.get(i2).getRevInfoKey()));
                }
                csRevisions.add(new ChangesetRevision(revisions.get(i2), (FileRevision)diffRevisions.get(i2)));
            }
            return csRevisions;
        }
        return super.getChangesetRevisions(cs, revisions);
    }
}

