/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.db;

import com.atlassian.fisheye.db.BranchDAO;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CommonBranchDAO
implements BranchDAO {
    private InfinityDbHandle dbh;
    private CommonStringTables stringTables;

    public CommonBranchDAO(InfinityDbHandle dbh, CommonStringTables stringTables) {
        this.dbh = dbh;
        this.stringTables = stringTables;
    }

    protected EavEntityCu makeEav(long branchId) throws DbException {
        ac db = this.dbh.get();
        return new EavEntityCu(db, CommonSchema.BranchInfo.ENTITY, branchId);
    }

    @Override
    public boolean exists(String branchName) throws DbException {
        if (branchName == null) {
            throw new IllegalArgumentException("cannot call exists with null parameter");
        }
        long branchId = this.stringTables.branchDB.find(branchName);
        if (branchId != -1L) {
            try {
                return this.makeEav(branchId).exists();
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return false;
    }

    @Override
    public Branch load(String branchName) throws DbException {
        if (branchName == null) {
            throw new IllegalArgumentException("cannot call load with null parameter");
        }
        long id = this.stringTables.branchDB.find(branchName);
        EavEntityCu eav = this.makeEav(id);
        try {
            if (!eav.exists()) {
                return null;
            }
            Branch branch = new Branch(branchName);
            this.loadAttributes(eav, branch);
            return branch;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Set<Branch> loadAll() throws DbException {
        HashSet<Branch> branches = new HashSet<Branch>();
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.BranchInfo.ENTITY);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                long branchId = cu.v(pl);
                EavEntityCu eav = this.makeEav(branchId);
                String branchName = this.stringTables.branchDB.get(branchId);
                if (StringUtils.isEmpty((String)branchName)) {
                    Logs.APP_LOG.warn((Object)("Branch with empty name [" + branchName + "] - branch id is " + branchId));
                    Logs.APP_LOG.debug((Object)("Branch head is " + eav.getString(this.stringTables.changeSetIdDB, CommonSchema.BranchInfo.A_HEAD, null)));
                    continue;
                }
                Branch branch = new Branch(branchName);
                this.loadAttributes(eav, branch);
                branches.add(branch);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
        return branches;
    }

    @Override
    public void store(Branch branch, boolean updateTimestamps) throws DbException {
        if (branch == null) {
            throw new IllegalArgumentException("cannot call store with null parameter");
        }
        Branch previousBranch = this.load(branch.getName());
        long id = this.stringTables.branchDB.add(branch.getName());
        EavEntityCu eav = this.makeEav(id);
        try {
            this.storeAttributes(eav, branch, previousBranch, updateTimestamps);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public boolean delete(String branchName) throws DbException {
        long branchId = this.stringTables.branchDB.find(branchName);
        if (branchId != -1L) {
            EavEntityCu eav = this.makeEav(branchId);
            try {
                if (eav.exists()) {
                    eav.deleteEntity();
                    return true;
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return false;
    }

    private void loadAttributes(EavEntityCu eav, Branch branch) throws DbException, IOException {
        String state = eav.getString(CommonSchema.BranchInfo.A_STATE, null);
        branch.setState(state != null ? BranchState.of(state) : null);
        branch.setLatestChangeSetId(eav.getString(this.stringTables.changeSetIdDB, CommonSchema.BranchInfo.A_HEAD, null));
        branch.setFirstIndexedTimestamp(eav.getLong(CommonSchema.BranchInfo.A_FIRSTINDEXED, -1L));
        branch.setLastIndexedTimestamp(eav.getLong(CommonSchema.BranchInfo.A_LASTINDEXED, -1L));
        branch.setLatestMarkedChangesetId(this.loadLatestMarkedChangesetId(eav));
    }

    private Option<String> loadLatestMarkedChangesetId(EavEntityCu eav) throws IOException {
        long lastMarkedCsDbId = eav.getLong(CommonSchema.BranchInfo.A_LAST_MARKED_HEAD, -1L);
        if (lastMarkedCsDbId == -1L) {
            return Option.none();
        }
        return Option.some((Object)this.stringTables.changeSetIdDB.get(lastMarkedCsDbId));
    }

    private void storeAttributes(EavEntityCu eav, Branch branch, Branch previousBranch, boolean updateTimestamps) throws DbException, IOException {
        if (branch.getState() != null) {
            eav.updateString(CommonSchema.BranchInfo.A_STATE, branch.getState().getValue());
        } else {
            eav.deleteValues(CommonSchema.BranchInfo.A_STATE);
        }
        eav.updateString(this.stringTables.changeSetIdDB, CommonSchema.BranchInfo.A_HEAD, branch.getLatestChangeSetId());
        if (updateTimestamps) {
            long createTimestamp;
            long now = System.currentTimeMillis();
            if (previousBranch == null || previousBranch.getState() == BranchState.REMOVED) {
                createTimestamp = now;
                eav.updateLong(CommonSchema.BranchInfo.A_FIRSTINDEXED, createTimestamp);
            } else {
                createTimestamp = previousBranch.getFirstIndexedTimestamp();
            }
            eav.updateLong(CommonSchema.BranchInfo.A_LASTINDEXED, now);
            branch.setFirstIndexedTimestamp(createTimestamp);
            branch.setLastIndexedTimestamp(now);
        }
        this.storeLatestMarkedChangesetId(eav, branch.getLatestMarkedChangesetId());
    }

    private void storeLatestMarkedChangesetId(EavEntityCu eav, Option<String> latestMarkedChangesetId) throws IOException {
        if (latestMarkedChangesetId.isDefined()) {
            eav.updateString(this.stringTables.changeSetIdDB, CommonSchema.BranchInfo.A_LAST_MARKED_HEAD, (String)latestMarkedChangesetId.get());
        } else {
            eav.deleteValues(CommonSchema.BranchInfo.A_LAST_MARKED_HEAD);
        }
    }
}

