/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.db;

import com.atlassian.fecru.util.ClassUtils;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.DbUtil;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.LazyFileRevisionInterceptor;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.util.ObjectReference;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;

public abstract class BaseFileRevisionDAO<F extends FileRevision, T extends CommonStringTables>
implements FileRevisionDAO<F> {
    protected CommonRevInfoDAO commonDAO;
    protected InfinityDbHandle dbh;
    protected String repositoryName;
    protected T stringTables;
    protected final DbUtil dbUtil;
    private Factory proxyFactory;

    public BaseFileRevisionDAO(String repositoryName, InfinityDbHandle dbh, T stringTables, LicenseEnforcer licenseEnforcer) {
        this(repositoryName, dbh, stringTables, false, true, licenseEnforcer);
    }

    public BaseFileRevisionDAO(String repositoryName, InfinityDbHandle dbh, T stringTables, boolean svnMode, boolean caseSensitive, LicenseEnforcer licenseEnforcer) {
        this.repositoryName = repositoryName;
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.commonDAO = new CommonRevInfoDAO(dbh, (CommonStringTables)stringTables, svnMode, caseSensitive, licenseEnforcer);
        this.dbUtil = new DbUtil();
    }

    @Override
    public IntList getChangeSetRevids(String csid) throws DbException {
        return this.commonDAO.getChangeSetRevids(csid);
    }

    @Override
    public F searchChangeSetRevisions(String csid, final Predicate<FileRevision> predicate) throws DbException {
        final ObjectReference result = new ObjectReference();
        this.commonDAO.searchChangeSetRevids(csid, new Predicate<Integer>(){

            public boolean apply(Integer revid) {
                Object revision = BaseFileRevisionDAO.this.loadLazy(revid);
                if (predicate.apply(revision)) {
                    result.set(revision);
                    return true;
                }
                return false;
            }
        });
        return (F)((FileRevision)result.get());
    }

    @Override
    public void visitChangeSetRevisions(String csid, final StoppableVisitor<FileRevision> visitor) throws DbException {
        if (visitor != null && csid != null) {
            this.commonDAO.searchChangeSetRevids(csid, new Predicate<Integer>(){

                public boolean apply(Integer revid) {
                    boolean continueVisiting = visitor.visit(BaseFileRevisionDAO.this.loadLazy(revid));
                    return !continueVisiting;
                }
            });
        }
    }

    @Override
    public void visitChangeSetRevisions(String csid, final Visitor<FileRevision> visitor, final Predicate<Integer> breakCondition) throws DbException {
        if (visitor != null && csid != null) {
            this.commonDAO.searchChangeSetRevids(csid, new Predicate<Integer>(){

                public boolean apply(Integer revid) {
                    visitor.visit(BaseFileRevisionDAO.this.loadLazy(revid));
                    return breakCondition.apply((Object)revid);
                }
            });
        }
    }

    @Override
    public Iterable<F> getRevisionIterable(final String csid) throws DbException {
        return new Iterable<F>(){

            @Override
            public Iterator<F> iterator() {
                return BaseFileRevisionDAO.this.commonDAO.getRevisionIterator(csid, BaseFileRevisionDAO.this);
            }
        };
    }

    @Override
    public String getAuthor(int revid) {
        return this.commonDAO.getAuthorOfRevision(revid);
    }

    @Override
    public String getDisplayRevision(int revid) {
        return this.getRevision(revid);
    }

    @Override
    public String getRevision(int revid) {
        EavEntityCu eav = this.commonDAO.makeEav(revid);
        try {
            return eav.getString(CommonSchema.RevInfo.A_CSID, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public RevInfoKey getKey(int revid) throws DbException {
        return this.commonDAO.getKey(revid);
    }

    @Override
    public int getId(RevInfoKey revKey) throws DbException {
        return this.commonDAO.getRevId(revKey);
    }

    @Override
    public String getRepName() {
        return this.repositoryName;
    }

    @Override
    public F getDiffRevision(F rev) throws DbException {
        if (rev != null && rev.getDiffRevision() != null) {
            return this.loadLazy(rev.getDiffRevision());
        }
        return null;
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate, boolean predecessorFirst) throws DbException {
        return this.commonDAO.searchAncestors(revInfoKey, predicate, predecessorFirst);
    }

    public Path getPath(long pathId) throws DbException {
        return this.commonDAO.getPath(pathId);
    }

    public int getRevId(Path path, String commit) throws DbException {
        return this.commonDAO.getRevId(path, commit);
    }

    public int getRevId(RevInfoKey key) {
        return this.commonDAO.getRevId(key);
    }

    public int getFileType(int revid) throws DbException {
        return this.commonDAO.getFileType(revid);
    }

    public int getLatestRevid() throws DbException {
        return this.commonDAO.getLatestRevid();
    }

    public boolean exists(RevInfoKey revKey) throws DbException {
        return this.commonDAO.exists(revKey);
    }

    public int getLineCount(int revid) throws DbException {
        return this.commonDAO.getLineCount(revid);
    }

    @Override
    public boolean isBinary(int revid) throws DbException {
        return this.commonDAO.isBinary(revid);
    }

    @Override
    public boolean isOversize(int revid) throws DbException {
        return this.commonDAO.isOversize(revid);
    }

    public String getBranch(int revid) throws DbException {
        return this.commonDAO.getBranchOf(revid);
    }

    @Override
    public List<String> getBranchPoints(int revid) throws DbException {
        return this.commonDAO.getBranchPoints(revid);
    }

    public boolean isDeleted(int revid) throws DbException {
        return this.commonDAO.isDeleted(revid);
    }

    public void removeTag(String tag) throws DbException {
        this.commonDAO.removeTag(tag);
    }

    public void addTag(int revid, String tag) throws DbException {
        this.commonDAO.addTagData(revid, tag);
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.commonDAO;
    }

    private Factory getProxyFactory() {
        if (this.proxyFactory == null) {
            Class<?> fileRevisionClazz = ClassUtils.getTypeArguments(BaseFileRevisionDAO.class, this.getClass()).get(0);
            this.proxyFactory = ClassUtils.createEnhancer(fileRevisionClazz, new LazyFileRevisionInterceptor(-1, this));
        }
        return this.proxyFactory;
    }

    @Override
    public F loadLazy(int revid) throws DbException {
        if (this.commonDAO.exists(revid)) {
            return (F)((FileRevision)this.getProxyFactory().newInstance(new Callback[]{new LazyFileRevisionInterceptor(revid, this), NoOp.INSTANCE}));
        }
        return null;
    }

    @Override
    public F loadLazy(RevInfoKey revkey) throws DbException {
        int revid = this.commonDAO.getRevId(revkey);
        if (revid != -1) {
            return (F)((FileRevision)this.getProxyFactory().newInstance(new Callback[]{new LazyFileRevisionInterceptor(revid, revkey, this), NoOp.INSTANCE}));
        }
        return null;
    }

    @Override
    public Iterable<Path> getPathsInChangeset(final String csid) {
        y csCu = y.a(CommonSchema.E_CSID_TO_REVID).b(csid);
        final y revCu = y.a();
        final ac db = this.dbh.get();
        return new InfDbIterable<Path>(this.dbh, csCu, csCu.e()){

            @Override
            public Path getElement(y cu, int elementOffset) throws IOException, DbException {
                long revid = cu.v(elementOffset);
                revCu.f().a(CommonSchema.RevInfo.ENTITY).b(revid).a(CommonSchema.RevInfo.A_PATHID);
                int revOffSet = revCu.e();
                if (db.a(revCu, revOffSet)) {
                    long pathId = revCu.v(revOffSet);
                    return new Path(((CommonStringTables)BaseFileRevisionDAO.this.stringTables).pathDB.get(pathId));
                }
                Logs.APP_LOG.warn((Object)("Found a file revision without a path in changeset " + csid));
                return null;
            }
        };
    }

    @Override
    public AncestorLink getAncestorLink(int revid) throws DbException {
        return this.commonDAO.getAncestorOf(revid);
    }

    @Override
    public boolean isDead(int revid) throws DbException {
        return this.commonDAO.isDeleted(revid);
    }

    @Override
    public boolean isAdded(int revid) throws DbException {
        return this.commonDAO.isAdded(revid);
    }

    @Override
    public boolean isMove(int revid) throws DbException {
        return this.commonDAO.isMoved(revid);
    }

    @Override
    public boolean isMetadataOnly(int revid) throws DbException {
        return false;
    }

    @Override
    public boolean isCopy(int revid) throws DbException {
        return this.commonDAO.isCopy(revid);
    }

    @Override
    public boolean isModify(int revid) throws DbException {
        return this.commonDAO.isModify(revid);
    }

    @Override
    public boolean isFile(int revid) throws DbException {
        return this.commonDAO.isFile(revid);
    }

    @Override
    public boolean isDir(int revid) throws DbException {
        return this.commonDAO.isDir(revid);
    }

    @Override
    public long getDate(int revid) throws DbException {
        return this.commonDAO.getDate(revid);
    }

    @Override
    public LineCountState getLineCountState(int revid) {
        return this.commonDAO.getLineCountState(revid);
    }

    public void updateRevisionRelationships(int revId, CommonFileRevision revision) throws DbException {
        this.commonDAO.updateRevisionRelationships(revId, revision);
    }

    public void updateDead(int revid, boolean dead) {
        this.commonDAO.updateDead(revid, dead);
    }

    public void updateState(int revid, FileRevision revision) {
        this.commonDAO.updateDead(revid, revision.isDead());
        this.commonDAO.updateAdded(revid, revision.isAdded());
        this.commonDAO.updateMoved(revid, revision.isMove());
        this.commonDAO.updateModify(revid, revision.isModify());
        this.commonDAO.updateCopied(revid, revision.isCopy());
    }

    public void setHunks(int revid, List<Hunk> hunks) {
        this.commonDAO.setHunks(revid, hunks);
    }

    public void updateBinary(int revid, boolean isBinary) {
        this.commonDAO.updateBinary(revid, isBinary);
    }

    public void updateOversize(int revid, boolean oversize) {
        this.commonDAO.updateOversize(revid, oversize);
    }

    public void updateFileType(int revid, int filetype) {
        this.commonDAO.updateFileType(revid, filetype);
    }

    public void updateDiffFiles(int revid, File tmpDiffAddedFile, File tmpDiffRemovedFile) {
        this.commonDAO.updateDiffFiles(revid, tmpDiffAddedFile, tmpDiffRemovedFile);
    }

    public boolean isStoreSuffixPaths() {
        return false;
    }

    @Override
    public Path getLogicalPath(Path path) {
        return path;
    }
}

