/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dag;

import com.atlassian.fisheye.dag.FilteredGraphIteratorDecorator;
import com.atlassian.fisheye.dag.GraphIterator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public class GraphUtils {
    private GraphUtils() {
    }

    public static <N, ID> GraphIterator<N> iterateDepthFirst(Collection<N> fromNodes, Function<N, Collection<N>> nextNodeProvider, @Nullable Function<N, ID> nodeIdExtractor) {
        return new DefaultGraphIterator<N, ID>(fromNodes, nextNodeProvider, nodeIdExtractor, new DepthFirstNodeInserter());
    }

    public static <N, ID> GraphIterator<N> iterateBreadthFirst(Collection<N> fromNodes, Function<N, Collection<N>> nextNodeProvider, @Nullable Function<N, ID> nodeIdExtractor) {
        return new DefaultGraphIterator<N, ID>(fromNodes, nextNodeProvider, nodeIdExtractor, new BreadthFirstNodeInserter());
    }

    public static <N> GraphIterator<N> filteredGraphIterator(GraphIterator<N> iterator, Predicate<N> filterPredicate) {
        return new FilteredGraphIteratorDecorator<N>(iterator, filterPredicate);
    }

    protected static class DefaultGraphIterator<E, ID>
    implements GraphIterator<E> {
        private final Set<ID> nodesSeenOrQueued;
        private final LinkedList<E> nodeQueue = new LinkedList();
        private final Function<E, Collection<E>> nextNodeProvider;
        private final Function<E, ID> nodeIdExtractor;
        private final NodeInserter<E> nodeInserter;
        private E currentNode;
        private Collection<E> currentNodeNextNodes = null;
        private boolean pruneCurrentNode = false;

        public DefaultGraphIterator(Collection<E> fromNodes, Function<E, Collection<E>> nextNodeProvider, @Nullable Function<E, ID> nodeIdExtractor, NodeInserter<E> nodeInserter) {
            this.nextNodeProvider = nextNodeProvider;
            this.nodeInserter = nodeInserter;
            this.nodeIdExtractor = nodeIdExtractor;
            this.nodesSeenOrQueued = nodeIdExtractor != null ? new HashSet<ID>() : null;
            Iterables.addAll(this.nodeQueue, (Iterable)Iterables.filter(fromNodes, (Predicate)Predicates.notNull()));
        }

        @Override
        public boolean hasNext() {
            if (!this.nodeQueue.isEmpty()) {
                return true;
            }
            if (this.currentNode != null && !this.pruneCurrentNode && this.currentNodeNextNodes == null) {
                this.currentNodeNextNodes = this.getNextNodes();
            }
            return this.currentNodeNextNodes != null && !this.currentNodeNextNodes.isEmpty();
        }

        private Collection<E> filterQueuedAndSeenNodes(Collection<E> nodes) {
            ArrayList<E> result = new ArrayList<E>();
            if (nodes != null && this.nodeIdExtractor != null) {
                HashSet<Object> nextNodesSeen = new HashSet<Object>();
                for (E node : nodes) {
                    Object nodeID;
                    if (node == null || this.nodesSeenOrQueued.contains(nodeID = this.nodeIdExtractor.apply(node)) || !nextNodesSeen.add(nodeID)) continue;
                    result.add(node);
                }
            } else if (nodes != null) {
                result.addAll(nodes);
            }
            return result;
        }

        private void queueNodes(Collection<E> nodes) {
            this.nodeInserter.insertNextNodes(this.nodeQueue, nodes);
            if (this.nodeIdExtractor != null) {
                for (E node : nodes) {
                    this.nodesSeenOrQueued.add(this.nodeIdExtractor.apply(node));
                }
            }
        }

        private Collection<E> getNextNodes() {
            Collection nextNodes = (Collection)this.nextNodeProvider.apply(this.currentNode);
            return this.filterQueuedAndSeenNodes(nextNodes);
        }

        @Override
        public E next() {
            if (this.currentNode != null && !this.pruneCurrentNode) {
                if (this.currentNodeNextNodes == null) {
                    this.currentNodeNextNodes = this.getNextNodes();
                }
                if (this.currentNodeNextNodes != null) {
                    this.queueNodes(this.currentNodeNextNodes);
                }
            }
            this.pruneCurrentNode = false;
            this.currentNodeNextNodes = null;
            if (this.nodeQueue.isEmpty()) {
                throw new NoSuchElementException("The graph iterator is depleted, no next item is available");
            }
            this.currentNode = this.nodeQueue.poll();
            return this.currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("removing elements from a the graph isn't supported");
        }

        @Override
        public void prune() {
            this.pruneCurrentNode = true;
            this.currentNodeNextNodes = null;
        }
    }

    protected static class PredicateMatcher<N>
    implements Function<N, Boolean> {
        private Predicate<N> searchPredicate;
        private N result;

        public PredicateMatcher(Predicate<N> searchPredicate) {
            this.searchPredicate = searchPredicate;
        }

        public Boolean apply(N node) {
            if (this.result == null && this.searchPredicate.apply(node)) {
                this.result = node;
            }
            return this.result == null;
        }

        public N getResult() {
            return this.result;
        }
    }

    protected static class DepthFirstNodeInserter<N>
    implements NodeInserter<N> {
        private LinkedList<N> nextNodesQueue = new LinkedList();

        protected DepthFirstNodeInserter() {
        }

        @Override
        public void insertNextNodes(LinkedList<N> nodeQueue, Collection<N> nextNodes) {
            assert (this.nextNodesQueue.isEmpty());
            this.nextNodesQueue.addAll(nextNodes);
            ListIterator<N> nextNodeIt = this.nextNodesQueue.listIterator(nextNodes.size());
            while (nextNodeIt.hasPrevious()) {
                N nextNode = nextNodeIt.previous();
                nodeQueue.addFirst(nextNode);
                nextNodeIt.remove();
            }
        }
    }

    protected static class BreadthFirstNodeInserter<N>
    implements NodeInserter<N> {
        protected BreadthFirstNodeInserter() {
        }

        @Override
        public void insertNextNodes(LinkedList<N> nodeQueue, Collection<N> nextNodes) {
            for (N node : nextNodes) {
                nodeQueue.addLast(node);
            }
        }
    }

    protected static interface NodeInserter<N> {
        public void insertNextNodes(LinkedList<N> var1, Collection<N> var2);
    }
}

