/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dag;

import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fugue.Option;
import com.google.common.base.Predicate;
import java.util.NoSuchElementException;

class FilteredGraphIteratorDecorator<N>
implements GraphIterator<N> {
    private final GraphIterator<N> iterator;
    private final Predicate<N> filterPredicate;
    private Option<N> next;

    public FilteredGraphIteratorDecorator(GraphIterator<N> iterator, Predicate<N> filterPredicate) {
        this.iterator = iterator;
        this.filterPredicate = filterPredicate;
        this.next = Option.none();
    }

    @Override
    public void prune() {
        if (this.next.isDefined()) {
            throw new IllegalStateException("Can't prune when next item has already been fetched");
        }
        this.iterator.prune();
    }

    @Override
    public boolean hasNext() {
        if (this.next.isDefined()) {
            return true;
        }
        while (this.iterator.hasNext() && !this.next.isDefined()) {
            Object potentialNext = this.iterator.next();
            if (!this.filterPredicate.apply(potentialNext)) continue;
            this.next = Option.some(potentialNext);
            return true;
        }
        return false;
    }

    @Override
    public N next() {
        if (!this.next.isDefined() && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.next.get();
        this.next = Option.none();
        return (N)result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("removing elements from a the graph isn't supported");
    }
}

