/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.csvis;

import com.atlassian.fisheye.csvis.AlternatingChangeSetIterator;
import com.atlassian.fisheye.csvis.VisParameters;
import com.atlassian.fisheye.csvis.VisResult;
import com.atlassian.fisheye.csvis.VisualisationChangesets;
import com.atlassian.fisheye.spi.services.Direction;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import java.util.Set;

public class VisualisationChangesetsCalculator {
    private final ChangeSetService<? extends ChangeSet> csService;

    public VisualisationChangesetsCalculator(ChangeSetService<? extends ChangeSet> csService) {
        this.csService = csService;
    }

    public VisResult getChangeSets(String anchorCsId, int windowSize, Direction direction) throws DbException {
        return this.getChangeSets(anchorCsId, windowSize, null, direction);
    }

    public VisResult getChangeSets(String anchorCsId, int windowSize, Set<String> branches, Direction direction) throws DbException {
        ChangeSet anchorChangeset = this.getAnchorChangeSet(anchorCsId, branches);
        if (anchorChangeset == null) {
            return null;
        }
        VisParameters params = new VisParameters.Builder().anchorChangeset(anchorChangeset).windowSize(windowSize).branches(branches).direction(direction).build();
        VisualisationChangesets data = new VisualisationChangesets(params);
        this.calculate(data);
        return data.getResult();
    }

    private ChangeSet getAnchorChangeSet(String idOrTag, Set<String> branches) {
        Object changeSet = this.csService.getChangeSet(idOrTag);
        if (changeSet != null) {
            return changeSet;
        }
        Tag tag = this.csService.getTag(idOrTag);
        if (tag != null) {
            return this.csService.getChangeSet(tag.getChangesetId());
        }
        return this.csService.getTipChangeSet(branches);
    }

    private void calculate(VisualisationChangesets data) throws DbException {
        this.findLiveChangeSets(data);
        this.findAdjacentContextChangeSets(data);
        this.findSpanningContextChangesets(data);
    }

    private void findLiveChangeSets(VisualisationChangesets data) throws DbException {
        AlternatingChangeSetIterator it = AlternatingChangeSetIterator.getInstance(this.csService, data.getParams());
        while (data.wantsMoreLiveChangesets() && it.hasNext()) {
            data.addLiveChangeSet(it.next());
        }
    }

    private void findAdjacentContextChangeSets(VisualisationChangesets data) throws DbException {
        for (ChangeSet cs : data.getLiveChangesets()) {
            for (String parent : cs.getParents()) {
                data.addAdjacentContextChangeSet(this.getChangeSet(data, parent));
            }
            for (String child : cs.getChildren()) {
                data.addAdjacentContextChangeSet(this.getChangeSet(data, child));
            }
        }
    }

    private void findSpanningContextChangesets(VisualisationChangesets data) throws DbException {
        Set<String> children = data.getCandidateSpanningChildren();
        for (String child : children) {
            ChangeSet childCs = this.getChangeSet(data, child);
            if (!data.isValidSpanningChild(childCs)) continue;
            boolean hasSpan = false;
            for (String parent : childCs.getParents()) {
                ChangeSet parentCs = this.getChangeSet(data, parent);
                if (!data.isValidSpanningParent(parentCs)) continue;
                hasSpan = true;
                data.addSpanningContextChangeSet(parentCs);
            }
            if (!hasSpan) continue;
            data.addSpanningContextChangeSet(childCs);
        }
    }

    private ChangeSet getChangeSet(VisualisationChangesets data, String csid) throws DbException {
        return data.getChangeSet(this.csService, csid);
    }
}

