/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.csvis;

import com.atlassian.fisheye.csvis.VisParameters;
import com.atlassian.fisheye.csvis.VisResult;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VisualisationChangesets {
    private ChangeSet earliestLiveChangeSet;
    private ChangeSet latestLiveChangeSet;
    private final VisResult results = new VisResult();
    private final VisParameters params;
    private Map<String, ChangeSet> changeSetMap = new HashMap<String, ChangeSet>();

    public VisualisationChangesets(VisParameters params) {
        this.params = params;
        ChangeSet anchorChangeset = params.getAnchorChangeset();
        this.changeSetMap.put(anchorChangeset.getId(), anchorChangeset);
        if (this.passesBranchFilter(anchorChangeset)) {
            this.addLiveChangeSet(anchorChangeset);
        }
    }

    protected boolean passesBranchFilter(ChangeSet changeSet) {
        return !this.params.hasBranches() || this.params.hasAnyBranch(changeSet.getBranches());
    }

    protected void addLiveChangeSet(ChangeSet changeSet) {
        if (changeSet != null && !this.containsChangeset(changeSet.getId()) && this.passesBranchFilter(changeSet)) {
            this.results.getLiveChangeSets().put(changeSet.getId(), changeSet);
            if (this.latestLiveChangeSet == null || changeSet.isAfter(this.latestLiveChangeSet)) {
                this.latestLiveChangeSet = changeSet;
            }
            if (this.earliestLiveChangeSet == null || changeSet.isBefore(this.earliestLiveChangeSet)) {
                this.earliestLiveChangeSet = changeSet;
            }
        }
    }

    protected boolean wantsMoreLiveChangesets() {
        return this.results.getLiveChangeSets().size() < this.params.getWindowSize();
    }

    protected boolean containsChangeset(String id) {
        return this.results.getLiveChangeSets().containsKey(id) || this.results.getAdjacentContextChangeSets().containsKey(id) || this.results.getSpanningContextChangeSets().containsKey(id);
    }

    protected void addAdjacentContextChangeSet(ChangeSet changeSet) {
        if (changeSet != null && !this.containsChangeset(changeSet.getId())) {
            this.results.getAdjacentContextChangeSets().put(changeSet.getId(), changeSet);
        }
    }

    protected void addSpanningContextChangeSet(ChangeSet changeSet) {
        if (changeSet != null && !this.containsChangeset(changeSet.getId()) && this.passesBranchFilter(changeSet)) {
            this.results.getSpanningContextChangeSets().put(changeSet.getId(), changeSet);
        }
    }

    public Set<String> getBranches() {
        return this.params.getBranches();
    }

    public Collection<ChangeSet> getLiveChangesets() {
        return this.results.getLiveChangesets();
    }

    public VisResult getResult() {
        return this.results;
    }

    public VisParameters getParams() {
        return this.params;
    }

    public ChangeSet getChangeSet(ChangeSetService csService, String csid) {
        if (!this.changeSetMap.containsKey(csid)) {
            this.changeSetMap.put(csid, (ChangeSet)csService.getChangeSet(csid));
        }
        return csService.getChangeSet(csid);
    }

    public boolean isValidSpanningParent(ChangeSet parentCs) {
        return parentCs != null && this.passesBranchFilter(parentCs) && parentCs.isBefore(this.earliestLiveChangeSet);
    }

    public Set<String> getCandidateSpanningChildren() {
        HashSet<String> children = new HashSet<String>();
        children.addAll(this.latestLiveChangeSet.getNextCrossBranchCommits());
        children.addAll(this.latestLiveChangeSet.getChildren());
        return children;
    }

    public boolean isValidSpanningChild(ChangeSet childCs) {
        return childCs != null && this.passesBranchFilter(childCs);
    }
}

