/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.csvis;

import com.atlassian.fisheye.spi.services.Direction;
import com.cenqua.fisheye.rep.ChangeSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class VisParameters {
    private final int windowSize;
    private final Set<String> branches;
    private final Direction direction;
    private final ChangeSet anchorChangeset;

    public VisParameters(ChangeSet anchorChangeset, int windowSize, Set<String> branches, Direction direction) {
        this.anchorChangeset = anchorChangeset;
        this.windowSize = windowSize;
        if (branches == null || branches.isEmpty()) {
            this.branches = Collections.emptySet();
        } else {
            HashSet<String> tmpBranches = new HashSet<String>(branches);
            tmpBranches.remove(null);
            this.branches = Collections.unmodifiableSet(tmpBranches);
        }
        this.direction = direction;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public Set<String> getBranches() {
        return this.branches;
    }

    public ChangeSet getAnchorChangeset() {
        return this.anchorChangeset;
    }

    public boolean hasBranches() {
        return !this.branches.isEmpty();
    }

    public boolean includeForwards() {
        return this.direction.shouldIncludeDescendants();
    }

    public boolean includeBackwards() {
        return this.direction.shouldIncludeAncestors();
    }

    public boolean hasAnyBranch(Set<String> branches) {
        HashSet<String> commonBranches = new HashSet<String>(this.branches);
        commonBranches.retainAll(branches);
        return !commonBranches.isEmpty();
    }

    public static class Builder {
        private ChangeSet anchorChangeset;
        private int windowSize;
        private Set<String> branches = Collections.emptySet();
        private Direction direction = Direction.around;

        public Builder anchorChangeset(ChangeSet anchorChangeset) {
            this.anchorChangeset = anchorChangeset;
            return this;
        }

        public Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder branches(Set<String> branches) {
            this.branches = branches;
            return this;
        }

        public Builder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        public VisParameters build() {
            return new VisParameters(this.anchorChangeset, this.windowSize, this.branches, this.direction);
        }
    }
}

