/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.csvis;

import com.atlassian.fisheye.csvis.VisParameters;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

abstract class AlternatingChangeSetIterator
implements Iterator<ChangeSet> {
    private boolean nextStepIsForward = true;

    AlternatingChangeSetIterator() {
    }

    protected abstract ChangeSet getNextForward();

    protected abstract ChangeSet getNextBackward();

    protected abstract boolean hasMoreForward();

    protected abstract boolean hasMoreBackward();

    @Override
    public boolean hasNext() {
        return this.hasMoreBackward() || this.hasMoreForward();
    }

    protected static AlternatingChangeSetIterator getInstance(ChangeSetService<? extends ChangeSet> csService, VisParameters params) throws DbException {
        return new BranchSetAlternatingIterator(csService, params);
    }

    @Override
    public ChangeSet next() {
        if (!this.hasMoreBackward() && !this.hasMoreForward()) {
            return null;
        }
        this.ensureDirection();
        ChangeSet result = this.nextStepIsForward ? this.getNextForward() : this.getNextBackward();
        this.nextStepIsForward = !this.nextStepIsForward;
        this.ensureDirection();
        return result;
    }

    private void ensureDirection() {
        if (this.nextStepIsForward && !this.hasMoreForward()) {
            this.nextStepIsForward = false;
        } else if (!this.nextStepIsForward && !this.hasMoreBackward()) {
            this.nextStepIsForward = true;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }

    private static class PeekableBackwardsIterator
    extends PeekableIterator<PeekableBackwardsIterator>
    implements Comparable<PeekableBackwardsIterator> {
        public PeekableBackwardsIterator(ListIterator<? extends ChangeSet> iterator) {
            super(iterator);
        }

        @Override
        public int compareTo(PeekableBackwardsIterator other) {
            return -super.comparePositions(other);
        }

        @Override
        public ChangeSet callNextOrPrevious() {
            return this.iterator.hasPrevious() ? (ChangeSet)this.iterator.previous() : null;
        }
    }

    private static class PeekableForwardsIterator
    extends PeekableIterator<PeekableForwardsIterator>
    implements Comparable<PeekableForwardsIterator> {
        public PeekableForwardsIterator(ListIterator<? extends ChangeSet> iterator, ChangeSet anchorChangeset) {
            super(iterator);
            this.skipAnchorChangeSet(anchorChangeset);
        }

        @Override
        public int compareTo(PeekableForwardsIterator other) {
            return super.comparePositions(other);
        }

        @Override
        public ChangeSet callNextOrPrevious() {
            return this.iterator.hasNext() ? (ChangeSet)this.iterator.next() : null;
        }

        private void skipAnchorChangeSet(ChangeSet anchorChangeset) {
            if (this.hasNext() && this.peek().getId().equals(anchorChangeset.getId())) {
                this.next();
            }
        }
    }

    private static abstract class PeekableIterator<I extends PeekableIterator>
    implements Comparable<I> {
        ListIterator<? extends ChangeSet> iterator;
        ChangeSet next;

        public PeekableIterator(ListIterator<? extends ChangeSet> iterator) {
            this.iterator = iterator;
            this.next = this.callNextOrPrevious();
        }

        public int comparePositions(PeekableIterator other) {
            if (other == null) {
                return 1;
            }
            if (other.next == null && this.next == null) {
                return 0;
            }
            if (this.next == null) {
                return -1;
            }
            if (other.next == null) {
                return 1;
            }
            return this.next.getPosition().compareTo(other.next.getPosition());
        }

        public ChangeSet next() {
            ChangeSet result = this.next;
            this.next = this.callNextOrPrevious();
            return result;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public ChangeSet peek() {
            return this.next;
        }

        protected abstract ChangeSet callNextOrPrevious();
    }

    private static class BranchSetAlternatingIterator
    extends AlternatingChangeSetIterator {
        List<PeekableForwardsIterator> forward = new LinkedList<PeekableForwardsIterator>();
        List<PeekableBackwardsIterator> backward = new LinkedList<PeekableBackwardsIterator>();

        public BranchSetAlternatingIterator(ChangeSetService<? extends ChangeSet> csService, VisParameters params) throws DbException {
            if (params.hasBranches()) {
                for (String branch : params.getBranches()) {
                    this.addIterator(csService, params, branch);
                }
            } else {
                this.addIterator(csService, params, null);
            }
            Collections.sort(this.forward);
            Collections.sort(this.backward);
        }

        private void addIterator(ChangeSetService<? extends ChangeSet> csService, VisParameters params, String branch) {
            PeekableBackwardsIterator i2;
            ListIterator<? extends ChangeSet> iterator;
            PeekableForwardsIterator i1;
            if (params.includeForwards() && (i1 = new PeekableForwardsIterator(iterator = this.getChangeSetIterator(csService, params, branch), params.getAnchorChangeset())).hasNext()) {
                this.forward.add(i1);
            }
            if (params.includeBackwards() && (i2 = new PeekableBackwardsIterator(iterator = this.getChangeSetIterator(csService, params, branch))).hasNext()) {
                this.backward.add(i2);
            }
        }

        private ListIterator<? extends ChangeSet> getChangeSetIterator(ChangeSetService<? extends ChangeSet> csService, VisParameters params, String branch) {
            if (branch == null) {
                return csService.getChangeSets(params.getAnchorChangeset()).iterator();
            }
            return csService.getChangeSetsOnBranch(branch, params.getAnchorChangeset()).iterator();
        }

        @Override
        public ChangeSet getNextForward() {
            return this.getNext(this.forward);
        }

        @Override
        public ChangeSet getNextBackward() {
            return this.getNext(this.backward);
        }

        private ChangeSet getNext(List<? extends PeekableIterator> iterators) {
            ChangeSet result;
            do {
                PeekableIterator it = iterators.get(0);
                result = it.next();
                if (!it.hasNext()) {
                    iterators.remove(0);
                }
                Collections.sort(iterators);
            } while (!iterators.isEmpty() && result.getId().equals(this.peekNextId(iterators)));
            return result;
        }

        private String peekNextId(List<? extends PeekableIterator> iterators) {
            return iterators.get(0).peek().getId();
        }

        @Override
        public boolean hasMoreForward() {
            return !this.forward.isEmpty();
        }

        @Override
        public boolean hasMoreBackward() {
            return !this.backward.isEmpty();
        }
    }
}

