/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TimeZoneVariables {
    public static final long MS_IN_1_DAY = 86400000L;
    public static final long MS_IN_1_HOUR = 3600000L;
    static final long MS_IN_AVERAGE_MONTH = Math.round(2.62800288E9);
    private final long[] months;
    private final DayBuckets refDays = new DayBuckets();

    public TimeZoneVariables(TimeZone timeZone) {
        GregorianCalendar cal = new GregorianCalendar(timeZone, Locale.ENGLISH);
        cal.add(1, 10);
        long endTime = cal.getTimeInMillis();
        this.months = new long[(int)Math.ceil((double)endTime / (double)MS_IN_AVERAGE_MONTH)];
        this.initMonths(cal);
        this.initDays(cal, endTime, this.refDays);
    }

    public static int reduceMillisToHours(long lastModified) {
        return (int)(lastModified / 3600000L);
    }

    private void initMonths(Calendar cal) {
        cal.clear();
        cal.set(1970, 0, 1, 0, 0, 0);
        for (int i2 = 0; i2 < this.months.length; ++i2) {
            this.months[i2] = cal.getTimeInMillis();
            cal.add(2, 1);
        }
    }

    private void initDays(Calendar cal, long endTime, DayBuckets refDays) {
        cal.clear();
        cal.set(1970, 0, 1, 0, 0, 0);
        while (cal.get(7) != cal.getFirstDayOfWeek()) {
            cal.add(6, -1);
        }
        int bucket = 0;
        long value = 0L;
        while (cal.getTimeInMillis() < endTime) {
            if (value != cal.getTimeInMillis()) {
                value = cal.getTimeInMillis();
                refDays.add(bucket, value);
            }
            value += 86400000L;
            ++bucket;
            cal.add(6, 1);
        }
        refDays.createArrays();
    }

    public int getMonthBucket(long date) {
        int index = Arrays.binarySearch(this.months, date);
        if (index < 0) {
            index = -(index + 2);
        }
        return index;
    }

    public long getMonthDate(int i2) {
        return this.months[TimeZoneVariables.boundIndex(i2, this.months.length)];
    }

    private static int boundIndex(int i2, int length) {
        i2 = Math.max(i2, 0);
        i2 = Math.min(i2, length - 1);
        return i2;
    }

    public int getDayBucket(long time) {
        return this.refDays.getBucket(time);
    }

    public long getDayDate(int bucket) {
        return this.refDays.getDate(bucket);
    }

    public static Date hoursToDate(int hoursSinceEpoch) {
        return new Date((long)hoursSinceEpoch * 3600000L);
    }

    private static class DayBuckets {
        IntList refDaysBucketsList = new IntArrayList();
        LongList refDaysValuesList = new LongArrayList();
        public int[] refDaysBuckets;
        public long[] refDaysValues;

        private DayBuckets() {
        }

        public void createArrays() {
            this.refDaysBuckets = this.refDaysBucketsList.toIntArray();
            this.refDaysValues = this.refDaysValuesList.toLongArray();
            this.refDaysBucketsList = null;
            this.refDaysValuesList = null;
        }

        public void add(int bucket, long date) {
            this.refDaysBucketsList.add(bucket);
            this.refDaysValuesList.add(date);
        }

        public int getBucket(long time) {
            int index = Arrays.binarySearch(this.refDaysValues, time);
            if (index < 0) {
                index = -1 - index;
            }
            if (index > 0) {
                --index;
            }
            index = TimeZoneVariables.boundIndex(index, this.refDaysValues.length);
            return (int)((double)this.refDaysBuckets[index] + Math.floor((time - this.refDaysValues[index]) / 86400000L));
        }

        public long getDate(int bucket) {
            int index = Arrays.binarySearch(this.refDaysBuckets, bucket);
            if (index >= 0) {
                return this.refDaysValues[index];
            }
            if ((index = -1 - index) > 0) {
                --index;
            }
            if (index > this.refDaysBuckets.length) {
                index = this.refDaysBuckets.length - 1;
            }
            index = TimeZoneVariables.boundIndex(index, this.refDaysValues.length);
            return this.refDaysValues[index] + (long)(bucket - this.refDaysBuckets[index]) * 86400000L;
        }
    }
}

