/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketDataCollectionDiffs;
import com.atlassian.fisheye.bucket.Dir;
import com.atlassian.fisheye.bucket.ParameterSet;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.Recursion;
import com.cenqua.fisheye.rep.DbException;
import java.util.ArrayDeque;
import java.util.TimeZone;

class SumCollector {
    private final ArrayDeque<SumRecursion> stack = new ArrayDeque();
    private BucketDataCollectionDiffs total = new BucketDataCollectionDiffs(PeriodUnit.DAY, TimeZone.getDefault());

    SumCollector() {
    }

    public void add(BucketDataCollectionDiffs collection) throws DbException {
        this.total.add(collection);
    }

    private void addRecursion(SumRecursion rec) {
        this.stack.push(rec);
    }

    public void addRecursion(Dir element, ParameterSet parameters, int depth) {
        this.addRecursion(new SumRecursion(element, parameters, depth));
    }

    public void addRecursion(Dir element, ParameterSet parameters, int depth, String key) {
        this.addRecursion(new SumRecursion(element, parameters, depth, key));
    }

    public BucketDataCollectionDiffs getBuckets(Dir element, ParameterSetQuery parameters) throws DbException {
        this.total = new BucketDataCollectionDiffs(PeriodUnit.DAY, TimeZone.getDefault());
        element.getBuckets(parameters, parameters.getPath().numComponents() - 1, this);
        while (!this.stack.isEmpty()) {
            this.stack.pop().execute(this);
        }
        return this.total;
    }

    private static class SumRecursion
    extends Recursion {
        String key = null;

        SumRecursion(Dir node, ParameterSet parameters, int depth) {
            super(node, parameters, depth);
        }

        SumRecursion(Dir node, ParameterSet parameters, int depth, String key) {
            super(node, parameters, depth);
            this.key = key;
        }

        public void execute(SumCollector sum) throws DbException {
            if (this.key != null) {
                this.node.getBuckets((ParameterSetQuery)this.parameters, this.depth, sum, this.key);
            } else {
                this.node.getBuckets((ParameterSetQuery)this.parameters, this.depth, sum);
            }
        }
    }
}

