/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import java.util.Comparator;

public class SortValue {
    public final int lastValue;
    public final int sum;
    public final String key;

    public SortValue(String key, int lastValue, int sum) {
        this.key = key;
        this.lastValue = lastValue;
        this.sum = sum;
    }

    public int compareSum(SortValue otherValue) {
        return otherValue.sum - this.sum;
    }

    public int compareLastValue(SortValue otherValue) {
        return otherValue.lastValue - this.lastValue;
    }

    public int compareKey(SortValue otherValue) {
        return this.key.compareToIgnoreCase(otherValue.key);
    }

    public static Comparator<SortValue> getLastValueComparator() {
        return new Comparator<SortValue>(){

            @Override
            public int compare(SortValue sortValue, SortValue sortValue1) {
                int compareLastValue = sortValue.compareLastValue(sortValue1);
                int compareSum = sortValue.compareSum(sortValue1);
                if (compareLastValue != 0) {
                    return compareLastValue;
                }
                if (compareSum != 0) {
                    return compareSum;
                }
                return sortValue.compareKey(sortValue1);
            }
        };
    }

    public static Comparator<SortValue> getSumComparator() {
        return new Comparator<SortValue>(){

            @Override
            public int compare(SortValue sortValue, SortValue sortValue1) {
                int compareSum = sortValue.compareSum(sortValue1);
                int compareLastValue = sortValue.compareLastValue(sortValue1);
                if (compareSum != 0) {
                    return compareSum;
                }
                if (compareLastValue != 0) {
                    return compareLastValue;
                }
                return sortValue.compareKey(sortValue1);
            }
        };
    }

    public String toString() {
        return this.key + ": lastValue " + this.lastValue + ", sum " + this.sum;
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (!o2.getClass().equals(SortValue.class)) {
            return false;
        }
        SortValue otherValue = (SortValue)o2;
        return this.lastValue == otherValue.lastValue && this.sum == otherValue.sum && this.key.equals(otherValue.key);
    }

    public int hashCode() {
        int total = 0;
        total = this.key.hashCode();
        total = 29 * total + this.lastValue;
        total = 29 * total + this.sum;
        return total;
    }
}

