/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.TimeZoneVariables;
import java.util.HashMap;
import java.util.TimeZone;

public enum PeriodUnit {
    YEAR(Base.MONTH, 12),
    QUARTER(Base.MONTH, 3),
    MONTH(Base.MONTH, 1),
    WEEK(Base.DAY, 7),
    DAY(Base.DAY, 1);

    private Base base;
    private int mult;
    static HashMap<TimeZone, TimeZoneVariables> tzVariables;

    private PeriodUnit(Base base, int mult) {
        this.base = base;
        this.mult = mult;
    }

    private static TimeZoneVariables getTimeZoneVariables(TimeZone tz) {
        if (tzVariables.containsKey(tz)) {
            return tzVariables.get(tz);
        }
        TimeZoneVariables vars = new TimeZoneVariables(tz);
        tzVariables.put(tz, vars);
        return vars;
    }

    long bucketToStartDate(int bucket, TimeZone tz) {
        return this.base.bucketToStartDate(bucket * this.mult, tz);
    }

    long bucketToEndDate(int bucket, TimeZone tz) {
        return this.bucketToStartDate(bucket + 1, tz) - 1L;
    }

    public int dateToBucket(long date, TimeZone tz) {
        return (int)Math.floor(this.base.dateToBucket(date, tz) / this.mult);
    }

    static {
        tzVariables = new HashMap();
    }

    private static enum Base {
        DAY{

            @Override
            public int dateToBucket(long date, TimeZone tz) {
                return PeriodUnit.getTimeZoneVariables(tz).getDayBucket(date);
            }

            @Override
            public long bucketToStartDate(int bucket, TimeZone tz) {
                return PeriodUnit.getTimeZoneVariables(tz).getDayDate(bucket);
            }
        }
        ,
        MONTH{

            @Override
            public long bucketToStartDate(int bucket, TimeZone tz) {
                return PeriodUnit.getTimeZoneVariables(tz).getMonthDate(bucket);
            }

            @Override
            public int dateToBucket(long date, TimeZone tz) {
                return PeriodUnit.getTimeZoneVariables(tz).getMonthBucket(date);
            }
        };


        public abstract int dateToBucket(long var1, TimeZone var3);

        public abstract long bucketToStartDate(int var1, TimeZone var2);
    }
}

