/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.PeriodUnit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

public class Period
implements Comparable<Period> {
    private PeriodUnit periodUnit;
    private int bucket;
    private Date startDate;
    private Date endDate;
    private TimeZone timeZone;

    public Period(Date date, TimeZone timeZone) {
        this(BucketGraph.PERIOD_SLURP, date, timeZone);
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("E MMM dd HH:mm:ss zz yyyy", Locale.US);
        df.setTimeZone(this.timeZone);
        return this.bucket + " (" + df.format(this.startDate) + " - " + df.format(this.endDate) + ")";
    }

    public Period(PeriodUnit period, TimeZone timeZone) {
        this.periodUnit = period;
        this.timeZone = timeZone;
        this.setPeriod(new Date(0L));
    }

    public Period(int bucket, TimeZone timeZone) throws BucketGraph.InvalidBucketException {
        this(BucketGraph.PERIOD_SLURP, bucket, timeZone);
    }

    public Period(PeriodUnit period, int bucket, TimeZone timeZone) throws BucketGraph.InvalidBucketException {
        this.periodUnit = period;
        this.timeZone = timeZone;
        this.setPeriod(bucket);
    }

    public Period(PeriodUnit period, Date date, TimeZone timeZone) {
        this.periodUnit = period;
        this.timeZone = timeZone;
        this.setPeriod(date);
    }

    public void setPeriod(int bucket) throws BucketGraph.InvalidBucketException {
        this.bucket = bucket;
        this.startDate = this.bucketToStartDate(bucket);
        this.endDate = this.bucketToEndDate(bucket);
    }

    public void setPeriod(Date date) {
        this.bucket = this.periodUnit.dateToBucket(date.getTime(), this.timeZone);
        this.startDate = new Date(this.periodUnit.bucketToStartDate(this.bucket, this.timeZone));
        this.endDate = new Date(this.periodUnit.bucketToEndDate(this.bucket, this.timeZone));
    }

    public int getBucket() {
        return this.bucket;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public long getStartTime() {
        return this.startDate.getTime();
    }

    public long getEndTime() {
        return this.endDate.getTime();
    }

    public Date bucketToStartDate(int bucket) throws BucketGraph.InvalidBucketException {
        try {
            return new Date(this.periodUnit.bucketToStartDate(bucket, this.timeZone));
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new BucketGraph.InvalidBucketException("Invalid month or year bucket");
        }
    }

    public Date bucketToEndDate(int bucket) throws BucketGraph.InvalidBucketException {
        try {
            return new Date(this.periodUnit.bucketToEndDate(bucket, this.timeZone));
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new BucketGraph.InvalidBucketException("Invalid month or year bucket");
        }
    }

    public void setToNextBucket(int step) throws BucketGraph.InvalidBucketException {
        this.setPeriod(this.bucket + step);
    }

    public Period getNextBucket(int step) throws BucketGraph.InvalidBucketException {
        return new Period(this.periodUnit, this.bucket + step, this.timeZone);
    }

    public String getStringTT(SimpleDateFormat tooltipDateFormat) {
        String result = tooltipDateFormat.format(this.startDate);
        if (this.periodUnit != PeriodUnit.DAY) {
            result = result + " and " + tooltipDateFormat.format(this.endDate);
        }
        return result;
    }

    public TimePeriod getTimePeriod() {
        return new SimpleTimePeriod(this.startDate, this.endDate);
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    @Override
    public int compareTo(Period o2) {
        if (this.getStartTime() != o2.getStartTime()) {
            return (int)(this.getStartTime() - o2.getStartTime());
        }
        return o2.getPeriodUnit().ordinal() - this.getPeriodUnit().ordinal();
    }
}

