/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.ParameterSet;
import com.cenqua.fisheye.Path;
import java.util.Arrays;
import java.util.List;

public class ParameterSetQuery
extends ParameterSet {
    private static final String[] DEFAULT_AUTHORS = new String[]{"__ALL_AUTHORS__"};
    private static final String[] DEFAULT_EXTENSIONS = new String[]{"__ALL_EXTENSIONS__"};
    private static final BreakdownOption DEFAULT_BREAKDOWN = BreakdownOption.NONE;
    private String[] authors = DEFAULT_AUTHORS;
    private BreakdownOption breakdown = DEFAULT_BREAKDOWN;
    private String[] extensions = DEFAULT_EXTENSIONS;

    public ParameterSetQuery() {
    }

    public ParameterSetQuery(Path path, String branch, List<String> extensions, List<String> authors, BreakdownOption breakdown) {
        super(path, branch);
        this.authors = this.replaceIfNull(this.checkAuthors(authors), DEFAULT_AUTHORS);
        this.setBreakdown(breakdown);
        this.extensions = this.checkExtensions(extensions);
    }

    public ParameterSetQuery(Path path, String branch, String extension, String author) {
        super(path, branch);
        this.authors = new String[]{this.checkAuthor(author)};
        this.breakdown = BreakdownOption.NONE;
        this.extensions = new String[]{this.checkExtension(extension)};
    }

    private ParameterSetQuery(ParameterSetQuery other) {
        this.path = other.getPath();
        this.branch = other.getBranch();
        if (other.authors != DEFAULT_AUTHORS) {
            this.authors = new String[other.authors.length];
            System.arraycopy(other.authors, 0, this.authors, 0, other.authors.length);
        }
        this.breakdown = other.breakdown;
        if (other.extensions != DEFAULT_EXTENSIONS) {
            this.extensions = new String[other.extensions.length];
            System.arraycopy(other.extensions, 0, this.extensions, 0, other.extensions.length);
        }
    }

    public static ParameterSetQuery immutableCopyOf(ParameterSetQuery other) {
        return new ParameterSetQuery(other){

            @Override
            public void setBreakdown(BreakdownOption breakdown) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setAuthor(String author) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setExtension(String extension) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setAuthors(List<String> committers) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setPath(Path path) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setBranch(String branch) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BreakdownOption getBreakdown() {
        return this.breakdown;
    }

    public void setBreakdown(BreakdownOption breakdown) {
        this.breakdown = this.replaceIfNull(breakdown, DEFAULT_BREAKDOWN);
    }

    public String[] getAuthors() {
        return this.authors;
    }

    public void setAuthor(String author) {
        this.authors = this.replaceIfNull(new String[]{this.checkAuthor(author)}, DEFAULT_AUTHORS);
    }

    public void setExtension(String extension) {
        this.extensions = this.replaceIfNull(new String[]{this.checkExtension(extension)}, DEFAULT_EXTENSIONS);
    }

    public String getFormattedLabel() {
        return this.isTrunkLike() ? "(trunk)" : this.getBranch();
    }

    public boolean isTargetAuthor(String author) {
        for (String auth : this.authors) {
            if (!auth.equalsIgnoreCase(author)) continue;
            return true;
        }
        return false;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean isNoBreakdown() {
        return this.getBreakdown() == BreakdownOption.NONE;
    }

    private String[] checkAuthors(List<String> authors) {
        if (authors == null) {
            return DEFAULT_AUTHORS;
        }
        String[] authArray = new String[authors.size()];
        authors.toArray(authArray);
        for (int i2 = 0; i2 < authArray.length; ++i2) {
            authArray[i2] = this.checkAuthor(authArray[i2]);
        }
        return authArray;
    }

    private String checkAuthor(String author) {
        if (author == null) {
            return "__ALL_AUTHORS__";
        }
        if (author.length() == 0) {
            return "__NO_AUTHOR__";
        }
        if (author.equals("__NO_AUTHOR__") || author.equals("__ALL_AUTHORS__")) {
            return author;
        }
        return author.toLowerCase();
    }

    private String checkExtension(String extn) {
        if (extn == null) {
            return "__ALL_EXTENSIONS__";
        }
        if (extn.length() == 0) {
            return "__NO_EXTENSION__";
        }
        return this.processExtension(extn);
    }

    private String[] checkExtensions(List<String> extns) {
        if (extns == null) {
            return DEFAULT_EXTENSIONS;
        }
        String[] extnArray = new String[extns.size()];
        extns.toArray(extnArray);
        for (int i2 = 0; i2 < extnArray.length; ++i2) {
            extnArray[i2] = this.checkExtension(extnArray[i2]);
        }
        return extnArray;
    }

    private String processExtension(String extension) {
        if (extension.equals("__NO_EXTENSION__") || extension.equals("__ALL_EXTENSIONS__")) {
            return extension;
        }
        int dot = extension.indexOf(".");
        if (dot > 0) {
            return extension.substring(dot);
        }
        if (dot < 0) {
            return "." + extension;
        }
        return extension;
    }

    public boolean isAllAuthors() {
        return this.authors.length == 1 && this.authors[0].equals("__ALL_AUTHORS__");
    }

    public boolean isAllExtensions() {
        return this.extensions.length == 1 && this.extensions[0].equals("__ALL_EXTENSIONS__");
    }

    @Override
    public String toString() {
        return "Parameters: path " + this.getPath() + ", branch " + this.getBranch() + ", authors " + Arrays.toString(this.authors) + ", extensions " + Arrays.toString(this.extensions) + ", breakdown " + (Object)((Object)this.getBreakdown());
    }

    public void setAuthors(List<String> committers) {
        this.authors = this.replaceIfNull(this.checkAuthors(committers), DEFAULT_AUTHORS);
    }
}

