/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.ParameterSet;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.SumMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ParameterSetInsertion
extends ParameterSet {
    private static final List<String> NO_AUTHOR_SYNONYMS = Arrays.asList("", "no_author");
    private final SumMap<String> linecountByAuthor;
    private int numRevisions;
    private final int bucket;
    private final boolean isTrunklike;
    private final String extension;
    private final String commitAuthor;
    private long subBranchId;

    public ParameterSetInsertion(Path path, String branch, int bucket, SumMap<String> linecountByAuthor, String commitAuthor, int numRevisions, boolean isTrunklike, long subBranchId) {
        super(path, branch);
        this.extension = ParameterSetInsertion.getExtension(path);
        this.linecountByAuthor = this.checkAuthors(linecountByAuthor);
        this.numRevisions = numRevisions;
        this.bucket = bucket;
        this.isTrunklike = isTrunklike;
        this.commitAuthor = this.checkAuthor(commitAuthor);
        this.subBranchId = subBranchId;
    }

    public ParameterSetInsertion(Path path, String branch, int bucket, int linecount, int numRevisions, String commitAuthor, boolean isTrunklike, long subBranchId) {
        super(path, branch);
        this.numRevisions = numRevisions;
        this.bucket = bucket;
        this.isTrunklike = isTrunklike;
        this.extension = ParameterSetInsertion.getExtension(path);
        this.commitAuthor = this.checkAuthor(commitAuthor);
        this.linecountByAuthor = SumMap.getInstance(this.commitAuthor, linecount);
        this.subBranchId = subBranchId;
    }

    private static String getExtension(Path path) {
        String extn = path.getExtension();
        extn = extn == null ? "__NO_EXTENSION__" : "." + extn;
        return extn;
    }

    private SumMap<String> checkAuthors(SumMap<String> linecountByAuthor) {
        SumMap<String> linecountByAuthorChecked = SumMap.getInstance("");
        for (Object2IntMap.Entry e2 : linecountByAuthor.object2IntEntrySet()) {
            String correctedName = this.checkAuthor((String)e2.getKey());
            linecountByAuthorChecked.addValue(correctedName, e2.getIntValue());
        }
        return linecountByAuthorChecked;
    }

    public String checkAuthor(String commitAuthor) {
        if (ParameterSetInsertion.getNoAuthorSynonyms().contains(commitAuthor) || commitAuthor == null) {
            return "__NO_AUTHOR__";
        }
        return commitAuthor.toLowerCase(Locale.US);
    }

    @Override
    public String toString() {
        return this.getBucket() + "-" + this.getSubBranchId() + " linecountByAuthor " + this.getLinecountByAuthor() + ", numRevisions " + this.getNumRevisions();
    }

    public SumMap<String> getLinecountByAuthor() {
        return this.linecountByAuthor;
    }

    public int getNumRevisions() {
        return this.numRevisions;
    }

    public int getBucket() {
        return this.bucket;
    }

    public boolean isTrunklike() {
        return this.isTrunklike;
    }

    public static List<String> getNoAuthorSynonyms() {
        return NO_AUTHOR_SYNONYMS;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getCommitAuthor() {
        return this.commitAuthor;
    }

    public long getSubBranchId() {
        return this.subBranchId;
    }

    public void setSubBranchId(long subBranchId) {
        this.subBranchId = subBranchId;
    }

    public void setNumRevisions(int i2) {
        this.numRevisions = i2;
    }
}

