/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.Dir;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;

public class ParameterSet {
    public static final String NO_EXTENSION = "__NO_EXTENSION__";
    public static final String NO_AUTHOR = "__NO_AUTHOR__";
    public static final String ALL_AUTHORS = "__ALL_AUTHORS__";
    public static final String ALL_EXTENSIONS = "__ALL_EXTENSIONS__";
    public static final String TRUNKLIKE = "__TRUNKLIKE__";
    private static final Path DEFAULT_PATH = Path.ROOT;
    private static final String DEFAULT_BRANCH = "__TRUNKLIKE__";
    protected Path path = DEFAULT_PATH;
    protected String branch = "__TRUNKLIKE__";

    public ParameterSet() {
    }

    public ParameterSet(Path path, String branch) {
        this.setPath(path);
        this.setBranch(branch);
    }

    public void setPath(Path path) {
        this.path = this.replaceIfNull(path, DEFAULT_PATH);
    }

    public Path getPath() {
        return this.path;
    }

    public void setBranch(String branch) {
        this.branch = this.replaceIfNull(branch, "__TRUNKLIKE__");
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isTrunkLike() {
        return this.getBranch().equals("__TRUNKLIKE__");
    }

    public Dir loadSubdir(Dir dir, int depth) throws DbException {
        return dir.loadSubdir(this.getPath().getSubPath(depth + 2));
    }

    protected Position getPosition(int depth) {
        if (depth < this.getPath().numComponents() - 1) {
            return Position.BeforeLast;
        }
        if (depth == this.getPath().numComponents() - 1) {
            return Position.AtLast;
        }
        return Position.AfterLast;
    }

    protected <T> T replaceIfNull(T newValue, T defaultValue) {
        return newValue == null ? defaultValue : newValue;
    }

    public String toString() {
        return "Parameters: path " + this.getPath() + ", branch " + this.getBranch();
    }

    protected static enum Position {
        BeforeLast,
        AtLast,
        AfterLast;

    }
}

