/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.Dir;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.Recursion;
import com.cenqua.fisheye.rep.DbException;
import java.util.Stack;

class InsertIterator {
    private final Stack<InsertRecursion> stack = new Stack();

    InsertIterator() {
    }

    private void addRecursion(InsertRecursion rec) {
        this.stack.push(rec);
    }

    public void insert(Dir node, ParameterSetInsertion parameters, int depth) throws DbException {
        node.insertData(parameters, depth, this);
        while (!this.stack.empty()) {
            this.stack.pop().execute(this);
        }
    }

    public void addRecursion(Dir node, ParameterSetInsertion parameters, int depth) {
        this.addRecursion(new InsertRecursion(node, parameters, depth));
    }

    private static class InsertRecursion
    extends Recursion {
        InsertRecursion(Dir node, ParameterSetInsertion parameters, int depth) {
            super(node, parameters, depth);
        }

        public void execute(InsertIterator it) throws DbException {
            this.node.insertData((ParameterSetInsertion)this.parameters, this.depth, it);
        }
    }
}

