/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketDataCollectionDiffs;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class InfinityDBConnector {
    private static final int VERSION = 17;
    private final InfinityDbHandle dbh;
    private final String repname;
    private final CommonDirInfoDAO dirInfo;
    private final boolean caseSensitive;
    private final CommonStringTables commonStringTables;

    InfinityDBConnector(InfinityDbHandle dbh, String repname, boolean caseSensitive, CommonStringTables commonStringTables) {
        this.dbh = dbh;
        this.commonStringTables = commonStringTables;
        this.repname = repname;
        this.dirInfo = new CommonDirInfoDAO(dbh, commonStringTables, caseSensitive);
        this.caseSensitive = caseSensitive;
    }

    void saveBucketdataInfo(p attribute, int value) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKETDATA_INFO).a(attribute);
            int pl = cu.e();
            cu.b((long)value);
            db.e(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    private BucketDataCollectionDiffs getNewBucketDataCollection() throws DbException {
        return new BucketDataCollectionDiffs(PeriodUnit.DAY, TimeZone.getTimeZone(this.loadTimeZone()));
    }

    void addToData(long pathID, ParameterSetInsertion params, p attribute) throws DbException {
        int totalLinecount = 0;
        for (Object2IntMap.Entry element : params.getLinecountByAuthor().object2IntEntrySet()) {
            String author = (String)element.getKey();
            int linecount = element.getIntValue();
            totalLinecount += linecount;
            int revcount = author.equals(params.getCommitAuthor()) ? params.getNumRevisions() : 0;
            this.addToData(pathID, params, author, linecount, revcount, attribute);
        }
        if (!params.getLinecountByAuthor().keySet().contains(params.getCommitAuthor())) {
            this.addToData(pathID, params, params.getCommitAuthor(), 0, params.getNumRevisions(), attribute);
        }
        if (!params.getLinecountByAuthor().containsKey("__ALL_AUTHORS__")) {
            this.addToData(pathID, params, "__ALL_AUTHORS__", totalLinecount, params.getNumRevisions(), attribute);
        }
    }

    private void addToData(long pathID, ParameterSetInsertion params, String author, int linecount, int revcount, p attribute) throws DbException {
        this.addToData(pathID, params, author, linecount, revcount, params.getExtension(), attribute);
        this.addToData(pathID, params, author, linecount, revcount, "__ALL_EXTENSIONS__", attribute);
    }

    private void addToData(long pathID, ParameterSetInsertion params, String author, int linecount, int revcount, String extn, p attribute) throws DbException {
        this.addToData(pathID, params.getBranch(), author, extn, params.getBucket(), linecount, revcount, attribute, params.getSubBranchId());
        if (params.isTrunklike()) {
            this.addToData(pathID, "__TRUNKLIKE__", author, extn, params.getBucket(), linecount, revcount, attribute, params.getSubBranchId());
        }
    }

    private void addToData(long pathID, String branch, String author, String extn, int bucket, int linecount, int revcount, p attribute, long subBranch) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKET_DATA_NEW).b(pathID).a(attribute).b(branch).b(extn).b(author).b(subBranch).b((long)bucket);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                int offset = pl;
                linecount = (int)((long)linecount + cu.v(offset));
                offset = cu.w(offset);
                revcount = (int)((long)revcount + cu.v(offset));
            }
            cu.d(pl);
            cu.b((long)linecount).b((long)revcount);
            db.e(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    void dataToString(long pathID, String dirPrefix, StringBuffer sb, p attribute) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKET_DATA_NEW).b(pathID).a(attribute);
            int prefix = cu.e();
            String previousString = "";
            while (db.a(cu, prefix)) {
                String thisString = dirPrefix;
                int offset = prefix;
                thisString = thisString + "[" + cu.m(offset) + ", ";
                offset = cu.n(offset);
                thisString = thisString + cu.m(offset) + ", ";
                offset = cu.n(offset);
                if (!(thisString = thisString + cu.m(offset) + "] ").equals(previousString)) {
                    sb.append("\n").append(thisString);
                    previousString = thisString;
                }
                offset = cu.n(offset);
                sb.append(cu.v(offset)).append("-");
                offset = cu.w(offset);
                sb.append(cu.v(offset)).append("=[");
                offset = cu.w(offset);
                sb.append(cu.v(offset)).append(",");
                offset = cu.w(offset);
                sb.append(cu.v(offset)).append("] ");
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    BucketDataCollectionDiffs getBuckets(long pathID, ParameterSetQuery params, String key, p attribute) throws DbException {
        return this.getBucketsNoStack(pathID, params, key, attribute);
    }

    BucketDataCollectionDiffs getBuckets(long pathID, ParameterSetQuery params, p attribute) throws DbException {
        switch (params.getBreakdown()) {
            case NONE: {
                return this.getBucketsNoStack(pathID, params, "", attribute);
            }
            case SUBDIR: {
                break;
            }
            case EXTN: {
                if (params.isAllExtensions()) {
                    return this.getBucketsByExtn(pathID, params, attribute);
                }
                return this.getBucketsForSpecifiedExtns(pathID, params, attribute);
            }
            case USER: 
            case AUTHOR: {
                if (params.isAllAuthors()) {
                    return this.getBucketsByAuthor(pathID, params, attribute);
                }
                return this.getBucketsForSpecifiedAuthors(pathID, params, attribute);
            }
        }
        return this.getNewBucketDataCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BucketDataCollectionDiffs getBucketsNoStack(long pathID, ParameterSetQuery params, String key, p attribute) throws DbException {
        BucketDataCollectionDiffs bucketDataCollection = this.getNewBucketDataCollection();
        y cu = y.a();
        try {
            for (String author : params.getAuthors()) {
                for (String extn : params.getExtensions()) {
                    this.addBucketData(pathID, bucketDataCollection, attribute, params.getBranch(), extn, author, key, cu);
                }
            }
            BucketDataCollectionDiffs bucketDataCollectionDiffs = bucketDataCollection;
            return bucketDataCollectionDiffs;
        }
        finally {
            y.c(cu);
        }
    }

    private void addBucketData(long pathID, BucketDataCollectionDiffs bucketDataCollection, p attribute, String branch, String extn, String author, String label, y cu) throws DbException {
        cu.f().a(CommonSchema.E_BUCKET_DATA_NEW).b(pathID).a(attribute).b(branch).b(extn).b(author);
        int prefix = cu.e();
        ac db = this.dbh.get();
        try {
            while (db.a(cu, prefix)) {
                int offset = prefix;
                long subBranch = cu.v(offset);
                offset = cu.w(offset);
                int bucket = (int)cu.v(offset);
                offset = cu.w(offset);
                int linecount = (int)cu.v(offset);
                offset = cu.w(offset);
                int revcount = (int)cu.v(offset);
                bucketDataCollection.add(label, bucket, linecount, revcount, subBranch);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    BucketDataCollectionDiffs getBucketsByAuthor(long pathID, ParameterSetQuery params, p attribute) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            BucketDataCollectionDiffs bucketDataCollection = this.getNewBucketDataCollection();
            for (String extn : params.getExtensions()) {
                cu.f().a(CommonSchema.E_BUCKET_DATA_NEW).b(pathID).a(attribute).b(params.getBranch()).b(extn);
                int prefix = cu.e();
                while (db.a(cu, prefix)) {
                    int offset = prefix;
                    String author = cu.m(offset);
                    offset = cu.n(offset);
                    long subBranch = cu.v(offset);
                    offset = cu.w(offset);
                    int bucket = (int)cu.v(offset);
                    offset = cu.w(offset);
                    int linecount = (int)cu.v(offset);
                    offset = cu.w(offset);
                    int revcount = (int)cu.v(offset);
                    bucketDataCollection.add(author, bucket, linecount, revcount, subBranch);
                }
            }
            BucketDataCollectionDiffs bucketDataCollectionDiffs = bucketDataCollection;
            return bucketDataCollectionDiffs;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BucketDataCollectionDiffs getBucketsForSpecifiedAuthors(long pathID, ParameterSetQuery params, p attribute) throws DbException {
        y cu = y.a();
        try {
            BucketDataCollectionDiffs bucketDataCollection = this.getNewBucketDataCollection();
            for (String extn : params.getExtensions()) {
                for (String author : params.getAuthors()) {
                    this.addBucketData(pathID, bucketDataCollection, attribute, params.getBranch(), extn, author, author, cu);
                }
            }
            BucketDataCollectionDiffs bucketDataCollectionDiffs = bucketDataCollection;
            return bucketDataCollectionDiffs;
        }
        finally {
            y.c(cu);
        }
    }

    BucketDataCollectionDiffs getBucketsByExtn(long pathID, ParameterSetQuery params, p attribute) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            BucketDataCollectionDiffs bucketDataCollection = this.getNewBucketDataCollection();
            cu.f().a(CommonSchema.E_BUCKET_DATA_NEW).b(pathID).a(attribute).b(params.getBranch());
            int prefix = cu.e();
            while (db.a(cu, prefix)) {
                int offset = prefix;
                String extn = cu.m(offset);
                String author = cu.m(offset = cu.n(offset));
                if (!params.isTargetAuthor(author)) continue;
                offset = cu.n(offset);
                long subBranch = cu.v(offset);
                offset = cu.w(offset);
                int bucket = (int)cu.v(offset);
                offset = cu.w(offset);
                int linecount = (int)cu.v(offset);
                offset = cu.w(offset);
                int revcount = (int)cu.v(offset);
                bucketDataCollection.add(extn, bucket, linecount, revcount, subBranch);
            }
            BucketDataCollectionDiffs bucketDataCollectionDiffs = bucketDataCollection;
            return bucketDataCollectionDiffs;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BucketDataCollectionDiffs getBucketsForSpecifiedExtns(long pathID, ParameterSetQuery params, p attribute) throws DbException {
        y cu = y.a();
        try {
            BucketDataCollectionDiffs bucketDataCollection = this.getNewBucketDataCollection();
            for (String extn : params.getExtensions()) {
                for (String author : params.getAuthors()) {
                    this.addBucketData(pathID, bucketDataCollection, attribute, params.getBranch(), extn, author, extn, cu);
                }
            }
            BucketDataCollectionDiffs bucketDataCollectionDiffs = bucketDataCollection;
            return bucketDataCollectionDiffs;
        }
        finally {
            y.c(cu);
        }
    }

    void deleteAllData() throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKETDATA_INFO);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                db.c(cu);
            }
            cu.f().a(CommonSchema.E_BUCKET_DATA_NEW);
            pl = cu.e();
            while (db.a(cu, pl)) {
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    boolean isAtCurrentVersion() throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.f().a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_DB_VERSION);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                int dbVersion = (int)cu.v(pl);
                if (dbVersion == 17) {
                    boolean bl = true;
                    return bl;
                }
                Logs.APP_LOG.info((Object)("[" + this.repname + "] Linecount database at version " + dbVersion + ", upgrading to version " + 17 + ""));
                boolean bl = false;
                return bl;
            }
            Logs.APP_LOG.info((Object)("[" + this.repname + "] No linecount database exists, creating at version " + 17));
            boolean bl = false;
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    void setVersionToCurrent() throws DbException {
        this.saveBucketdataInfo(CommonSchema.BucketDataInfo.A_BUCKET_DB_VERSION, 17);
    }

    String loadTimeZone() throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_TIMEZONE);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                String string = cu.m(pl);
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    void saveTimeZone(TimeZone timeZone) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_TIMEZONE);
            int pl = cu.e();
            cu.b(timeZone.getID());
            db.e(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public int loadLastRevIdIndexed() throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_LAST_REV_ID_INDEXED);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                int n2 = (int)cu.v(pl);
                return n2;
            }
            int n3 = -1;
            return n3;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public int loadLastChangesetIdIndexed() throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_LAST_CHANGESET_ID_INDEXED);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                int n2 = (int)cu.v(pl);
                return n2;
            }
            int n3 = -1;
            return n3;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public boolean isRevIdIndexed(int revid) throws DbException {
        int min = this.loadLastRevIdIndexed();
        return revid <= min;
    }

    public void setRevIdIndexed(int revid) throws DbException {
        int lastRevIdIndexed = this.loadLastRevIdIndexed();
        if (revid > lastRevIdIndexed) {
            ac db = this.dbh.get();
            y cu = y.a();
            try {
                cu.a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_LAST_REV_ID_INDEXED);
                int pl = cu.e();
                cu.b((long)revid);
                db.e(cu, pl);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                y.c(cu);
            }
        }
    }

    public void setChangesetIdIndexed(long commitId) throws DbException {
        int lastBranchPointCommitIndexed = this.loadLastChangesetIdIndexed();
        if (commitId > (long)lastBranchPointCommitIndexed) {
            ac db = this.dbh.get();
            y cu = y.a();
            try {
                cu.a(CommonSchema.E_BUCKETDATA_INFO).a(CommonSchema.BucketDataInfo.A_BUCKET_LAST_CHANGESET_ID_INDEXED);
                int pl = cu.e();
                cu.b(commitId);
                db.e(cu, pl);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                y.c(cu);
            }
        }
    }

    public List<String> getAvailableExtns(Path path) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            long pathId = this.getPathId(path);
            ArrayList<String> extns = new ArrayList<String>();
            cu.a(CommonSchema.E_BUCKET_DATA_NEW).b(pathId).a(CommonSchema.BucketDataNew.A_EXTENSIONS);
            int prefix = cu.e();
            while (db.a(cu, prefix)) {
                extns.add(cu.m(prefix));
            }
            ArrayList<String> arrayList = extns;
            return arrayList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public long getPathId(Path path) throws DbException {
        return this.commonStringTables.pathDB.add(path.getPath(this.caseSensitive));
    }

    public String getPath(long pathId) throws DbException {
        return this.commonStringTables.pathDB.get(pathId);
    }

    public LongList getSubdirIDs(long pathId) throws DbException {
        ac db = this.dbh.get();
        EavEntityCu eav = new EavEntityCu(db, CommonSchema.DirInfo.ENTITY, pathId);
        LongAVLTreeSet ids = new LongAVLTreeSet();
        try {
            ids.addAll((LongCollection)eav.getLongs(CommonSchema.DirInfo.A_CHILD_DIRS));
            ids.addAll((LongCollection)eav.getLongs(CommonSchema.DirInfo.A_CHILD_FILES));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return new LongArrayList((LongCollection)ids);
    }

    public long addFileToIndex(Path path) throws IOException, DbException {
        this.dirInfo.addFileToParent(path);
        return this.commonStringTables.pathDB.add(path.getPath());
    }

    public long addDirToIndex(Path path) throws IOException, DbException {
        this.dirInfo.addDirToParent(path);
        return this.commonStringTables.pathDB.add(path.getPath(this.caseSensitive));
    }

    public void addToExtensionCache(long pathId, String extension) throws DbException {
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BUCKET_DATA_NEW).b(pathId).a(CommonSchema.BucketDataNew.A_EXTENSIONS).b(extension);
            this.dbh.get().b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }
}

