/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.InfinityDBConnector;
import com.atlassian.fisheye.bucket.InsertIterator;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.SumCollector;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import it.unimi.dsi.fastutil.longs.LongListIterator;

class Dir {
    private static final int SUBDIR_CACHE_MIN_DEPTH = -1;
    private static int SUBDIR_CACHE_MAX_DEPTH = 5;
    private long pathId = -1L;
    private final InfinityDBConnector con;

    Dir(Path path, InfinityDBConnector con) throws DbException {
        this.con = con;
        this.pathId = con.getPathId(path);
    }

    private Dir(long pathId, InfinityDBConnector con) {
        this.con = con;
        this.pathId = pathId;
    }

    static void setCacheDepth(int depth) {
        SUBDIR_CACHE_MAX_DEPTH = -1 + depth;
    }

    static int getCacheDepth() {
        return SUBDIR_CACHE_MAX_DEPTH - -1;
    }

    private static boolean useSubtotalCache(int depth) {
        return depth >= -1 && depth < SUBDIR_CACHE_MAX_DEPTH;
    }

    void getBuckets(ParameterSetQuery parameters, int depth, SumCollector sum) throws DbException {
        switch (parameters.getPosition(depth)) {
            case BeforeLast: {
                break;
            }
            case AtLast: 
            case AfterLast: {
                if (parameters.getBreakdown() == BreakdownOption.SUBDIR) {
                    LongListIterator longListIterator = this.con.getSubdirIDs(this.pathId).iterator();
                    while (longListIterator.hasNext()) {
                        long subdir = (Long)longListIterator.next();
                        sum.addRecursion(this.loadSubdir(subdir), parameters, depth + 1, this.getLastPath(this.con.getPath(subdir)));
                    }
                } else {
                    sum.add(this.con.getBuckets(this.pathId, parameters, CommonSchema.BucketDataNew.A_DATA));
                    if (Dir.useSubtotalCache(depth)) {
                        sum.add(this.con.getBuckets(this.pathId, parameters, CommonSchema.BucketDataNew.A_CACHE));
                        break;
                    }
                    LongListIterator longListIterator = this.con.getSubdirIDs(this.pathId).iterator();
                    while (longListIterator.hasNext()) {
                        long subdir = (Long)longListIterator.next();
                        sum.addRecursion(this.loadSubdir(subdir), parameters, depth + 1);
                    }
                }
                break;
            }
        }
    }

    private String getLastPath(String path) {
        int index;
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf("/")) > -1 && index < path.length() - 1) {
            return path.substring(index + 1);
        }
        return path;
    }

    void getBuckets(ParameterSetQuery parameters, int depth, SumCollector sum, String key) throws DbException {
        if (depth == parameters.getPath().numComponents()) {
            sum.add(this.con.getBuckets(this.pathId, parameters, ". (this dir)", CommonSchema.BucketDataNew.A_DATA));
        } else {
            sum.add(this.con.getBuckets(this.pathId, parameters, key, CommonSchema.BucketDataNew.A_DATA));
        }
        if (Dir.useSubtotalCache(depth)) {
            sum.add(this.con.getBuckets(this.pathId, parameters, key, CommonSchema.BucketDataNew.A_CACHE));
        } else {
            LongListIterator longListIterator = this.con.getSubdirIDs(this.pathId).iterator();
            while (longListIterator.hasNext()) {
                long subdir = (Long)longListIterator.next();
                sum.addRecursion(this.loadSubdir(subdir), parameters, depth + 1, key);
            }
        }
    }

    void insertData(ParameterSetInsertion parameters, int depth, InsertIterator it) throws DbException {
        switch (parameters.getPosition(depth)) {
            case AtLast: {
                this.addToData(parameters);
                break;
            }
            case BeforeLast: {
                this.con.addToExtensionCache(this.pathId, parameters.getExtension());
                if (Dir.useSubtotalCache(depth)) {
                    this.addToCache(parameters);
                }
                it.addRecursion(parameters.loadSubdir(this, depth), parameters, depth + 1);
            }
        }
    }

    String toStringFull() throws DbException {
        StringBuffer buffer = new StringBuffer();
        this.toStringNodes("", buffer);
        return buffer.toString();
    }

    private void toStringNodes(String prefix, StringBuffer buffer) throws DbException {
        String path = this.con.getPath(this.pathId);
        this.con.dataToString(this.pathId, path + " data ", buffer, CommonSchema.BucketDataNew.A_DATA);
        this.con.dataToString(this.pathId, path + " cache ", buffer, CommonSchema.BucketDataNew.A_CACHE);
        LongListIterator longListIterator = this.con.getSubdirIDs(this.pathId).iterator();
        while (longListIterator.hasNext()) {
            long subdirId = (Long)longListIterator.next();
            Dir subdir = new Dir(subdirId, this.con);
            subdir.toStringNodes(prefix + this.con.getPath(subdirId), buffer);
        }
    }

    Dir loadSubdir(Path path) throws DbException {
        return new Dir(path, this.con);
    }

    Dir loadSubdir(long id) {
        return new Dir(id, this.con);
    }

    private void addToData(ParameterSetInsertion parameters) throws DbException {
        this.con.addToData(this.pathId, parameters, CommonSchema.BucketDataNew.A_DATA);
    }

    private void addToCache(ParameterSetInsertion parameters) throws DbException {
        this.con.addToData(this.pathId, parameters, CommonSchema.BucketDataNew.A_CACHE);
    }

    public String toString() {
        return "DirInfDB " + this.pathId;
    }
}

