/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollection;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElementTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraph;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.fisheye.vis.LocChartParams;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CalculatedBucketGraphXY
extends CalculatedBucketGraph {
    private static final int GRAPH_BORDER_WIDTH = 30;
    Object2ObjectSortedMap<String, ChartData> chartDataCollection = new Object2ObjectLinkedOpenHashMap();
    private Date dateStart = new Date(0L);
    private Date dateEnd = new Date();
    private final boolean showLegend;
    private static final double X_AXIS_DEFAULT_BUFFER = 0.05;
    private List<String> repositories = new ArrayList<String>();
    private final boolean preserveOrder;

    public CalculatedBucketGraphXY(BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip) {
        super(option, alwaysAppendSeriesKeyToTooltip);
        this.showLegend = false;
        this.dateStart = new Date(0L);
        this.dateEnd = new Date();
        this.preserveOrder = false;
    }

    public CalculatedBucketGraphXY(BucketDataCollectionTotalled bucketsAll, boolean trunkLike, Date date1, Date date2, String repname, LocChartParams locParams, int maxItemsInChart, boolean isChange, Multimap<String, String> rename, BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip, boolean preserveOrder) throws DbException {
        super(option, alwaysAppendSeriesKeyToTooltip);
        this.preserveOrder = preserveOrder;
        this.showLegend = locParams.isShowLegend() && !option.equals((Object)BreakdownOption.NONE);
        Pair<Date, Date> dates = CalculatedBucketGraphXY.calculateDates(date1, date2, bucketsAll.getFirstBucket(), bucketsAll.getLastBucket(), bucketsAll.getTimeZone(), isChange);
        this.dateStart = dates.getFirst();
        this.dateEnd = dates.getSecond();
        PeriodUnit periodGraph = CalculatedBucketGraphXY.choosePeriod(this.dateStart, this.dateEnd, locParams);
        this.constructXYSeries(bucketsAll, trunkLike, periodGraph, repname, maxItemsInChart, isChange, rename);
    }

    public CalculatedBucketGraphXY(BucketDataCollectionTotalled bucketsAll, boolean trunkLike, PeriodUnit periodGraph, String repname, int maxElements, BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip) throws DbException {
        super(option, alwaysAppendSeriesKeyToTooltip);
        this.showLegend = false;
        Pair<Date, Date> dates = CalculatedBucketGraphXY.calculateDates(null, null, bucketsAll.getFirstBucket(), bucketsAll.getLastBucket(), bucketsAll.getTimeZone(), false);
        this.dateStart = dates.getFirst();
        this.dateEnd = dates.getSecond();
        this.preserveOrder = false;
        this.constructXYSeries(bucketsAll, trunkLike, periodGraph, repname, maxElements, false, null);
    }

    public XYSeriesCollection getLinecountCollection() {
        if (this.hasSubBranches()) {
            Logs.APP_LOG.debug((Object)"Ignoring subbranches");
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        for (Object2ObjectMap.Entry e2 : this.chartDataCollection.object2ObjectEntrySet()) {
            for (ChartDataSubBranch e22 : ((ChartData)e2.getValue()).subBranchDataCollection.values()) {
                collection.addSeries(e22.linecount);
            }
        }
        return collection;
    }

    public TimePeriodValuesCollection getRevisioncountCollection() {
        if (this.hasSubBranches()) {
            Logs.APP_LOG.debug((Object)"Ignoring subbranches");
        }
        TimePeriodValuesCollection collection = new TimePeriodValuesCollection();
        for (Object2ObjectMap.Entry e2 : this.chartDataCollection.object2ObjectEntrySet()) {
            collection.addSeries(((ChartData)e2.getValue()).getRevcount());
        }
        return collection;
    }

    private void addDatapoint(String key, long subbranch, int linecountTotal, int revcountTotal, Period period, String lcDescription) {
        if (period.getBucket() >= 0) {
            ChartData chartData = this.getChartData(key);
            String lcTooltip = this.getLinecountTooltip(period, linecountTotal, lcDescription, key);
            chartData.addData(subbranch, linecountTotal, revcountTotal, period, lcTooltip);
        } else {
            Logs.APP_LOG.debug((Object)("trying to add data to a negative bucket: " + key + " " + linecountTotal + " " + revcountTotal + " " + period + " " + lcDescription));
        }
    }

    private ChartData getChartData(String key) {
        if (this.chartDataCollection.containsKey((Object)key)) {
            return (ChartData)this.chartDataCollection.get((Object)key);
        }
        ChartData chartData = new ChartData(key);
        this.chartDataCollection.put((Object)key, (Object)chartData);
        return chartData;
    }

    public CategoryTableXYDataset getRevcountForStack() {
        CategoryTableXYDataset data = new CategoryTableXYDataset();
        for (Object2ObjectMap.Entry e2 : this.chartDataCollection.object2ObjectEntrySet()) {
            TimePeriodValues series = ((ChartData)e2.getValue()).getRevcount();
            for (int j2 = 0; j2 < series.getItemCount(); ++j2) {
                data.add((double)((series.getTimePeriod(j2).getStart().getTime() + series.getTimePeriod(j2).getEnd().getTime()) / 2L), series.getValue(j2).doubleValue(), series.getKey().toString());
            }
        }
        return data;
    }

    public Date getChartMinDate() {
        return new Date(this.dateStart.getTime() - (long)((double)(this.dateEnd.getTime() - this.dateStart.getTime()) * 0.05));
    }

    public Date getChartMaxDate() {
        return new Date(this.dateEnd.getTime() + (long)((double)(this.dateEnd.getTime() - this.dateStart.getTime()) * 0.05));
    }

    @Override
    public boolean noGraphData() {
        return this.chartDataCollection.isEmpty();
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    private void constructXYSeries(BucketDataCollectionTotalled allBuckets, boolean isTrunkLike, PeriodUnit periodGraph, String repname, int maxElements, boolean change, Multimap<String, String> rename) throws DbException {
        allBuckets = this.filterBucketData(allBuckets, periodGraph, change);
        this.constructXYSeries(allBuckets, isTrunkLike, repname, maxElements, change, rename);
    }

    private void constructXYSeries(BucketDataCollectionTotalled allBuckets, boolean isTrunkLike, String repname, int maxElements, boolean change, Multimap<String, String> rename) throws DbException {
        try {
            this.addSubBranchEnds(allBuckets, isTrunkLike);
            List bucketDataList = this.preserveOrder ? allBuckets.getValueList() : allBuckets.consolidateAndSort(maxElements, rename);
            Period firstPeriod = new Period(allBuckets.getPeriodUnit(), this.getChartMinDate(), allBuckets.getTimeZone());
            Period lastPeriod = new Period(allBuckets.getPeriodUnit(), this.getChartMaxDate(), allBuckets.getTimeZone());
            for (BucketDataTotalled bucketData : bucketDataList) {
                int changeOffset = bucketData.getChangeOffset();
                String key = this.formatLabel(bucketData.getLabel());
                for (Long2ObjectMap.Entry e2 : bucketData.entrySet()) {
                    int firstBucket;
                    long subBranch = e2.getLongKey();
                    Int2ObjectSortedMap data = (Int2ObjectSortedMap)e2.getValue();
                    int loc = 0 - changeOffset;
                    int rev = 0;
                    for (int bucket = firstBucket = Math.min(firstPeriod.getBucket() - 1, data.firstIntKey()); bucket <= lastPeriod.getBucket() + 1; ++bucket) {
                        if (data.containsKey(bucket)) {
                            BucketDataElementTotalled bde = (BucketDataElementTotalled)data.get(bucket);
                            loc = bde.getTotalLinecount() - changeOffset;
                            rev = bde.getRevcount();
                        } else {
                            rev = 0;
                        }
                        if (bucket < firstPeriod.getBucket() - 1) continue;
                        Period period = new Period(allBuckets.getPeriodUnit(), bucket, allBuckets.getTimeZone());
                        String desc = change ? this.makeDescription(loc + changeOffset, changeOffset, period.getEndDate()) : "";
                        this.addDatapoint(key, subBranch, loc, rev, period, desc);
                    }
                }
            }
        }
        catch (BucketGraph.InvalidBucketException e3) {
            Logs.APP_LOG.warn((Object)("Repository " + repname + ": Error parsing bucket: " + e3.getMessage()));
        }
    }

    private void addSubBranchEnds(BucketDataCollectionTotalled data, boolean isTrunkLike) {
        for (Map.Entry e1 : data.entrySet()) {
            BucketDataTotalled bucketData = (BucketDataTotalled)e1.getValue();
            if (bucketData.subBranchInfoCollection.isEmpty()) {
                int firstBucket = data.getFirstBucket();
                int nowBucket = data.periodUnit.dateToBucket(System.currentTimeMillis(), data.getTimeZone());
                if (isTrunkLike) {
                    --firstBucket;
                }
                for (BucketDataTotalled e2 : data.data.values()) {
                    e2.add(0L, firstBucket, 0, 0, 0, 0);
                    if (e2.getLastBucket() >= nowBucket) continue;
                    BucketDataElementTotalled lastData = (BucketDataElementTotalled)e2.getBucketData(0L, e2.getLastBucket());
                    e2.add(0L, nowBucket, 0, 0, lastData.getTotalLinecount(), lastData.getTotalRevcount());
                }
                continue;
            }
            Long2ObjectMap<BucketData.SubBranchInfo> subBranchInfoCollection = bucketData.getSubBranchInfoCollection();
            for (BucketData.SubBranchInfo subBranchInfo : subBranchInfoCollection.values()) {
                if (subBranchInfo.hasCsBranchParent()) {
                    this.addSubBranchStart(subBranchInfo, bucketData, data);
                } else {
                    int branchStartBucket = this.getBucket(subBranchInfo.getCsBranchStartDate(), data);
                    bucketData.add(subBranchInfo.getSubBranchId(), branchStartBucket - 1, 0, 0, 0, 0);
                }
                if (!subBranchInfo.hasCsMergeEnd()) continue;
                this.addSubBranchEnd(subBranchInfo, bucketData, data);
            }
        }
    }

    private void addSubBranchStart(BucketData.SubBranchInfo subBranchInfo, BucketDataTotalled bucketData, BucketDataCollectionTotalled data) {
        long subBranchStart;
        Period branchStartPeriod = this.getPeriod(subBranchInfo.getCsBranchStartDate(), data);
        long subBranchId = subBranchInfo.getSubBranchId();
        BucketData.SubBranchInfo parentSubBranchInfo = subBranchInfo;
        do {
            if (!parentSubBranchInfo.hasCsBranchParent()) {
                bucketData.adjustStart(subBranchId, branchStartPeriod.getBucket() - 1, 0);
                return;
            }
            subBranchStart = parentSubBranchInfo.getCsBranchStartDate();
            parentSubBranchInfo = (BucketData.SubBranchInfo)bucketData.getSubBranchInfoCollection().get(parentSubBranchInfo.getCsBranchParentSubBranchId());
            if (parentSubBranchInfo != null) continue;
            bucketData.adjustStart(subBranchId, branchStartPeriod.getBucket() - 1, 0);
            return;
        } while (parentSubBranchInfo.getCsBranchStartDate() > branchStartPeriod.getStartTime());
        Period branchPointPeriod = this.getPeriod(subBranchStart, data);
        int bucket = Math.min(branchStartPeriod.getBucket() - 1, branchPointPeriod.getBucket());
        int linecount = bucketData.getCumulativeLocAtBucket(parentSubBranchInfo.getSubBranchId(), bucket);
        bucketData.adjustStart(subBranchId, bucket, linecount);
        if (bucket != branchStartPeriod.getBucket() - 1) {
            bucketData.adjustStart(subBranchId, branchStartPeriod.getBucket() - 1, linecount);
        }
    }

    private void addSubBranchEnd(BucketData.SubBranchInfo subBranchInfo, BucketDataTotalled bucketData, BucketDataCollection data) {
        Period branchEndPeriod = this.getPeriod(subBranchInfo.getCsLastOnBranchDate(), data);
        long subBranchId = subBranchInfo.getSubBranchId();
        BucketData.SubBranchInfo childSubBranchInfo = subBranchInfo;
        long mergeDate = 0L;
        do {
            mergeDate = childSubBranchInfo.getCsMergeEndDate();
            childSubBranchInfo = (BucketData.SubBranchInfo)bucketData.getSubBranchInfoCollection().get(childSubBranchInfo.getCsMergeEndSubBranchId());
            if (childSubBranchInfo != null) continue;
            return;
        } while (childSubBranchInfo.getCsLastOnBranchDate() < branchEndPeriod.getEndTime() && childSubBranchInfo.hasCsMergeEnd());
        Period mergePointPeriod = this.getPeriod(mergeDate, data);
        int bucket = Math.max(branchEndPeriod.getBucket(), mergePointPeriod.getBucket());
        int linecount = bucketData.getCumulativeLocAtBucket(childSubBranchInfo.getSubBranchId(), bucket);
        bucketData.adjustEnd(subBranchId, bucket, linecount);
        if (bucket != branchEndPeriod.getBucket()) {
            bucketData.adjustEnd(subBranchId, branchEndPeriod.getBucket(), linecount);
        }
    }

    private int getBucket(long date, BucketDataCollection data) {
        return data.getPeriodUnit().dateToBucket(date, data.getTimeZone());
    }

    private Period getPeriod(long date, BucketDataCollection data) {
        return new Period(data.getPeriodUnit(), new Date(date), data.getTimeZone());
    }

    private BucketDataCollectionTotalled filterBucketData(BucketDataCollectionTotalled allBuckets, PeriodUnit periodGraph, boolean isChange) throws DbException {
        TimeZone tz = allBuckets.getTimeZone();
        try {
            long dataStartTime = PeriodUnit.DAY.bucketToStartDate(allBuckets.getFirstBucket(), tz);
            long dataEndTime = PeriodUnit.DAY.bucketToEndDate(allBuckets.getLastBucket(), tz);
            if (periodGraph == PeriodUnit.DAY && dataStartTime > this.dateStart.getTime() && dataEndTime < this.dateEnd.getTime()) {
                return allBuckets;
            }
            BucketDataCollectionTotalled newData = new BucketDataCollectionTotalled(periodGraph, allBuckets.getTimeZone());
            for (Map.Entry e1 : allBuckets.entrySet()) {
                String label = (String)e1.getKey();
                BucketDataTotalled bucketData = (BucketDataTotalled)e1.getValue();
                BucketDataTotalled newBucketData = new BucketDataTotalled(label);
                newData.add(newBucketData);
                newBucketData.setSubBranchInfoCollection(bucketData.getSubBranchInfoCollection());
                for (Long2ObjectMap.Entry e2 : bucketData.entrySet()) {
                    long subBranch = e2.getLongKey();
                    int changeOffset = 0;
                    for (Int2ObjectMap.Entry e3 : ((Int2ObjectSortedMap)e2.getValue()).int2ObjectEntrySet()) {
                        BucketDataElementTotalled newBDE;
                        Period newPeriod;
                        int bucket = e3.getIntKey();
                        BucketDataElementTotalled oldBDE = (BucketDataElementTotalled)e3.getValue();
                        Period origPeriod = new Period(PeriodUnit.DAY, bucket, tz);
                        Period period = newPeriod = periodGraph == PeriodUnit.DAY ? origPeriod : new Period(periodGraph, origPeriod.getStartDate(), tz);
                        if (isChange && origPeriod.getEndTime() < this.dateStart.getTime()) {
                            changeOffset = oldBDE.getTotalLinecount();
                            newBucketData.setChangeOffset(changeOffset);
                        }
                        if ((newBDE = (BucketDataElementTotalled)newBucketData.getBucketData(subBranch, newPeriod.getBucket())) == null) {
                            newBucketData.add(subBranch, newPeriod.getBucket(), oldBDE.getLinecountChange(), oldBDE.getRevcount(), oldBDE.getTotalLinecount(), oldBDE.getTotalRevcount());
                            continue;
                        }
                        newBDE.setTotalLinecount(oldBDE.getTotalLinecount());
                        newBDE.setTotalRevcount(oldBDE.getTotalRevcount());
                        newBDE.addLinecountChange(oldBDE.getLinecountChange());
                        newBDE.addRevcountChange(oldBDE.getRevcount());
                    }
                }
            }
            return newData;
        }
        catch (BucketGraph.InvalidBucketException e2) {
            throw new DbException(e2);
        }
    }

    private String makeDescription(int totalLinecount, int firstLineCount, Date date) {
        StringBuilder description = new StringBuilder();
        if (totalLinecount - firstLineCount > 0) {
            description.append("increased by ");
            description.append(LargeNumberFormatter.formatNumber(Math.abs(totalLinecount - firstLineCount)));
            description.append(", from ").append(LargeNumberFormatter.formatNumber(firstLineCount)).append(" to ").append(LargeNumberFormatter.formatNumber(totalLinecount));
        } else if (totalLinecount == firstLineCount) {
            description.append("didn't change ");
        } else {
            description.append(" decreased by ");
            description.append(LargeNumberFormatter.formatNumber(Math.abs(totalLinecount - firstLineCount)));
            description.append(", from ").append(LargeNumberFormatter.formatNumber(firstLineCount)).append(" to ").append(LargeNumberFormatter.formatNumber(totalLinecount));
        }
        description.append(" between ").append(this.tooltipDateFormat.format(this.dateStart)).append(" and ").append(this.tooltipDateFormat.format(date));
        return description.toString();
    }

    static Pair<Date, Date> calculateDates(Date dateStart, Date dateEnd, int firstBucket, int lastBucket, TimeZone timeZone, boolean isChange) {
        try {
            Period maxPeriod;
            Period periodDataStart = new Period(firstBucket, timeZone);
            Period periodDataEnd = new Period(lastBucket, timeZone);
            Period periodNow = new Period(new Date(), timeZone);
            periodDataEnd = periodDataEnd.getBucket() > periodNow.getBucket() ? periodDataEnd : periodNow;
            Period minPeriod = dateStart == null ? periodDataStart : new Period(dateStart, timeZone);
            Period period = maxPeriod = dateEnd == null ? periodDataEnd : new Period(dateEnd, timeZone);
            if (minPeriod.getStartTime() > maxPeriod.getStartTime()) {
                minPeriod = periodDataStart;
                maxPeriod = periodDataEnd;
            }
            while (maxPeriod.getBucket() - minPeriod.getBucket() < 7) {
                maxPeriod.setToNextBucket(1);
                if (isChange) continue;
                minPeriod.setToNextBucket(-1);
            }
            return Pair.newInstance(minPeriod.getStartDate(), maxPeriod.getEndDate());
        }
        catch (BucketGraph.InvalidBucketException e2) {
            return Pair.newInstance(new Date(0L), new Date());
        }
    }

    static PeriodUnit choosePeriod(Date minDate, Date maxDate, LocChartParams locParams) {
        long length = maxDate.getTime() - minDate.getTime();
        long maxBuckets = (locParams.getSize().width - 30) / locParams.getMaxBarWidth();
        double days = length / 86400000L;
        double weeks = days / 7.0;
        double months = days / 30.4;
        double years = days / 365.25;
        double quarters = years * 4.0;
        PeriodUnit result = PeriodUnit.YEAR;
        if (days < (double)maxBuckets) {
            result = PeriodUnit.DAY;
        } else if (weeks < (double)maxBuckets) {
            result = PeriodUnit.WEEK;
        } else if (months < (double)maxBuckets) {
            result = PeriodUnit.MONTH;
        } else if (quarters < (double)maxBuckets) {
            result = PeriodUnit.QUARTER;
        }
        return result;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public int getSeriesCount() {
        return this.chartDataCollection.size();
    }

    public List getRevcountTooltips(String seriesKey) {
        return ((ChartData)this.chartDataCollection.get((Object)seriesKey)).getRcTooltips();
    }

    public long getLowestXValue() {
        long lowestX = Long.MAX_VALUE;
        for (Object2ObjectMap.Entry e2 : this.chartDataCollection.object2ObjectEntrySet()) {
            for (ChartDataSubBranch e22 : ((ChartData)e2.getValue()).subBranchDataCollection.values()) {
                XYSeries series = e22.linecount;
                lowestX = Math.min(lowestX, series.getDataItem(0).getX().longValue());
            }
        }
        return lowestX;
    }

    public boolean hasSubBranches() {
        LongOpenHashSet subBranches = new LongOpenHashSet();
        for (Object2ObjectMap.Entry e2 : this.chartDataCollection.object2ObjectEntrySet()) {
            subBranches.addAll((LongCollection)((ChartData)e2.getValue()).subBranchDataCollection.keySet());
            if (subBranches.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public Object2ObjectSortedMap<String, ChartData> getChartDataCollection() {
        return this.chartDataCollection;
    }

    public static class ChartDataSubBranch {
        Object2IntSortedMap<Period> data = new Object2IntAVLTreeMap();
        XYSeries linecount;
        List<String> lcTooltips = new ArrayList<String>();

        public ChartDataSubBranch(String key) {
            this.linecount = new XYSeries((Comparable)((Object)key), true, false);
        }

        public void addLinecountTooltip(String lcTooltip) {
            this.lcTooltips.add(lcTooltip);
        }

        public XYSeries getLinecountData() {
            return this.linecount;
        }

        public List getLinecountTooltips() {
            return this.lcTooltips;
        }

        public String toString() {
            return "ChartDataSubBranch{linecount=" + this.linecount + ", lcTooltips=" + this.lcTooltips + '}';
        }
    }

    public class ChartData {
        private String key;
        private Long2ObjectSortedMap<ChartDataSubBranch> subBranchDataCollection = new Long2ObjectAVLTreeMap();
        SumMap<Period> revcountTotals = new SumMap(new Object2IntAVLTreeMap());

        public ChartData(String key) {
            this.key = key;
        }

        public void addData(long subbranch, int linecountTotal, int revcountTotal, Period period, String lcTooltip) {
            ChartDataSubBranch subBranchData;
            if (this.subBranchDataCollection.containsKey(subbranch)) {
                subBranchData = (ChartDataSubBranch)this.subBranchDataCollection.get(subbranch);
            } else {
                subBranchData = new ChartDataSubBranch(this.key + "-" + subbranch);
                this.subBranchDataCollection.put(subbranch, (Object)subBranchData);
            }
            subBranchData.linecount.add((double)period.getEndTime(), (double)linecountTotal);
            this.revcountTotals.addValue(period, revcountTotal);
            subBranchData.addLinecountTooltip(lcTooltip);
        }

        public Long2ObjectSortedMap<ChartDataSubBranch> getSubBranchDataCollection() {
            return this.subBranchDataCollection;
        }

        public TimePeriodValues getRevcount() {
            TimePeriodValues revcount = new TimePeriodValues(this.key);
            for (Object2IntMap.Entry e2 : this.revcountTotals.object2IntEntrySet()) {
                revcount.add(((Period)e2.getKey()).getTimePeriod(), (double)e2.getIntValue());
            }
            return revcount;
        }

        public List getRcTooltips() {
            ArrayList<String> toolTips = new ArrayList<String>();
            for (Object2IntMap.Entry e2 : this.revcountTotals.object2IntEntrySet()) {
                toolTips.add(CalculatedBucketGraphXY.this.getRevcountTooltip((Period)e2.getKey(), e2.getIntValue(), this.key));
            }
            return toolTips;
        }

        public String toString() {
            return "ChartData{key='" + this.key + '\'' + ", subBranchDataCollection=" + this.subBranchDataCollection + ", revcountTotals=" + this.revcountTotals + '}';
        }
    }
}

