/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.CalculatedBucketGraph;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.SortOrder;

public class CalculatedBucketGraphPie
extends CalculatedBucketGraph {
    private DefaultPieDataset pieData = new DefaultPieDataset();
    private final Date date;
    private static final double MIN_FRACTION_TO_SHOW = 0.03;
    private static final int MAX_ELEMENTS_TO_SHOW = 10;

    public CalculatedBucketGraphPie(Date date, Object2IntMap<String> pieValues, int maxItems, BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip) {
        super(option, alwaysAppendSeriesKeyToTooltip);
        this.date = date;
        this.processData(pieValues, maxItems, null);
    }

    public CalculatedBucketGraphPie(Date date, BucketDataCollectionTotalled bucketsAll, TimeZone timeZone, BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip) {
        this(date, bucketsAll, timeZone, 10, null, option, alwaysAppendSeriesKeyToTooltip);
    }

    public CalculatedBucketGraphPie(Date date, BucketDataCollectionTotalled bucketsAll, TimeZone timeZone, int maxItems, Multimap<String, String> rename, BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip) {
        super(option, alwaysAppendSeriesKeyToTooltip);
        if (date == null) {
            date = new Date(PeriodUnit.DAY.bucketToEndDate(bucketsAll.getLastBucket(), bucketsAll.getTimeZone()));
        }
        this.date = date;
        Object2IntMap<String> pieValues = bucketsAll.getPieValues(date, timeZone);
        this.processData(pieValues, maxItems, rename);
    }

    private void processData(Object2IntMap<String> pieValues, int maxItems, Multimap<String, String> rename) {
        for (Object2IntMap.Entry entry : pieValues.object2IntEntrySet()) {
            this.insertValue((String)entry.getKey(), entry.getIntValue());
        }
        this.reducePieData(maxItems, rename);
    }

    public DefaultPieDataset getPieData() {
        return this.pieData;
    }

    private void reducePieData(int maxItems, Multimap<String, String> rename) {
        int i2;
        this.applyRename(rename);
        double total = 0.0;
        for (int i3 = 0; i3 < this.pieData.getItemCount(); ++i3) {
            total += this.pieData.getValue(i3).doubleValue();
        }
        int numNotOther = this.pieData.getItemCount() == maxItems ? maxItems : Math.min(maxItems - 1, this.pieData.getItemCount());
        this.pieData.sortByKeys(SortOrder.ASCENDING);
        this.pieData.sortByValues(SortOrder.DESCENDING);
        double other = 0.0;
        for (i2 = 0; i2 < numNotOther && !(this.pieData.getValue(i2).doubleValue() / total < 0.03); ++i2) {
        }
        while (this.pieData.getItemCount() > i2) {
            other += (double)this.pieData.getValue(i2).intValue();
            this.pieData.remove(this.pieData.getKey(i2));
        }
        if (other > 0.0) {
            this.pieData.insertValue(this.pieData.getItemCount(), (Comparable)((Object)"Other"), other);
        }
    }

    private void applyRename(Multimap<String, String> rename) {
        if (rename != null) {
            for (Map.Entry e2 : rename.asMap().entrySet()) {
                int total = 0;
                for (String item : (Collection)e2.getValue()) {
                    if (!this.pieData.getKeys().contains(item)) continue;
                    total += this.pieData.getValue((Comparable)((Object)item)).intValue();
                    this.pieData.remove((Comparable)((Object)item));
                }
                this.pieData.insertValue(0, (Comparable)e2.getKey(), (double)total);
            }
        }
    }

    @Override
    public boolean noGraphData() {
        return this.pieData == null || this.pieData.getItemCount() == 0;
    }

    public Date getDate() {
        return this.date;
    }

    void insertValue(String key, int linecountAtDate) {
        if (this.pieData == null) {
            this.pieData = new DefaultPieDataset();
        }
        if (!key.equals("__ALL_AUTHORS__") && !key.equals("__ALL_EXTENSIONS__")) {
            key = this.formatLabel(key);
            this.pieData.insertValue(0, (Comparable)((Object)key), (double)linecountAtDate);
        }
    }
}

