/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;

public abstract class CalculatedBucketGraph {
    protected SimpleDateFormat tooltipDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private ChartRenderingInfo chartRenderingInfo;
    private static final Map<String, String> labelMap = new HashMap<String, String>();
    private final BreakdownOption option;
    private final boolean alwaysAppendSeriesKeyToTooltip;

    protected CalculatedBucketGraph(BreakdownOption option, boolean alwaysAppendSeriesKeyToTooltip) {
        this.option = option;
        this.alwaysAppendSeriesKeyToTooltip = alwaysAppendSeriesKeyToTooltip;
    }

    public String getRevcountTooltip(Period period, int value, String key) {
        String date = period.getStringTT(this.tooltipDateFormat);
        String valueString = LargeNumberFormatter.formatNumber(value);
        return this.option.getRevCountToolTip(key, valueString, date, period.getPeriodUnit() == PeriodUnit.DAY, this.alwaysAppendSeriesKeyToTooltip);
    }

    public String getLinecountTooltip(Period period, int value, String description, String key) {
        String date = this.tooltipDateFormat.format(period.getEndDate());
        String valueString = LargeNumberFormatter.formatNumber(value);
        return this.option.getLineCountTooltip(valueString, date, key, description, this.alwaysAppendSeriesKeyToTooltip);
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.chartRenderingInfo;
    }

    public void setChartRenderingInfo(ChartRenderingInfo chartRenderingInfo) {
        this.chartRenderingInfo = chartRenderingInfo;
    }

    public abstract boolean noGraphData();

    protected String formatLabel(String label) {
        return labelMap.containsKey(label) ? labelMap.get(label) : label;
    }

    static {
        labelMap.put("__NO_EXTENSION__", "None");
        labelMap.put("__NO_AUTHOR__", "No author");
    }
}

