/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionDiffs;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataDiffs;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphPie;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.atlassian.fisheye.bucket.Dir;
import com.atlassian.fisheye.bucket.InfinityDBConnector;
import com.atlassian.fisheye.bucket.InsertIterator;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.SumCollector;
import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.HgSubBranch;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.vis.ChartDimension;
import com.cenqua.fisheye.vis.ChartLocation;
import com.cenqua.fisheye.vis.LocChartParams;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;

public class BucketGraph {
    private final InfinityDBConnector con;
    public static final PeriodUnit PERIOD_SLURP = PeriodUnit.DAY;
    private final String repname;
    private static final LoadingCache<CacheKey, BucketDataCollectionTotalled> bucketCache = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<CacheKey, BucketDataCollectionTotalled>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BucketDataCollectionTotalled load(CacheKey key) throws Exception {
            BucketDataCollectionDiffs diffResult = new SumCollector().getBuckets(new Dir(key.getParams().getPath(), key.getInfdb()), key.getParams());
            if (key.getParams().isNoBreakdown()) {
                diffResult.renameKey(key.getParams().getFormattedLabel());
            }
            try {
                BucketDataCollectionTotalled bucketDataCollectionTotalled = BucketGraph.tallyLoc(key.getRevCache(), diffResult);
                return bucketDataCollectionTotalled;
            }
            finally {
                key.clearRefs();
            }
        }
    });
    private final RevisionCache revisionCache;
    private final InfinityDbHandle dbh;

    public BucketGraph(InfinityDbHandle dbh, String repname, boolean caseSensitive, CommonStringTables commonStringTables, RevisionCache revisionCache) {
        this.dbh = dbh;
        this.con = new InfinityDBConnector(dbh, repname, caseSensitive, commonStringTables);
        this.repname = repname;
        this.revisionCache = revisionCache;
    }

    public void addRevision(ParameterSetInsertion data) throws DbException {
        bucketCache.invalidateAll();
        new InsertIterator().insert(new Dir(Path.ROOT, this.con), data, -1);
    }

    public void addRevision(Path path, String branch, Date date, int linecountChange, int numRevisions, String commitAuthor, boolean isTrunklike, long subBranchId) throws DbException {
        int bucket = new Period(date, this.getTimeZone()).getBucket();
        this.addRevision(new ParameterSetInsertion(path, branch, bucket, linecountChange, numRevisions, commitAuthor, isTrunklike, subBranchId));
    }

    public void addRevision(Path path, String branch, Date date, int linecountChange, String commitAuthor, boolean isTrunklike, long subBranchId) throws DbException {
        this.addRevision(path, branch, date, linecountChange, 1, commitAuthor, isTrunklike, subBranchId);
    }

    public void addRevision(Path path, String branch, Date date, SumMap<String> linecountByAuthor, String commitAuthor, boolean isTrunklike, int revcount, long subBranchId) throws DbException {
        int bucket = new Period(date, this.getTimeZone()).getBucket();
        this.addRevision(new ParameterSetInsertion(path, branch, bucket, linecountByAuthor, commitAuthor, revcount, isTrunklike, subBranchId));
    }

    void addRevision(Path path, String branch, int bucket, SumMap<String> linecountByAuthor, String commitAuthor, boolean isTrunklike, long subBranchId) throws DbException {
        this.addRevision(new ParameterSetInsertion(path, branch, bucket, linecountByAuthor, commitAuthor, 1, isTrunklike, subBranchId));
    }

    public CalculatedBucketGraphPie getPieData(ParameterSetQuery params, Date date2, int maxItems, Multimap<String, String> rename) throws DbException {
        BucketDataCollectionTotalled bucketsAll = this.getBuckets(params);
        return new CalculatedBucketGraphPie(date2, bucketsAll, this.getTimeZone(), maxItems, rename, params.getBreakdown(), false);
    }

    public CalculatedBucketGraphXY getXYSeries(ParameterSetQuery params) throws DbException {
        return this.getXYSeries(params, null, null, ChartLocation.SIDEBAR.getParams(), 1, false, null);
    }

    public CalculatedBucketGraphXY getXYSeries(ParameterSetQuery params, PeriodUnit periodGraph) throws DbException {
        BucketDataCollectionTotalled bucketsAll = this.getBuckets(params);
        BucketDataTotalled buckets = (BucketDataTotalled)bucketsAll.getFirst();
        if (buckets.size() == 0) {
            return new CalculatedBucketGraphXY(params.getBreakdown(), false);
        }
        Date dateEnd = new Date(PeriodUnit.DAY.bucketToEndDate(buckets.getLastBucket(), this.getTimeZone()));
        LocChartParams locParams = new LocChartParams(new ChartDimension(Integer.MAX_VALUE, Integer.MAX_VALUE), 1);
        return new CalculatedBucketGraphXY(bucketsAll, params.isTrunkLike(), null, dateEnd, this.repname, locParams, 1, false, null, params.getBreakdown(), false, false);
    }

    public CalculatedBucketGraphXY getXYSeries(ParameterSetQuery params, Date date1, Date date2, LocChartParams locParams, int maxItems, boolean isChange, Multimap<String, String> rename) throws DbException {
        BucketDataCollectionTotalled bucketsAll = this.getBuckets(params);
        if (bucketsAll.collectionCount() <= 0) {
            return new CalculatedBucketGraphXY(params.getBreakdown(), false);
        }
        return new CalculatedBucketGraphXY(bucketsAll, params.isTrunkLike(), date1, date2, this.repname, locParams, maxItems, isChange, rename, params.getBreakdown(), false, false);
    }

    public BucketDataCollectionTotalled getBuckets(ParameterSetQuery params) throws DbException {
        BucketDataCollectionTotalled result;
        if (this.isLocDisabled()) {
            return new BucketDataCollectionTotalled(PeriodUnit.DAY, this.getTimeZone());
        }
        try {
            result = (BucketDataCollectionTotalled)bucketCache.get((Object)new CacheKey(this.repname, params, this.con, this.revisionCache));
        }
        catch (ExecutionException e2) {
            Logs.APP_LOG.debug((Object)("Error encountered while getting buckets for " + params));
            result = new BucketDataCollectionTotalled(PeriodUnit.DAY, this.getTimeZone());
        }
        return result.copy();
    }

    private boolean isLocDisabled() {
        return this.revisionCache != null && !this.revisionCache.isLocEnabled();
    }

    private static BucketDataCollectionTotalled tallyLoc(RevisionCache revisionCache, BucketDataCollectionDiffs locChange) throws DbException {
        BucketDataCollectionTotalled locTotals = new BucketDataCollectionTotalled(locChange.getPeriodUnit(), locChange.getTimeZone());
        HashMap<String, HgChangeSet> changesets = new HashMap<String, HgChangeSet>();
        if (revisionCache != null && revisionCache.getRepositoryType() == ScmType.HG) {
            HgCache hgCache = (HgCache)revisionCache;
            for (Map.Entry e1 : locChange.entrySet()) {
                String label = (String)e1.getKey();
                BucketDataDiffs bucketData = (BucketDataDiffs)e1.getValue();
                BucketDataTotalled newBucketData = new BucketDataTotalled(label);
                locTotals.add(newBucketData);
                LongAVLTreeSet pendingSubBranches = new LongAVLTreeSet(bucketData.getSubBranches());
                LongOpenHashSet processedSubBranches = new LongOpenHashSet();
                while (!pendingSubBranches.isEmpty()) {
                    HgChangeSet csLastSubBranchCommit;
                    int lastSubBranchBucket;
                    long subBranchId = pendingSubBranches.firstLong();
                    HgSubBranch subBranch = hgCache.getSubBranch(subBranchId);
                    BucketData.SubBranchInfo subBranchInfo = BucketGraph.initSubBranchInfo(hgCache, subBranchId, subBranch, changesets);
                    int totalLoc = 0;
                    int totalRevs = 0;
                    int branchStartBucket = PeriodUnit.DAY.dateToBucket(subBranchInfo.getCsBranchStartDate(), locTotals.getTimeZone());
                    if (subBranch.getParentCommit() != null) {
                        int parentBranchPoint = PeriodUnit.DAY.dateToBucket(subBranchInfo.getCsBranchParentDate(), locTotals.getTimeZone()) - 1;
                        String parentSubBranch = subBranchInfo.getCsBranchParentSubBranch();
                        long parentSubBranchId = ((CommonStringTables)((HgCache)revisionCache).getStringTables()).changeSetIdDB.find(parentSubBranch);
                        if (newBucketData.hasSubBranch(parentSubBranchId)) {
                            totalLoc = newBucketData.getCumulativeLocAtBucket(parentSubBranchId, parentBranchPoint);
                        }
                        newBucketData.add(subBranchId, parentBranchPoint, totalLoc, totalRevs, totalLoc, totalRevs);
                    }
                    Int2ObjectSortedMap subBranchLocChange = bucketData.getData(subBranchId);
                    newBucketData.addSubBranchInfo(subBranchId, subBranchInfo);
                    if (totalLoc > 0 && !bucketData.hasBucketData(subBranchId, branchStartBucket)) {
                        newBucketData.add(subBranchId, branchStartBucket, totalLoc, totalRevs, totalLoc, totalRevs);
                    }
                    if (subBranchLocChange != null) {
                        for (Int2ObjectMap.Entry e3 : subBranchLocChange.int2ObjectEntrySet()) {
                            int bucket = e3.getIntKey();
                            BucketDataElement bucketDataElement = (BucketDataElement)e3.getValue();
                            newBucketData.add(subBranchId, bucket, bucketDataElement.getLinecountChange(), bucketDataElement.getRevcount(), totalLoc += bucketDataElement.getLinecountChange(), totalRevs += bucketDataElement.getRevcount());
                        }
                    }
                    if (totalLoc > 0 && !newBucketData.hasBucketData(subBranchId, lastSubBranchBucket = PeriodUnit.DAY.dateToBucket((csLastSubBranchCommit = (HgChangeSet)revisionCache.getChangeSet(subBranch.getLastCommitOnBranch())).getDate(), locTotals.getTimeZone()))) {
                        newBucketData.add(subBranchId, lastSubBranchBucket, 0, 0, totalLoc, totalRevs);
                    }
                    LongIterator longIterator = subBranch.getChildSubBranchIds().iterator();
                    while (longIterator.hasNext()) {
                        long childSubBranch = (Long)longIterator.next();
                        if (processedSubBranches.contains(childSubBranch) || pendingSubBranches.contains(childSubBranch)) continue;
                        pendingSubBranches.add(childSubBranch);
                    }
                    pendingSubBranches.remove(subBranchId);
                    processedSubBranches.add(subBranchId);
                }
            }
        } else {
            for (Map.Entry e1 : locChange.entrySet()) {
                String label = (String)e1.getKey();
                BucketDataDiffs bucketData = (BucketDataDiffs)e1.getValue();
                BucketDataTotalled newBucketData = new BucketDataTotalled(label);
                locTotals.add(newBucketData);
                for (Long2ObjectMap.Entry e2 : bucketData.entrySet()) {
                    long subBranch = e2.getLongKey();
                    int totalLoc = 0;
                    int totalRevs = 0;
                    for (Int2ObjectMap.Entry e3 : ((Int2ObjectSortedMap)e2.getValue()).int2ObjectEntrySet()) {
                        int bucket = e3.getIntKey();
                        BucketDataElement bucketDataElement = (BucketDataElement)e3.getValue();
                        newBucketData.add(subBranch, bucket, bucketDataElement.getLinecountChange(), bucketDataElement.getRevcount(), totalLoc += bucketDataElement.getLinecountChange(), totalRevs += bucketDataElement.getRevcount());
                    }
                }
            }
        }
        return locTotals;
    }

    private static BucketData.SubBranchInfo initSubBranchInfo(HgCache hgRevCache, long subBranchId, HgSubBranch subBranch, Map<String, HgChangeSet> changesets) throws DbException {
        return new BucketData.SubBranchInfo(subBranchId, subBranch, BucketGraph.getChangeSet(hgRevCache, subBranch.getId(), changesets), BucketGraph.getChangeSet(hgRevCache, subBranch.getParentCommit(), changesets), BucketGraph.getChangeSet(hgRevCache, subBranch.getEndingMergeCommit(), changesets), BucketGraph.getChangeSet(hgRevCache, subBranch.getLastCommitOnBranch(), changesets));
    }

    private static HgChangeSet getChangeSet(HgCache hgRevCache, String cs, Map<String, HgChangeSet> changesets) throws DbException {
        if (changesets.containsKey(cs)) {
            return changesets.get(cs);
        }
        HgChangeSet hgCs = (HgChangeSet)hgRevCache.getChangeSet(cs);
        changesets.put(cs, hgCs);
        return hgCs;
    }

    public List<String> getAvailableExtensions(Path path) throws DbException {
        List<String> extns = this.con.getAvailableExtns(path);
        extns.remove("__NO_EXTENSION__");
        return extns;
    }

    public String toString() {
        return "Rep + " + this.repname;
    }

    public String toStringFull() throws DbException {
        return new Dir(Path.ROOT, this.con).toStringFull();
    }

    public void reindex(BlameAndLinecountCalculator blameAndLinecountCalculator, RepositoryStatus status) throws DbException {
        bucketCache.invalidateAll();
        Timer timer = new Timer("LOCSCAN");
        Logs.APP_LOG.debug((Object)"LOCSCAN: Beginning loc rescan");
        status.setMessage("Pre-calculating line count data: deleting old data");
        this.con.deleteAllData();
        this.con.saveTimeZone(AppConfig.getsConfig().getTimezone());
        this.con.setVersionToCurrent();
        try {
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        status.setMessage("Pre-calculating line count data: starting scan");
        timer.mark("Starting scan");
        blameAndLinecountCalculator.calcBlame(true);
        timer.end();
        status.setMessage("");
    }

    InfinityDBConnector getConnector() {
        return this.con;
    }

    public boolean isAtCurrentVersion() throws DbException {
        return this.con.isAtCurrentVersion();
    }

    public String loadTimeZone() throws DbException {
        return this.con.loadTimeZone();
    }

    public boolean isRevIdIndexed(int revid) throws DbException {
        return this.con.isRevIdIndexed(revid);
    }

    public void setRevIdIndexed(int revid) throws DbException {
        this.con.setRevIdIndexed(revid);
    }

    public int getLastRevIdIndexed() throws DbException {
        return this.con.loadLastRevIdIndexed();
    }

    public TimeZone getTimeZone() throws DbException {
        return TimeZone.getTimeZone(this.con.loadTimeZone());
    }

    public int getLastChangesetIdIndexed() throws DbException {
        return this.con.loadLastChangesetIdIndexed();
    }

    public void setLastChangesetIdIndexed(long id) throws DbException {
        this.con.setChangesetIdIndexed(id);
    }

    public static class InvalidBucketException
    extends Exception {
        public InvalidBucketException(String message) {
            super(message);
        }
    }

    private static class CacheKey {
        private final String repository;
        private final ParameterSetQuery params;
        private InfinityDBConnector infdb;
        private RevisionCache revCache;

        CacheKey(String repository, ParameterSetQuery params, InfinityDBConnector infdb, RevisionCache revCache) {
            this.repository = repository;
            this.params = ParameterSetQuery.immutableCopyOf(params);
            this.infdb = infdb;
            this.revCache = revCache;
        }

        String getRepository() {
            return this.repository;
        }

        ParameterSetQuery getParams() {
            return this.params;
        }

        InfinityDBConnector getInfdb() {
            return this.infdb;
        }

        RevisionCache getRevCache() {
            return this.revCache;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            return this.params.equals(cacheKey.params) && this.repository.equals(cacheKey.repository);
        }

        public int hashCode() {
            int result = this.repository.hashCode();
            result = 31 * result + this.params.hashCode();
            return result;
        }

        public void clearRefs() {
            this.revCache = null;
            this.infdb = null;
        }
    }
}

