/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataElementTotalled;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.IntPair;
import com.cenqua.fisheye.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;

public class BucketDataTotalled
extends BucketData<BucketDataElementTotalled> {
    public BucketDataTotalled(String label) {
        super(label);
    }

    public BucketDataTotalled(String label, int bucket, int linecount, int revcount, int linecountTotal, int revcountTotal) {
        super(label);
        this.add(0L, bucket, linecount, revcount, linecountTotal, revcountTotal);
    }

    public int getCumulativeLocAtBucket(long parentSubBranchId, int bucket) {
        Pair element = this.getClosestBucket(parentSubBranchId, bucket);
        if (element == null) {
            return 0;
        }
        return ((BucketDataElementTotalled)element.getSecond()).getTotalLinecount();
    }

    public void adjustEnd(long subBranchId, int bucket, int linecount) {
        if (this.data == null || !this.data.containsKey(subBranchId)) {
            return;
        }
        Int2ObjectSortedMap subBranchData = (Int2ObjectSortedMap)this.data.get(subBranchId);
        int lastBucket = subBranchData.lastIntKey();
        if (bucket < lastBucket) {
            Logs.APP_LOG.debug((Object)("Error in start adjustment: expected bucket < lastBucket, but bucket=" + bucket + ", lastBucket=" + lastBucket));
            return;
        }
        BucketDataElementTotalled dataElement = (BucketDataElementTotalled)this.getBucketData(subBranchId, bucket);
        if (dataElement == null) {
            Pair closestBucket = this.getClosestBucket(subBranchId, bucket);
            BucketDataElementTotalled prevBde = closestBucket == null ? new BucketDataElementTotalled(0, 0, 0, 0) : (BucketDataElementTotalled)closestBucket.getSecond();
            dataElement = new BucketDataElementTotalled(prevBde.getTotalLinecount() - linecount, 0, linecount, prevBde.getTotalRevcount());
            subBranchData.put(bucket, (Object)dataElement);
        } else {
            int locChange = linecount - dataElement.getTotalLinecount();
            dataElement.add(locChange, 0);
        }
    }

    public void adjustStart(long subBranchId, int bucket, int linecount) {
        if (this.data == null || !this.data.containsKey(subBranchId)) {
            return;
        }
        Int2ObjectSortedMap subBranchData = (Int2ObjectSortedMap)this.data.get(subBranchId);
        int firstBucket = subBranchData.firstIntKey();
        if (bucket >= firstBucket) {
            Logs.APP_LOG.debug((Object)("Error in start adjustment: expected bucket >= firstBucket, but bucket=" + bucket + ", firstBucket=" + firstBucket));
            return;
        }
        BucketDataElementTotalled dataElement = new BucketDataElementTotalled(linecount, 0, linecount, 0);
        subBranchData.put(bucket, (Object)dataElement);
        BucketDataElementTotalled next = (BucketDataElementTotalled)this.getBucketData(subBranchId, firstBucket);
        next.setLinecountChange(next.getLinecountChange() - linecount);
    }

    public void add(long subBranch, int bucket, int linecount, int revcount, int linecountTotal, int revcountTotal) throws NullPointerException {
        BucketDataElementTotalled dataElement = (BucketDataElementTotalled)this.getBucketData(subBranch, bucket);
        if (dataElement == null) {
            dataElement = new BucketDataElementTotalled(linecount, revcount, linecountTotal, revcountTotal);
        } else {
            dataElement.add(linecount, revcount);
        }
        ((Int2ObjectSortedMap)this.data.get(subBranch)).put(bucket, (Object)dataElement);
    }

    @Override
    public void add(long subBranch, int bucket, BucketDataElementTotalled value) {
        this.add(subBranch, bucket, value.getLinecountChange(), value.getRevcount(), value.getTotalLinecount(), value.getTotalRevcount());
    }

    @Override
    protected BucketData<BucketDataElementTotalled> getNewBucketData(String label) {
        return new BucketDataTotalled(label);
    }

    public int getCumulativeLocAtBucket(int bucket) {
        return this.getCumulativeLocAtBucket(this.data.firstLongKey(), bucket);
    }

    public int getCumulativeRevsAtBucket(long subBranchId, int bucket) {
        Pair bde = this.getClosestBucket(subBranchId, bucket);
        if (bde == null) {
            return 0;
        }
        return ((BucketDataElementTotalled)bde.getSecond()).getTotalRevcount();
    }

    public BucketDataTotalled copy() {
        BucketDataTotalled copy = new BucketDataTotalled(this.label);
        for (Long2ObjectMap.Entry subBranch : this.data.long2ObjectEntrySet()) {
            for (Int2ObjectMap.Entry element : ((Int2ObjectSortedMap)subBranch.getValue()).int2ObjectEntrySet()) {
                copy.add(subBranch.getLongKey(), element.getIntKey(), (BucketDataElementTotalled)element.getValue());
            }
        }
        copy.subBranchInfoCollection = this.subBranchInfoCollection;
        return copy;
    }

    public int getTotalLoc() {
        int latestBucket = Integer.MIN_VALUE;
        int loc = 0;
        for (Int2ObjectSortedMap e2 : this.data.values()) {
            int subBranchLatestBucket = e2.lastIntKey();
            BucketDataElementTotalled lastBDE = (BucketDataElementTotalled)e2.get(subBranchLatestBucket);
            int subBranchLoc = lastBDE.getTotalLinecount();
            if (subBranchLatestBucket <= latestBucket && (subBranchLatestBucket != latestBucket || subBranchLoc <= loc)) continue;
            latestBucket = subBranchLatestBucket;
            loc = subBranchLoc;
        }
        return loc;
    }

    public Long2ObjectSortedMap<IntPair> getLocTotalsAtBucket(int targetBucket) {
        Long2ObjectAVLTreeMap result = new Long2ObjectAVLTreeMap();
        for (Long2ObjectMap.Entry e2 : this.data.long2ObjectEntrySet()) {
            long subBranch = e2.getLongKey();
            Pair subData = this.getClosestBucket(subBranch, targetBucket);
            if (subData == null) continue;
            result.put(subBranch, (Object)new IntPair(subData.getFirst(), ((BucketDataElementTotalled)subData.getSecond()).getTotalLinecount()));
        }
        return result;
    }

    public void addSubBranchInfo(long subBranchId, BucketData.SubBranchInfo subBranchInfo) {
        this.subBranchInfoCollection.put(subBranchId, (Object)subBranchInfo);
    }

    @Override
    public void addAllValues(BucketData<BucketDataElementTotalled> newData) {
        if (newData != null && !newData.data.isEmpty()) {
            Long2ObjectSortedMap<Int2ObjectSortedMap<BucketDataElementTotalled>> newDataCollection = BucketDataTotalled.combineData(newData, this);
            this.data.clear();
            this.data.putAll(newDataCollection);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static Long2ObjectSortedMap<Int2ObjectSortedMap<BucketDataElementTotalled>> combineData(BucketData<BucketDataElementTotalled> ... data) {
        if (data.length == 0) {
            return new Long2ObjectAVLTreeMap();
        }
        if (data.length == 1) {
            return data[0].data;
        }
        LongOpenHashSet subBranches = new LongOpenHashSet();
        for (BucketData<BucketDataElementTotalled> d2 : data) {
            subBranches.addAll((LongCollection)d2.getSubBranches());
        }
        Long2ObjectAVLTreeMap combinedData = new Long2ObjectAVLTreeMap();
        LongIterator longIterator = subBranches.iterator();
        while (longIterator.hasNext()) {
            long subBranch = (Long)longIterator.next();
            Int2ObjectAVLTreeMap subBranchData = new Int2ObjectAVLTreeMap();
            combinedData.put(subBranch, (Object)subBranchData);
            ArrayList queues = new ArrayList();
            for (BucketData<BucketDataElementTotalled> aData : data) {
                Int2ObjectSortedMap<BucketDataElementTotalled> d3 = aData.getData(subBranch);
                if (d3 == null || d3.isEmpty()) continue;
                LinkedList linkedList = new LinkedList(d3.int2ObjectEntrySet());
                queues.add(linkedList);
            }
            int totalLoc = 0;
            int totalRevs = 0;
            HashSet<Queue> emptyQueues = new HashSet<Queue>();
            while (!queues.isEmpty()) {
                void var13_23;
                emptyQueues.clear();
                int nextBucket = Integer.MAX_VALUE;
                for (Queue queue : queues) {
                    nextBucket = Math.min(nextBucket, ((Int2ObjectMap.Entry)queue.peek()).getIntKey());
                }
                int locChange = 0;
                boolean bl = false;
                for (Queue queue : queues) {
                    if (((Int2ObjectMap.Entry)queue.peek()).getIntKey() != nextBucket) continue;
                    BucketDataElementTotalled e2 = (BucketDataElementTotalled)((Int2ObjectMap.Entry)queue.remove()).getValue();
                    if (queue.isEmpty()) {
                        emptyQueues.add(queue);
                    }
                    totalLoc += e2.getLinecountChange();
                    totalRevs += e2.getRevcount();
                    locChange += e2.getLinecountChange();
                    var13_23 += e2.getRevcount();
                }
                queues.removeAll(emptyQueues);
                subBranchData.put(nextBucket, (Object)new BucketDataElementTotalled(locChange, (int)var13_23, totalLoc, totalRevs));
            }
        }
        return combinedData;
    }
}

