/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElementTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.rep.DbException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;

public class BucketDataExporter {
    public static void writeRawDataJson(Writer writer, ParameterSetQuery dataParams, BucketGraph bucketGraph) throws DbException, BucketGraph.InvalidBucketException, JSONException, IOException {
        BucketDataCollectionTotalled data = bucketGraph.getBuckets(dataParams);
        TimeZone tz = bucketGraph.getTimeZone();
        BucketDataExporter.writeRawDataJson(writer, data, tz);
    }

    static void writeRawDataJson(Writer writer, BucketDataCollectionTotalled data, TimeZone tz) throws JSONException, BucketGraph.InvalidBucketException, DbException, IOException {
        JSONWriter jWriter = new JSONWriter(writer);
        jWriter.array();
        for (Map.Entry series : data.entrySet()) {
            jWriter.object();
            jWriter.key((String)series.getKey());
            jWriter.array();
            for (Long2ObjectMap.Entry e2 : ((BucketDataTotalled)series.getValue()).entrySet()) {
                String subBranch = String.valueOf(e2.getLongKey());
                Int2ObjectSortedMap subBranchData = (Int2ObjectSortedMap)e2.getValue();
                jWriter.object();
                jWriter.key(subBranch);
                jWriter.array();
                for (Int2ObjectMap.Entry value : subBranchData.int2ObjectEntrySet()) {
                    BucketDataExporter.writeDataElement(tz, jWriter, value.getIntKey(), (BucketDataElementTotalled)value.getValue());
                }
                jWriter.endArray();
                jWriter.endObject();
            }
            jWriter.endArray();
            jWriter.endObject();
        }
        jWriter.endArray();
        writer.close();
    }

    private static void writeDataElement(TimeZone tz, JSONWriter jWriter, int bucket, BucketDataElementTotalled dataElement) throws BucketGraph.InvalidBucketException, DbException, JSONException {
        Period day = new Period(PeriodUnit.DAY, bucket, tz);
        jWriter.object();
        jWriter.key("loc_change");
        jWriter.value((long)dataElement.getLinecountChange());
        jWriter.key("num_revisions");
        jWriter.value((long)dataElement.getRevcount());
        jWriter.key("loc_running_total");
        jWriter.value((long)dataElement.getTotalLinecount());
        jWriter.key("revisions_running_total");
        jWriter.value((long)dataElement.getTotalRevcount());
        jWriter.key("start_time");
        jWriter.value(day.getStartTime());
        jWriter.key("end_time");
        jWriter.value(day.getEndTime());
        jWriter.endObject();
    }

    public static void writeRawDataJson(OutputStreamWriter writer, CalculatedBucketGraphXY graphs) throws JSONException, IOException {
        JSONArray seriesLabels = new JSONArray();
        JSONArray XValuesLoc = new JSONArray();
        JSONArray XValuesRev = new JSONArray();
        JSONArray dataRev1 = new JSONArray();
        JSONArray dataLoc1 = new JSONArray();
        XYSeriesCollection linecountCollection = graphs.getLinecountCollection();
        TimePeriodValuesCollection revcountCollection = graphs.getRevisioncountCollection();
        for (int i2 = 0; i2 < linecountCollection.getSeriesCount(); ++i2) {
            XYSeries linecountSeries = linecountCollection.getSeries(i2);
            TimePeriodValues revcountSeries = revcountCollection.getSeries(i2);
            String key = (String)((Object)linecountCollection.getSeriesKey(i2));
            key = key.replace("[", "");
            key = key.replace("]", "");
            seriesLabels.put((Object)key);
            JSONArray dataLoc2 = new JSONArray();
            for (int j2 = 0; j2 < linecountSeries.getItemCount(); ++j2) {
                XYDataItem linecountItem = linecountSeries.getDataItem(j2);
                if (i2 == 0) {
                    XValuesLoc.put(linecountItem.getX().longValue());
                }
                dataLoc2.put(linecountItem.getY().longValue());
            }
            JSONArray dataRev2 = new JSONArray();
            for (int j3 = 0; j3 < revcountSeries.getItemCount(); ++j3) {
                TimePeriodValue revcountItem = revcountSeries.getDataItem(j3);
                if (i2 == 0) {
                    JSONArray period = new JSONArray();
                    period.put(revcountItem.getPeriod().getStart().getTime());
                    period.put(revcountItem.getPeriod().getEnd().getTime());
                    XValuesRev.put((Object)period);
                }
                dataRev2.put((Object)revcountItem.getValue());
            }
            dataLoc1.put((Object)dataLoc2);
            dataRev1.put((Object)dataRev2);
        }
        JSONWriter jWriter = new JSONWriter((Writer)writer);
        jWriter.object();
        jWriter.key("seriesLabels").value((Object)seriesLabels);
        jWriter.key("XValuesLoc").value((Object)XValuesLoc);
        jWriter.key("YValuesLoc").value((Object)dataLoc1);
        jWriter.key("XValuesRev").value((Object)XValuesRev);
        jWriter.key("YValuesRev").value((Object)dataRev1);
        if (graphs.getRepositories().size() > 0) {
            JSONArray array = new JSONArray();
            for (String rep : graphs.getRepositories()) {
                array.put((Object)rep);
            }
            jWriter.key("reps").value((Object)array);
        }
        jWriter.endObject();
        writer.append("\n");
        writer.close();
    }
}

