/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;

public class BucketDataDiffs
extends BucketData<BucketDataElement> {
    public BucketDataDiffs(String label) {
        super(label);
    }

    public BucketDataDiffs(String label, int bucket, int linecount, int revcount) {
        super(label);
        this.add(0L, bucket, linecount, revcount);
    }

    public void add(long subBranch, int bucket, int linecount, int revcount) throws NullPointerException {
        Object dataElement = this.getBucketData(subBranch, bucket);
        if (dataElement == null) {
            dataElement = new BucketDataElement(linecount, revcount);
        } else {
            ((BucketDataElement)dataElement).add(linecount, revcount);
        }
        ((Int2ObjectSortedMap)this.data.get(subBranch)).put(bucket, dataElement);
    }

    @Override
    public void add(long subBranch, int bucket, BucketDataElement value) {
        this.add(subBranch, bucket, value.getLinecountChange(), value.getRevcount());
    }

    @Override
    protected BucketData<BucketDataElement> getNewBucketData(String label) {
        return new BucketDataDiffs(label);
    }

    @Override
    public void addAllValues(BucketData<BucketDataElement> newData) {
        if (newData != null) {
            newData.addAllValuesInverse(this);
        }
    }
}

