/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketDataCollection;
import com.atlassian.fisheye.bucket.BucketDataElementTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.util.IntPair;
import com.cenqua.fisheye.util.SumMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Date;
import java.util.TimeZone;

public class BucketDataCollectionTotalled
extends BucketDataCollection<BucketDataTotalled, BucketDataElementTotalled> {
    public BucketDataCollectionTotalled(PeriodUnit periodUnit, TimeZone timeZone) {
        super(periodUnit, timeZone);
    }

    @Override
    protected BucketDataTotalled getNewBucketData(String label) {
        return new BucketDataTotalled(label);
    }

    protected BucketDataCollectionTotalled getNewBucketDataCollection(PeriodUnit periodUnit, TimeZone timeZone) {
        return new BucketDataCollectionTotalled(periodUnit, timeZone);
    }

    public void add(String key, int bucket, int linecount, int revcount, long subBranch) {
        this.add(key, bucket, linecount, revcount, 0, 0, subBranch);
    }

    public void add(String key, int bucket, int linecount, int revcount, int totalLinecount, int totalRevcount, long subBranch) {
        if (!this.data.containsKey((Object)key)) {
            this.data.put((Object)key, (Object)new BucketDataTotalled(key));
        }
        ((BucketDataTotalled)this.data.get((Object)key)).add(subBranch, bucket, linecount, revcount, totalLinecount, totalRevcount);
    }

    public Object2IntMap<String> getPieValues(Date date, TimeZone timeZone) {
        long subBranch;
        Object2IntAVLTreeMap pieValues = new Object2IntAVLTreeMap();
        int targetBucket = BucketGraph.PERIOD_SLURP.dateToBucket(date.getTime(), timeZone);
        SumMap<Long> locTotals = new SumMap<Long>((Object2IntMap<Long>)new Object2IntOpenHashMap());
        int latestBucket = 0;
        LongAVLTreeSet subBranchesWithLatestActivity = new LongAVLTreeSet();
        for (BucketDataTotalled item : this.data.values()) {
            for (LongBidirectionalIterator e2 : item.getLocTotalsAtBucket(targetBucket).long2ObjectEntrySet()) {
                subBranch = e2.getLongKey();
                int bucket = ((IntPair)e2.getValue()).getFirst();
                int loc = ((IntPair)e2.getValue()).getSecond();
                locTotals.addValue(subBranch, loc);
                if (bucket > latestBucket) {
                    subBranchesWithLatestActivity.clear();
                    subBranchesWithLatestActivity.add(subBranch);
                    continue;
                }
                if (bucket != latestBucket) continue;
                subBranchesWithLatestActivity.add(subBranch);
            }
        }
        long chosenSubBranch = 0L;
        if (subBranchesWithLatestActivity.size() == 1) {
            chosenSubBranch = subBranchesWithLatestActivity.firstLong();
        } else {
            LongBidirectionalIterator e2;
            int largestLoc = 0;
            e2 = subBranchesWithLatestActivity.iterator();
            while (e2.hasNext()) {
                subBranch = (Long)e2.next();
                int subBranchLoc = locTotals.getInt(subBranch);
                if (subBranchLoc <= largestLoc) continue;
                largestLoc = subBranchLoc;
                chosenSubBranch = subBranch;
            }
        }
        for (BucketDataTotalled item : this.data.values()) {
            pieValues.put((Object)item.getLabel(), item.getCumulativeLocAtBucket(chosenSubBranch, targetBucket));
        }
        return pieValues;
    }

    public BucketDataCollectionTotalled copy() {
        BucketDataCollectionTotalled copy = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        for (BucketDataTotalled entry : this.data.values()) {
            copy.add(entry.copy());
        }
        return copy;
    }
}

