/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.SortValue;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public abstract class BucketDataCollection<D extends BucketData<E>, E extends BucketDataElement> {
    final PeriodUnit periodUnit;
    final TimeZone timeZone;
    protected final Object2ObjectLinkedOpenHashMap<String, D> data = new Object2ObjectLinkedOpenHashMap();

    public BucketDataCollection(PeriodUnit periodUnit, TimeZone timeZone) {
        this.periodUnit = periodUnit;
        this.timeZone = timeZone;
    }

    public void add(D value) {
        D bucketData = this.get(((BucketData)value).getLabel());
        if (bucketData == null) {
            this.data.put((Object)((BucketData)value).getLabel(), value);
        } else {
            ((BucketData)bucketData).addAllValues(value);
            this.data.put((Object)((BucketData)value).getLabel(), bucketData);
        }
    }

    public void add(BucketDataCollection<D, E> collection) {
        for (BucketData item : collection.data.values()) {
            this.add(item);
        }
    }

    D get(String key) {
        return (D)((BucketData)this.data.get((Object)key));
    }

    public int getFirstBucket() {
        if (this.isEmpty()) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (BucketData bucketData : this.data.values()) {
            if (bucketData.size() <= 0) continue;
            min = Math.min(min, bucketData.getFirstBucket());
        }
        return min;
    }

    public boolean isEmpty() {
        for (BucketData bucketData : this.data.values()) {
            if (bucketData.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public int getLastBucket() {
        if (this.isEmpty()) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (BucketData bucketData : this.data.values()) {
            max = Math.max(max, bucketData.getLastBucket());
        }
        return max;
    }

    public String toString() {
        return this.data.toString().replaceAll("=>", "=");
    }

    public int collectionCount() {
        return this.data.size();
    }

    public List<D> consolidateAndSort(int maxElements, Multimap<String, String> rename) throws DbException {
        this.applyRename(rename);
        if (this.data.size() < 2) {
            return new ArrayList(this.data.values());
        }
        List<SortValue> sortVals = this.getSortValues();
        ArrayList<Object> newData = new ArrayList<Object>();
        int numNotOther = sortVals.size() == maxElements ? maxElements : Math.min(maxElements - 1, sortVals.size());
        Collections.sort(sortVals, SortValue.getSumComparator());
        BucketData otherData = null;
        if (sortVals.size() > maxElements) {
            otherData = (BucketData)this.getNewBucketData("Other");
            for (int i2 = numNotOther; i2 < sortVals.size(); ++i2) {
                String key = sortVals.get((int)i2).key;
                otherData.addAllValues((BucketData)this.data.get((Object)key));
            }
        }
        sortVals = sortVals.subList(0, numNotOther);
        Collections.sort(sortVals, SortValue.getLastValueComparator());
        for (SortValue sortVal : sortVals) {
            String key = sortVal.key;
            newData.add(this.data.get((Object)key));
        }
        if (otherData != null) {
            newData.add(otherData);
        }
        return newData;
    }

    private void applyRename(Multimap<String, String> rename) {
        if (rename != null) {
            for (Map.Entry e2 : rename.asMap().entrySet()) {
                String label = (String)e2.getKey();
                Collection items = (Collection)e2.getValue();
                D d2 = this.getNewBucketData(label);
                for (String s2 : items) {
                    ((BucketData)d2).addAllValues((BucketData)this.data.remove((Object)s2));
                }
                this.data.put((Object)label, d2);
            }
        }
    }

    protected abstract D getNewBucketData(String var1);

    private List<SortValue> getSortValues() {
        ArrayList<SortValue> sortVals = new ArrayList<SortValue>();
        for (Map.Entry element : this.data.entrySet()) {
            SortValue sortValue;
            if (((String)element.getKey()).equals("__ALL_AUTHORS__") || ((String)element.getKey()).equals("__ALL_EXTENSIONS__") || (sortValue = ((BucketData)element.getValue()).getSortValue()) == null) continue;
            sortVals.add(sortValue);
        }
        return sortVals;
    }

    public void renameKey(String newName) {
        if (this.data.keySet().size() == 1) {
            for (String oldKey : this.data.keySet()) {
                BucketData bucketData = (BucketData)this.data.get((Object)oldKey);
                this.data.remove((Object)oldKey);
                bucketData.setLabel(newName);
                this.data.put((Object)newName, (Object)bucketData);
            }
        }
    }

    public D getFirst() {
        if (this.data.size() > 0) {
            return (D)((BucketData)this.data.get(this.data.firstKey()));
        }
        return null;
    }

    public D getLast() {
        if (this.data.size() > 0) {
            return (D)((BucketData)this.data.get(this.data.lastKey()));
        }
        return null;
    }

    protected abstract BucketDataCollection<D, E> getNewBucketDataCollection(PeriodUnit var1, TimeZone var2);

    public D remove(String oldLabel) {
        return (D)((BucketData)this.data.remove((Object)oldLabel));
    }

    public ObjectSortedSet<Map.Entry<String, D>> entrySet() {
        return this.data.entrySet();
    }

    public ObjectSortedSet<String> getKeySet() {
        return this.data.keySet();
    }

    public ArrayList<D> getValueList() {
        ArrayList dataList = new ArrayList(this.data.size());
        for (Map.Entry e2 : this.data.entrySet()) {
            dataList.add(e2.getValue());
        }
        return dataList;
    }

    public boolean hasSubBranches() {
        LongOpenHashSet subBranches = new LongOpenHashSet();
        for (BucketData e2 : this.data.values()) {
            subBranches.addAll((LongCollection)e2.getSubBranches());
        }
        return subBranches.size() == 1 && subBranches.contains(0L);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }
}

