/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.SortValue;
import com.atlassian.fisheye.hg.HgSubBranch;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.cenqua.fisheye.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public abstract class BucketData<E extends BucketDataElement>
implements Comparable<BucketData> {
    String label;
    final Long2ObjectSortedMap<Int2ObjectSortedMap<E>> data = new Long2ObjectAVLTreeMap();
    private String repository;
    private int changeOffset;
    Long2ObjectMap<SubBranchInfo> subBranchInfoCollection = new Long2ObjectOpenHashMap();

    public BucketData(String label) {
        this.label = label;
    }

    public int size() {
        return this.data.size();
    }

    E getBucketData(long subBranch, int bucket) {
        Int2ObjectSortedMap subBranchData = (Int2ObjectSortedMap)this.data.get(subBranch);
        if (subBranchData == null) {
            subBranchData = new Int2ObjectAVLTreeMap();
            this.data.put(subBranch, (Object)subBranchData);
        }
        return (E)((BucketDataElement)subBranchData.get(bucket));
    }

    public String toString() {
        return this.data.toString().replaceAll("=>", "=");
    }

    protected abstract void add(long var1, int var3, E var4);

    public int getFirstBucket() {
        int minValue = Integer.MAX_VALUE;
        for (Int2ObjectSortedMap e2 : this.data.values()) {
            minValue = Math.min(e2.firstIntKey(), minValue);
        }
        return minValue;
    }

    public int getLastBucket() {
        int maxValue = Integer.MIN_VALUE;
        for (Int2ObjectSortedMap e2 : this.data.values()) {
            maxValue = Math.max(e2.lastIntKey(), maxValue);
        }
        return maxValue;
    }

    public SortValue getSortValue() {
        int total = 0;
        int sum = 0;
        LongBidirectionalIterator longBidirectionalIterator = this.data.keySet().iterator();
        while (longBidirectionalIterator.hasNext()) {
            long subBranch = (Long)longBidirectionalIterator.next();
            SortValue value = this.getSortValue(subBranch);
            total += value.lastValue;
            sum += value.sum;
        }
        return new SortValue(this.label, total, sum);
    }

    public SortValue getSortValue(long subBranch) {
        int total = 0;
        int sum = 0;
        boolean hasData = false;
        for (Int2ObjectMap.Entry element : ((Int2ObjectSortedMap)this.data.get(subBranch)).int2ObjectEntrySet()) {
            hasData = true;
            sum += Math.abs(total += ((BucketDataElement)element.getValue()).getLinecountChange());
        }
        if (!hasData) {
            return null;
        }
        return new SortValue(this.label, total, sum);
    }

    public BucketData<E> copy() {
        BucketData<BucketDataElement> copy = this.getNewBucketData(this.label);
        for (Long2ObjectMap.Entry subBranch : this.data.long2ObjectEntrySet()) {
            for (Int2ObjectMap.Entry element : ((Int2ObjectSortedMap)subBranch.getValue()).int2ObjectEntrySet()) {
                copy.add(subBranch.getLongKey(), element.getIntKey(), (BucketDataElement)element.getValue());
            }
        }
        copy.subBranchInfoCollection = this.subBranchInfoCollection;
        return copy;
    }

    protected abstract BucketData<E> getNewBucketData(String var1);

    public List<Pair<Period, E>> getPeriodData(TimeZone timeZone) throws BucketGraph.InvalidBucketException {
        ArrayList<Pair<Period, Pair<Period, Object>>> periods = new ArrayList<Pair<Period, Pair<Period, Object>>>(this.data.size());
        for (Int2ObjectMap.Entry element : this.getFirstSubBranchData().int2ObjectEntrySet()) {
            periods.add(Pair.newInstance(new Period(PeriodUnit.DAY, element.getIntKey(), timeZone), element.getValue()));
        }
        return periods;
    }

    @Override
    public int compareTo(BucketData bucketData) {
        return this.label.compareTo(bucketData.label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ObjectSortedSet<Long2ObjectMap.Entry<Int2ObjectSortedMap<E>>> entrySet() {
        return this.data.long2ObjectEntrySet();
    }

    public ObjectSortedSet<Int2ObjectMap.Entry<E>> entrySet(long subBranch) {
        return ((Int2ObjectSortedMap)this.data.get(subBranch)).int2ObjectEntrySet();
    }

    public Int2ObjectSortedMap<E> getData(long subBranch) {
        return (Int2ObjectSortedMap)this.data.get(subBranch);
    }

    public Int2ObjectSortedMap<E> getData() {
        if (this.data.isEmpty()) {
            return new Int2ObjectAVLTreeMap();
        }
        return this.getData(this.data.firstLongKey());
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public void zeroLinecount() {
        for (Int2ObjectSortedMap e1 : this.data.values()) {
            for (BucketDataElement e2 : e1.values()) {
                e2.add(-e2.getLinecountChange(), 0);
            }
        }
    }

    private Int2ObjectSortedMap<E> getFirstSubBranchData() {
        return (Int2ObjectSortedMap)this.data.get(this.data.firstLongKey());
    }

    public LongSortedSet getSubBranches() {
        return this.data.keySet();
    }

    public boolean hasSubBranch(long subBranchId) {
        return this.data.containsKey(subBranchId);
    }

    public Pair<Integer, E> getClosestBucket(long parentSubBranchId, int bucket) {
        Int2ObjectSortedMap subBranchData = (Int2ObjectSortedMap)this.data.get(parentSubBranchId);
        if (subBranchData == null) {
            return null;
        }
        if (subBranchData.containsKey(bucket)) {
            return Pair.newInstance(bucket, subBranchData.get(bucket));
        }
        if (subBranchData.firstIntKey() > bucket) {
            return null;
        }
        if (subBranchData.lastIntKey() < bucket) {
            return Pair.newInstance(subBranchData.lastIntKey(), subBranchData.get(subBranchData.lastIntKey()));
        }
        IntBidirectionalIterator i2 = subBranchData.keySet().iterator(Integer.MAX_VALUE);
        while (i2.hasPrevious()) {
            int testBucket = i2.previousInt();
            if (testBucket > bucket) continue;
            return Pair.newInstance(testBucket, subBranchData.get(testBucket));
        }
        return null;
    }

    public void setChangeOffset(int changeOffset) {
        this.changeOffset = changeOffset;
    }

    public int getChangeOffset() {
        return this.changeOffset;
    }

    public void addSubBranchInfo(long subBranchId, HgSubBranch subBranch, HgChangeSet csBranchStart, HgChangeSet csBranchParent, HgChangeSet csMergeEnd, HgChangeSet csLastOnBranch) {
        this.subBranchInfoCollection.put(subBranchId, (Object)new SubBranchInfo(subBranchId, subBranch, csBranchStart, csBranchParent, csMergeEnd, csLastOnBranch));
    }

    public Long2ObjectMap<SubBranchInfo> getSubBranchInfoCollection() {
        return this.subBranchInfoCollection;
    }

    public void setSubBranchInfoCollection(Long2ObjectMap<SubBranchInfo> subBranchInfoCollection) {
        this.subBranchInfoCollection = subBranchInfoCollection;
    }

    public boolean hasBucketData(long subBranchId, int lastSubBranchBucket) {
        return this.data.containsKey(subBranchId) && ((Int2ObjectSortedMap)this.data.get(subBranchId)).containsKey(lastSubBranchBucket);
    }

    public abstract void addAllValues(BucketData<E> var1);

    protected void addAllValuesInverse(BucketData<E> oldData) {
        for (Long2ObjectMap.Entry subBranchData : this.data.long2ObjectEntrySet()) {
            for (Int2ObjectMap.Entry element : ((Int2ObjectSortedMap)subBranchData.getValue()).int2ObjectEntrySet()) {
                oldData.add(subBranchData.getLongKey(), element.getIntKey(), (BucketDataElement)element.getValue());
            }
        }
    }

    public static class SubBranchInfo {
        private HgSubBranch subBranch;
        private HgChangeSet csMergeEnd;
        private HgChangeSet csBranchParent;
        private long subBranchId;
        private HgChangeSet csBranchStart;
        private HgChangeSet csLastOnBranch;

        public SubBranchInfo(long subBranchId, HgSubBranch subBranch, HgChangeSet csBranchStart, HgChangeSet csBranchParent, HgChangeSet csMergeEnd, HgChangeSet csLastOnBranch) {
            this.subBranchId = subBranchId;
            this.subBranch = subBranch;
            this.csBranchStart = csBranchStart;
            this.csBranchParent = csBranchParent;
            this.csMergeEnd = csMergeEnd;
            this.csLastOnBranch = csLastOnBranch;
        }

        public long getCsBranchStartDate() {
            return this.csBranchStart.getAdjustedDate();
        }

        public String getCsBranchParentSubBranch() {
            return this.csBranchParent.getSubBranch();
        }

        public boolean hasCsBranchParent() {
            return this.csBranchParent != null;
        }

        public long getSubBranchId() {
            return this.subBranchId;
        }

        public long getCsBranchParentDate() {
            return this.csBranchParent.getAdjustedDate();
        }

        public long getCsBranchParentSubBranchId() {
            return this.csBranchParent.getSubBranchId();
        }

        public boolean hasCsMergeEnd() {
            return this.csMergeEnd != null;
        }

        public long getCsLastOnBranchDate() {
            return this.csLastOnBranch.getAdjustedDate();
        }

        public long getCsMergeEndDate() {
            return this.csMergeEnd.getAdjustedDate();
        }

        public long getCsMergeEndSubBranchId() {
            return this.csMergeEnd.getSubBranchId();
        }
    }
}

