/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum BreakdownOption {
    NONE("None"),
    SUBDIR("Subdirectory"),
    AUTHOR("Author"),
    USER("User"),
    EXTN("Extension");

    private final String paramString;
    static final Map<String, BreakdownOption> PARAMS;

    private BreakdownOption(String s2) {
        this.paramString = s2;
    }

    public String getParamString() {
        return this.paramString;
    }

    public static BreakdownOption getBreakdownOption(String stackType) {
        return PARAMS.get(stackType.toLowerCase(Locale.US));
    }

    public String getRevCountToolTip(String key, String valueString, String date, boolean isSingleDay, boolean alwaysAppendSeriesKeyToTooltip) {
        String dateString = isSingleDay ? "on " + date : "between " + date;
        StringBuilder tooltip = new StringBuilder();
        if (key.equals("Other")) {
            tooltip.append(valueString);
            tooltip.append(" revisions to other files ").append(dateString);
        } else {
            switch (this) {
                case AUTHOR: 
                case USER: {
                    tooltip.append(key).append(" committed ").append(valueString).append(" file revisions ").append(dateString);
                    break;
                }
                case EXTN: {
                    tooltip.append(valueString);
                    tooltip.append(" revisions to ").append(key).append(" files ").append(dateString);
                    break;
                }
                case NONE: {
                    tooltip.append(valueString);
                    tooltip.append(" file revisions ").append(dateString);
                    if (!alwaysAppendSeriesKeyToTooltip) break;
                    tooltip.append(" for ").append(key);
                    break;
                }
                case SUBDIR: {
                    tooltip.append(valueString);
                    tooltip.append(" file revisions in ").append(key).append(" ").append(dateString);
                    break;
                }
                default: {
                    tooltip.append("   ").append(date).append("   ").append(key).append("   ");
                }
            }
        }
        return tooltip.toString();
    }

    public String getLineCountTooltip(String valueString, String date, String key, String description, boolean alwaysAppendSeriesKeyToTooltip) {
        StringBuilder tooltip;
        block15: {
            block13: {
                block14: {
                    tooltip = new StringBuilder();
                    if (!Strings.isNullOrEmpty((String)description)) break block13;
                    tooltip.append(valueString);
                    if (!key.equals("Other")) break block14;
                    tooltip.append(" other lines of code as of ").append(date);
                    if (alwaysAppendSeriesKeyToTooltip) {
                        tooltip.append(" for ").append(key);
                    }
                    break block15;
                }
                switch (this) {
                    case AUTHOR: 
                    case USER: {
                        tooltip.append(" lines of code contributed by ").append(key).append(" as of ").append(date);
                        break;
                    }
                    case EXTN: {
                        tooltip.append(" lines of code in ").append(key).append(" files as of ").append(date);
                        break;
                    }
                    case SUBDIR: {
                        tooltip.append(" lines of code in ").append(key).append(" as of ").append(date);
                        break;
                    }
                    default: {
                        tooltip.append(" lines of code as of ").append(date);
                        if (alwaysAppendSeriesKeyToTooltip) {
                            tooltip.append(" for ").append(key);
                            break;
                        }
                        break block15;
                    }
                }
                break block15;
            }
            switch (this) {
                case AUTHOR: 
                case USER: {
                    if (!key.equals("Other")) {
                        tooltip.append("Total lines of code by ").append(key).append(" ");
                        break;
                    }
                    tooltip.append("Other lines of code ");
                    if (!alwaysAppendSeriesKeyToTooltip) break;
                    tooltip.append(" for ").append(key);
                    break;
                }
                case EXTN: {
                    tooltip.append("lines of code in ").append(key).append(" files");
                    break;
                }
                case SUBDIR: {
                    tooltip.append("lines of code in ").append(key);
                    break;
                }
                default: {
                    tooltip.append("lines of code ");
                    if (!alwaysAppendSeriesKeyToTooltip) break;
                    tooltip.append(" for ").append(key);
                }
            }
            tooltip.append(description);
        }
        return tooltip.toString();
    }

    static {
        PARAMS = new HashMap<String, BreakdownOption>();
        for (BreakdownOption option : BreakdownOption.values()) {
            PARAMS.put(option.paramString.toLowerCase(Locale.US), option);
        }
    }
}

