/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.branch;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.BranchSelectorPref;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class BranchPreferenceHandler {
    private TxTemplate txTemplate;
    private UserRepositoryPropertyManager userRepositoryPropertyManager;
    private EffectiveUserProvider userProvider;

    @Autowired
    public BranchPreferenceHandler(TxTemplate txTemplate, UserRepositoryPropertyManager userRepositoryPropertyManager, EffectiveUserProvider effectiveUserProvider) {
        this.txTemplate = txTemplate;
        this.userRepositoryPropertyManager = userRepositoryPropertyManager;
        this.userProvider = effectiveUserProvider;
    }

    public boolean upgradeLastSelectedBranchPref(final FecruUser user, final BranchSelectorPref branchPref) {
        if (user == null) {
            return true;
        }
        try {
            if (branchPref != null && !branchPref.getRepositories().isEmpty()) {
                this.txTemplate.execute(new TxCallback<Boolean>(){

                    @Override
                    public Boolean doInTransaction(TransactionStatus status) throws Exception {
                        try {
                            for (String repoName : branchPref.getRepositories()) {
                                JSONObject json = branchPref.getSelectedBranchObjectForRepository(repoName);
                                BranchPreferenceHandler.this.userRepositoryPropertyManager.saveProperty(user, repoName, "branchSelector.lastSelected", json.toString());
                            }
                        }
                        catch (JSONException e2) {
                            Logs.APP_LOG.error((Object)("Couldnt upgrade user preferences for user: " + user.getUsername()), (Throwable)e2);
                        }
                        return null;
                    }
                });
                return true;
            }
        }
        catch (JSONException e2) {
            Logs.APP_LOG.error((Object)("Couldnt upgrade user preferences for user: " + user.getUsername()), (Throwable)e2);
        }
        return false;
    }

    public void addLastSelectedBranchPref(FecruUser user, String repName, String lsbr) {
        if (user != null && lsbr != null) {
            try {
                JSONObject json = new JSONObject(lsbr);
                JSONObject jsonForRepo = (JSONObject)json.get(repName);
                this.userRepositoryPropertyManager.saveProperty(user, repName, "branchSelector.lastSelected", jsonForRepo.toString());
            }
            catch (JSONException e2) {
                Logs.APP_LOG.error((Object)("Couldnt save branch preferences for user " + user.getUsername()), (Throwable)e2);
            }
        }
    }

    public void handleLastSelectedBranch(CookiePreferences preferences, HttpServletRequest request, String repository) {
        BranchSelectorPref branchPref;
        FecruUser user = this.userProvider.getEffectiveUser();
        if (preferences != null && this.upgradeLastSelectedBranchPref(user, branchPref = preferences.getLastBranchPref())) {
            PreferenceManager.clearBranchSelectorPrefs(user, CrucibleFilter.getRequest(), CrucibleFilter.getResponse(), preferences);
        }
        this.addLastSelectedBranchPref(user, repository, request.getParameter("lsbr"));
    }
}

