/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity.external;

import com.atlassian.fisheye.activity.ExternalActivityItemSearchParams;
import java.util.Date;
import java.util.TimeZone;

final class ExternalActivityItemSearchParamsImpl
implements ExternalActivityItemSearchParams {
    private final String repFilter;
    private final TimeZone tz;
    private final Date minDate;
    private final Date maxDate;
    private final ExternalActivityItemSearchParams.SearchDirection searchDirection;
    private final int maxItems;
    private final Iterable<String> committers;
    private final String userFilter;
    private final Integer projectId;

    public String getRepFilter() {
        return this.repFilter;
    }

    public TimeZone getTz() {
        return this.tz;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public ExternalActivityItemSearchParams.SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public Iterable<String> getCommitters() {
        return this.committers;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    private ExternalActivityItemSearchParamsImpl(Builder builder) {
        this.repFilter = builder.repFilter;
        this.tz = builder.tz;
        this.minDate = builder.minDate;
        this.maxDate = builder.maxDate;
        this.searchDirection = builder.searchDirection;
        this.maxItems = builder.maxItems;
        this.committers = builder.committers;
        this.userFilter = builder.userFilter;
        this.projectId = builder.projectId;
    }

    public static class Builder {
        private TimeZone tz;
        private Date minDate;
        private Date maxDate;
        private ExternalActivityItemSearchParams.SearchDirection searchDirection;
        private int maxItems;
        private Iterable<String> committers;
        private String userFilter;
        private Integer projectId;
        private String repFilter;

        public static Builder fromParams(ExternalActivityItemSearchParamsImpl params) {
            Builder builder = new Builder();
            builder.tz = params.tz;
            builder.minDate = params.minDate;
            builder.maxDate = params.maxDate;
            builder.searchDirection = params.searchDirection;
            builder.maxItems = params.maxItems;
            builder.committers = params.committers;
            builder.userFilter = params.userFilter;
            builder.projectId = params.projectId;
            builder.repFilter = params.repFilter;
            return builder;
        }

        public Builder repFilter(String repFilter) {
            this.repFilter = repFilter;
            return this;
        }

        public Builder tz(TimeZone tz) {
            this.tz = tz;
            return this;
        }

        public Builder minDate(Date minDate) {
            this.minDate = minDate;
            return this;
        }

        public Builder maxDate(Date maxDate) {
            this.maxDate = maxDate;
            return this;
        }

        public Builder searchDirection(ExternalActivityItemSearchParams.SearchDirection searchDirection) {
            this.searchDirection = searchDirection;
            return this;
        }

        public Builder maxItems(int maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder committers(Iterable<String> committers) {
            this.committers = committers;
            return this;
        }

        public Builder userFilter(String userFilter) {
            this.userFilter = userFilter;
            return this;
        }

        public Builder projectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public ExternalActivityItemSearchParamsImpl build() {
            return new ExternalActivityItemSearchParamsImpl(this);
        }
    }
}

