/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity.external;

import com.atlassian.fisheye.activity.BaseActivityItem;
import com.atlassian.fisheye.activity.ExternalActivityItem;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Pair;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ExternalActivityItemAdapter
extends BaseActivityItem {
    private static final String STRM3_TITLE_HTML_RX = "(<a[^<]+</a>)?([^<]+)(<a[^<]+</a>)\\s*\\((.*)\\)";
    private static final Pattern PATTERN_STRM3 = Pattern.compile("(<a[^<]+</a>)?([^<]+)(<a[^<]+</a>)\\s*\\((.*)\\)", 40);
    private static final String STRM4_TITLE_HTML_RX = "(<a[^<]+</a>)?([^<]+)(<a[^>]*class=\"issue-link\"[^>]*>)(.*)</a>(.*)";
    private static final Pattern PATTERN_STRM4 = Pattern.compile("(<a[^<]+</a>)?([^<]+)(<a[^>]*class=\"issue-link\"[^>]*>)(.*)</a>(.*)", 40);
    private static final String STRM4_ALTERNATE_TITLE_HTML_RX = "(<a[^<]+</a>)?(.*)(<a[^>]*class=\"issue-link\"[^>]*>)(.*)</a>";
    private static final Pattern PATTERN_STRM4_ALTERNATE = Pattern.compile("(<a[^<]+</a>)?(.*)(<a[^>]*class=\"issue-link\"[^>]*>)(.*)</a>", 40);
    private static final String WILDCARD_TITLE_HTML_RX = "(<a[^<]+</a>)?(.*)";
    private static final Pattern PATTERN_WILDCARD = Pattern.compile("(<a[^<]+</a>)?(.*)", 40);
    private static final String ACTIVITY_ITEM_DESCRIPTION_RX = "<div class=\"activity-item-description\">(.*)</div>";
    private static final Pattern PATTERN_ACTIVITY_ITEM_DESCRIPTION = Pattern.compile("<div class=\"activity-item-description\">(.*)</div>", 40);
    private static final String TITLE_RX = "<span class='resolved-link'>([^<]+)</span>(.*)";
    private static final Pattern PATTERN_TITLE = Pattern.compile("<span class='resolved-link'>([^<]+)</span>(.*)", 40);
    private static final String ISSUE_KEY_RX = ".*/([A-Za-z]+-\\d+)(?:\\?\\b.*)?";
    Pattern PATTERN_ISSUE_KEY = Pattern.compile(".*/([A-Za-z]+-\\d+)(?:\\?\\b.*)?");
    private final String author;
    private final String username;
    private final String title;
    private final String summary;
    private final String url;
    private final Date date;
    private final List<IssueKey> issueKeys;
    private final String verbage;
    public static final String TYPE = "streams-plugin-item";
    private final String key;

    public ExternalActivityItemAdapter(ExternalActivityItem item) {
        this.author = item.getAuthor();
        this.username = item.getUsername();
        this.date = item.getDate();
        this.url = item.getUrl();
        this.issueKeys = Collections.singletonList(this.resolveIssueKey(this.url));
        Pair<String, String> verbageAndTitle = this.parseTitleHtml(item.getTitle());
        this.verbage = verbageAndTitle.getFirst();
        this.title = this.parseTitle(verbageAndTitle.getSecond());
        this.summary = this.parseSummaryHtml(item.getSummary());
        this.key = this.calcKey(this.title);
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getOpaqueId() {
        return this.key;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String toString() {
        return super.toString() + "Date:" + this.getDate() + ", Type:" + this.getType() + ", OpaqueId:" + this.getOpaqueId();
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getVerbageHtml() {
        return this.verbage;
    }

    public List<IssueKey> getIssueKeys() {
        return this.issueKeys;
    }

    private IssueKey resolveIssueKey(String url) {
        if (url == null) {
            return null;
        }
        Matcher issueKeyMatcher = this.PATTERN_ISSUE_KEY.matcher(url);
        if (issueKeyMatcher.matches()) {
            String key = issueKeyMatcher.group(1);
            return new IssueKey(url, key);
        }
        return null;
    }

    private Pair<String, String> parseTitleHtml(String titleHtml) {
        String summary;
        String verbage;
        Matcher strm3Matcher = PATTERN_STRM3.matcher(titleHtml);
        Matcher strm4Matcher = PATTERN_STRM4.matcher(titleHtml);
        Matcher strm4AlternateMatcher = PATTERN_STRM4_ALTERNATE.matcher(titleHtml);
        Matcher wildcardMatcher = PATTERN_WILDCARD.matcher(titleHtml);
        if (strm3Matcher.matches()) {
            verbage = strm3Matcher.group(2).trim();
            summary = strm3Matcher.group(4).trim();
        } else if (strm4Matcher.matches()) {
            verbage = strm4Matcher.group(2).trim();
            if (StringUtils.isNotBlank((String)strm4Matcher.group(5))) {
                verbage = verbage + " " + strm4Matcher.group(5).trim();
            }
            summary = strm4Matcher.group(4).trim();
        } else if (strm4AlternateMatcher.matches()) {
            verbage = strm4AlternateMatcher.group(2).trim();
            summary = strm4AlternateMatcher.group(4).trim();
        } else if (wildcardMatcher.matches()) {
            verbage = wildcardMatcher.group(2).trim();
            summary = "";
        } else {
            Logs.APP_LOG.warn((Object)("Couldn't parse JIRA activity stream item: " + titleHtml));
            return Pair.newInstance("", "");
        }
        if (verbage.endsWith("of") || verbage.endsWith("on") || verbage.endsWith("to")) {
            verbage = verbage.substring(0, verbage.length() - 2).trim();
        }
        return Pair.newInstance(verbage, summary);
    }

    private String parseSummaryHtml(String summaryHtml) {
        if (summaryHtml == null) {
            return "";
        }
        Matcher m2 = PATTERN_ACTIVITY_ITEM_DESCRIPTION.matcher(summaryHtml);
        if (m2.find()) {
            return m2.group(1);
        }
        return "";
    }

    private String parseTitle(String title) {
        Matcher titleMatcher = PATTERN_TITLE.matcher(title);
        if (titleMatcher.matches()) {
            return titleMatcher.group(1) + titleMatcher.group(2);
        }
        return title;
    }

    private String calcKey(String title) {
        return "streams-plugin-item:" + title.hashCode();
    }

    public static class IssueKey {
        private final String url;
        private final String key;

        public IssueKey(String url, String key) {
            this.url = url;
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            IssueKey issueKey = (IssueKey)o2;
            if (this.key != null ? !this.key.equals(issueKey.key) : issueKey.key != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(issueKey.url) : issueKey.url != null);
        }

        public int hashCode() {
            int result = this.url != null ? this.url.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}

