/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity.external;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemProvider;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.ExternalActivityItem;
import com.atlassian.fisheye.activity.ExternalActivityItemProvider;
import com.atlassian.fisheye.activity.ExternalActivityItemSearchParams;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.atlassian.fisheye.activity.external.ExternalActivityItemAdapter;
import com.atlassian.fisheye.activity.external.ExternalActivityItemSearchParamsImpl;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.plugin.PluginAccessor;
import com.cenqua.crucible.model.Principal;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ActivityProvider
@Component(value="aggregatingExternalActivityItemProvider")
public class AggregatingExternalActivityItemProvider
implements ActivityItemProvider {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public AggregatingExternalActivityItemProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return params.useExternals() && params.isApplicableForExternals();
    }

    private Iterable<ExternalActivityItemProvider> lookupProviders() {
        return this.pluginAccessor.getEnabledModulesByClass(ExternalActivityItemProvider.class);
    }

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, final Principal user, final ActivitySearchMonitor monitor) {
        final ExternalActivityItemSearchParams externalParams = (ExternalActivityItemSearchParams)AggregatingExternalActivityItemProvider.toExternalParams().apply((Object)params);
        Iterable<ExternalActivityItemProvider> providers = this.lookupProviders();
        final HashMap<ApplicationLink, Exception> exceptions = new HashMap<ApplicationLink, Exception>();
        Iterable externalItems = Iterables.concat((Iterable)Iterables.transform(providers, (Function)new Function<ExternalActivityItemProvider, Iterable<ExternalActivityItem>>(){

            public Iterable<ExternalActivityItem> apply(ExternalActivityItemProvider provider) {
                if (monitor.isTimeExceeded()) {
                    monitor.setSearchTruncated(true);
                    return ImmutableList.of();
                }
                HashMap newExceptions = new HashMap();
                Iterable activityItems = provider.findActivityItems(user, externalParams, newExceptions);
                exceptions.putAll(newExceptions);
                return activityItems;
            }
        }));
        ArrayList<ActivityItem> items = new ArrayList<ActivityItem>();
        Iterable iterable = Iterables.transform((Iterable)externalItems, AggregatingExternalActivityItemProvider.toActivityItem());
        for (ActivityItem item : iterable) {
            items.add(item);
        }
        return new ActivityItemList((List<? extends ActivityItem>)items, (Map<ApplicationLink, Exception>)exceptions);
    }

    @Override
    public boolean hasEarlierActivity(final ActivityItem item, ActivityItemSearchParams params, final Principal user, ActivitySearchMonitor monitor) {
        final ExternalActivityItemSearchParams externalParams = (ExternalActivityItemSearchParams)AggregatingExternalActivityItemProvider.toExternalParams().apply((Object)params);
        return Iterables.any(this.lookupProviders(), (Predicate)new Predicate<ExternalActivityItemProvider>(){

            public boolean apply(ExternalActivityItemProvider provider) {
                return provider.hasEarlierActivity(user, (ExternalActivityItem)AggregatingExternalActivityItemProvider.toMockExternalActivityItem().apply((Object)item), externalParams);
            }
        });
    }

    @Override
    public boolean hasLaterActivity(final ActivityItem item, ActivityItemSearchParams params, final Principal user, ActivitySearchMonitor monitor) {
        final ExternalActivityItemSearchParams externalParams = (ExternalActivityItemSearchParams)AggregatingExternalActivityItemProvider.toExternalParams().apply((Object)params);
        return Iterables.any(this.lookupProviders(), (Predicate)new Predicate<ExternalActivityItemProvider>(){

            public boolean apply(ExternalActivityItemProvider provider) {
                return provider.hasLaterActivity(user, (ExternalActivityItem)AggregatingExternalActivityItemProvider.toMockExternalActivityItem().apply((Object)item), externalParams);
            }
        });
    }

    @Override
    public int getQueryOrder() {
        return 5;
    }

    private static Function<ActivityItemSearchParams, ExternalActivityItemSearchParams> toExternalParams() {
        return ToExternalParams.INSTANCE;
    }

    private static Function<ActivityItem, ExternalActivityItem> toMockExternalActivityItem() {
        return ToMockExternalActivityItem.INSTANCE;
    }

    private static Function<ExternalActivityItem, ActivityItem> toActivityItem() {
        return ToActivityItem.INSTANCE;
    }

    private static enum ToActivityItem implements Function<ExternalActivityItem, ActivityItem>
    {
        INSTANCE;


        public ActivityItem apply(ExternalActivityItem externalActivityItem) {
            return new ExternalActivityItemAdapter(externalActivityItem);
        }
    }

    private static enum ToMockExternalActivityItem implements Function<ActivityItem, ExternalActivityItem>
    {
        INSTANCE;


        public ExternalActivityItem apply(final ActivityItem activityItem) {
            return new ExternalActivityItem(){

                public Date getDate() {
                    return activityItem.getDate();
                }

                public String getAuthor() {
                    return null;
                }

                public String getUsername() {
                    return null;
                }

                public String getTitle() {
                    return null;
                }

                public String getSummary() {
                    return null;
                }

                public String getUrl() {
                    return null;
                }
            };
        }
    }

    private static enum ToExternalParams implements Function<ActivityItemSearchParams, ExternalActivityItemSearchParams>
    {
        INSTANCE;


        public ExternalActivityItemSearchParams apply(ActivityItemSearchParams activityItemSearchParams) {
            ExternalActivityItemSearchParamsImpl.Builder builder = new ExternalActivityItemSearchParamsImpl.Builder();
            builder.committers(activityItemSearchParams.getCommitters());
            builder.maxDate(activityItemSearchParams.getMaxDate());
            builder.maxItems(activityItemSearchParams.getMaxItems());
            builder.minDate(activityItemSearchParams.getMinDate());
            builder.projectId(activityItemSearchParams.getProjectId());
            builder.repFilter(activityItemSearchParams.getRepFilter());
            builder.searchDirection(activityItemSearchParams.getSearchDirection() == SearchSortOrder.TOWARDS_FUTURE ? ExternalActivityItemSearchParams.SearchDirection.TOWARDS_FUTURE : ExternalActivityItemSearchParams.SearchDirection.TOWARDS_PAST);
            builder.tz(activityItemSearchParams.getTz());
            builder.userFilter(activityItemSearchParams.getUserFilter());
            return builder.build();
        }
    }
}

