/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.crucible.activity.review.ProjectConstraint;
import com.atlassian.crucible.activity.review.ProjectConstraintBuilder;
import com.atlassian.crucible.activity.review.ReviewCommentActivityItem;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemComparators;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.ActivityItemProvider;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityItemSearchUtil;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.RepositoryConstraintBuilder;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarList;
import com.atlassian.fisheye.stars.model.UserStar;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DelegatingRepositorySearcher;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.SortedList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="starDownStreamActivityItemManager")
public class StarDownStreamActivityItemManager
implements ActivityItemManager {
    private final DelegatingRepositorySearcher changesetProvider;
    private final ReviewManager reviewManager;
    @Autowired(required=false)
    @Resource(name="reviewCommentActivityItemProvider")
    private ActivityItemProvider commentProvider;
    @Autowired(required=false)
    @Resource(name="reviewStateChangeActivityItemProvider")
    private ActivityItemProvider stateProvider;
    @Autowired(required=false)
    @Resource(name="reviewCompletionActivityItemProvider")
    private ActivityItemProvider completionProvider;
    @Autowired(required=false)
    @Resource(name="reviewerJoinActivityItemProvider")
    private ActivityItemProvider reviewerJoinProvider;
    @Autowired(required=false)
    @Resource(name="changesetCommentActivityItemProvider")
    private ActivityItemProvider changesetCommentActivityItemProvider;
    @Autowired(required=false)
    @Resource(name="aggregatingExternalActivityItemProvider")
    private ActivityItemProvider aggregatingExternalProvider;
    @Autowired(required=true)
    private StarManager manager;
    @Autowired(required=true)
    private RepositoryManager repositoryManager;
    @Autowired(required=true)
    private CommitterUserMappingManager committerUserMappingManager;
    @Resource
    private CommentManager commentManager;

    @Autowired
    public StarDownStreamActivityItemManager(DelegatingRepositorySearcher changesetProvider, ReviewManager reviewManager) {
        this.changesetProvider = changesetProvider;
        this.reviewManager = reviewManager;
    }

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        List<Star> stars = this.manager.getStarsForUser(user.getUserName());
        SortedList<ActivityItem> items = new SortedList<ActivityItem>(ActivityItemComparators.desc());
        try {
            this.addFEData(items, params, user, stars, activitySearchMonitor);
            params = ActivityItemSearchUtil.optimiseParams(items, params);
            this.addCruDataFromFEStars(items, params, user, stars, activitySearchMonitor);
            params = ActivityItemSearchUtil.optimiseParams(items, params);
            this.addCruData(items, params, user, stars, activitySearchMonitor);
            params = ActivityItemSearchUtil.optimiseParams(items, params);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Error accessing database whilst getting Star Downstream", (Throwable)e2);
            return new ActivityItemList(e2);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<ApplicationLink, Exception> appLinkExceptions = new HashMap<ApplicationLink, Exception>();
        if (params.includeUserInDownstream()) {
            Pair<List<Exception>, Map<ApplicationLink, Exception>> allExceptions = this.addCruDataForUser(params, user, items, user.getUserName(), activitySearchMonitor);
            exceptions.addAll((Collection)allExceptions.getFirst());
            appLinkExceptions.putAll(allExceptions.getSecond());
            params = ActivityItemSearchUtil.optimiseParams(items, params);
        }
        if (params.isApplicableForCrucibleSearch()) {
            StarList starList = new StarList();
            starList.addStars(stars);
            List userStars = starList.getStarsOfType(StarType.USER);
            for (UserStar star : userStars) {
                if (activitySearchMonitor.isTimeExceeded()) {
                    activitySearchMonitor.setSearchTruncated(true);
                    continue;
                }
                Pair<List<Exception>, Map<ApplicationLink, Exception>> allExceptions = this.addCruDataForUser(params, user, items, star.getFEUsername(), activitySearchMonitor);
                exceptions.addAll((Collection<Exception>)allExceptions.getFirst());
                appLinkExceptions.putAll(allExceptions.getSecond());
                params = ActivityItemSearchUtil.optimiseParams(items, params);
            }
        }
        TreeSet set = new TreeSet(ActivityItemComparators.desc());
        set.addAll(items);
        return new ActivityItemList(set, exceptions, appLinkExceptions);
    }

    private Pair<List<Exception>, Map<ApplicationLink, Exception>> addCruDataForUser(ActivityItemSearchParams params, Principal user, SortedList<ActivityItem> items, String username, ActivitySearchMonitor activitySearchMonitor) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<ApplicationLink, Exception> appLinkExceptions = new HashMap<ApplicationLink, Exception>();
        ActivityItemSearchParams.Builder userParamsBuilder = ActivityItemSearchParams.Builder.fromParams(params);
        userParamsBuilder.user(username);
        ActivityItemSearchParams userConstrained = userParamsBuilder.build();
        params = this.getCruData(items, userConstrained, user, activitySearchMonitor);
        if (params.useExternals()) {
            ActivityItemList activityItems = this.aggregatingExternalProvider.findActivityItems(userConstrained, user, activitySearchMonitor);
            exceptions.addAll(activityItems.getExceptions());
            appLinkExceptions.putAll(activityItems.getApplinkExceptions());
            this.addTrimAndOptimise(items, activityItems.getItems(), params);
        }
        return Pair.newInstance(exceptions, appLinkExceptions);
    }

    private void addCruData(SortedList<ActivityItem> items, ActivityItemSearchParams params, Principal user, List<Star> stars, ActivitySearchMonitor activitySearchMonitor) throws DbException {
        if (params.isApplicableForCrucibleSearch()) {
            ProjectConstraintBuilder cruConstraintBuilder = new ProjectConstraintBuilder(this.reviewManager, this.commentManager);
            cruConstraintBuilder.addStars(stars);
            ProjectConstraint crucibleConstraints = cruConstraintBuilder.getActivityItemParams();
            for (Integer projectId : crucibleConstraints.getProjectIds()) {
                ActivityItemSearchParams cruParams;
                if (activitySearchMonitor.isTimeExceeded()) {
                    activitySearchMonitor.setSearchTruncated(true);
                    continue;
                }
                ProjectConstraint.ProjectConstraintItem constraintsForProject = crucibleConstraints.getConstraintsForProject(projectId);
                ActivityItemSearchParams.Builder cruParamsBuilder = ActivityItemSearchParams.Builder.fromParams(params);
                if (constraintsForProject.isWholeProject()) {
                    cruParamsBuilder.project(projectId);
                } else {
                    IntOpenHashSet reviewIds = new IntOpenHashSet();
                    reviewIds.addAll((IntCollection)constraintsForProject.getReviews());
                    cruParamsBuilder.reviewIds((IntSet)reviewIds);
                    ArrayList<ReviewCommentActivityItem> commentItems = new ArrayList<ReviewCommentActivityItem>();
                    for (Comment comment : constraintsForProject.getComments()) {
                        if (comment.isDraft() || comment.isDeleted() || !this.passesDateCheck(comment, params.getMaxDate(), params.getMinDate())) continue;
                        commentItems.add(new ReviewCommentActivityItem(comment));
                    }
                    if (!commentItems.isEmpty()) {
                        params = this.addTrimAndOptimise(items, commentItems, params);
                    }
                }
                if ((cruParams = cruParamsBuilder.build()).getReviewIds().isEmpty() && cruParams.getProjectId() == null) continue;
                cruParams = this.getCruData(items, cruParams, user, activitySearchMonitor);
            }
        }
    }

    private boolean passesDateCheck(Comment comment, Date maxDate, Date minDate) {
        boolean result;
        boolean bl = result = maxDate == null || !comment.getUpdatedDate().after(maxDate);
        result = minDate != null ? !comment.getUpdatedDate().before(minDate) : result;
        return result;
    }

    private void addFEData(SortedList<ActivityItem> items, ActivityItemSearchParams params, Principal user, List<Star> stars, ActivitySearchMonitor activitySearchMonitor) throws DbException {
        RepositoryConstraints fisheyeConstraints;
        RepositoryConstraintBuilder repConstraintBuilder = new RepositoryConstraintBuilder(this.committerUserMappingManager);
        repConstraintBuilder.addStars(stars);
        if (params.includeUserInDownstream()) {
            try {
                repConstraintBuilder.addStar(UserStar.forUser(user.getUserName()));
            }
            catch (StarInvalidKeyException e2) {
                throw new RuntimeException(e2);
            }
        }
        if ((fisheyeConstraints = repConstraintBuilder.getActivityItemParams()).isEmpty()) {
            return;
        }
        ActivityItemSearchParams.Builder newParamsBuilder = ActivityItemSearchParams.Builder.fromParams(params);
        newParamsBuilder.crossRepositoryConstraint(fisheyeConstraints);
        ActivityItemSearchParams constrainedParams = this.getItems(this.changesetProvider, items, newParamsBuilder.build(), user, activitySearchMonitor);
        if (this.changesetCommentActivityItemProvider != null) {
            this.getItems(this.changesetCommentActivityItemProvider, items, constrainedParams, user, activitySearchMonitor);
        }
    }

    private void addCruDataFromFEStars(SortedList<ActivityItem> items, ActivityItemSearchParams params, Principal user, List<Star> stars, ActivitySearchMonitor activitySearchMonitor) throws DbException {
        RepositoryConstraintBuilder repConstraintBuilder = new RepositoryConstraintBuilder(this.committerUserMappingManager);
        repConstraintBuilder.addStars(stars);
        RepositoryConstraints fisheyeConstraints = repConstraintBuilder.getActivityItemParams();
        for (String rep : fisheyeConstraints.getReps()) {
            ActivityItemSearchParams.Builder cruParamsBuilder = ActivityItemSearchParams.Builder.fromParams(params);
            RepositoryConstraints.RepositoryConstraint constraintsForRep = fisheyeConstraints.getConstraintsForRep(rep);
            RepositoryHandle repositoryHandle = this.repositoryManager.getRepository(rep);
            if (repositoryHandle != null && repositoryHandle.isRunning()) {
                if (constraintsForRep.isIncludeWholeRepository()) {
                    cruParamsBuilder.path(rep, Path.ROOT);
                } else if (!constraintsForRep.getPaths().isEmpty()) {
                    cruParamsBuilder.paths(constraintsForRep.getPaths(), rep);
                } else if (!constraintsForRep.getCommitters().isEmpty()) {
                    cruParamsBuilder.anyCommitters(constraintsForRep.getCommitters(), rep);
                }
                ActivityItemSearchParams cruParams = cruParamsBuilder.build();
                if (cruParams.isApplicableForCrucibleSearch() && !cruParams.isFESpecific()) {
                    if (this.stateProvider != null) {
                        this.getItems(this.stateProvider, items, cruParams, user, activitySearchMonitor);
                    }
                    if (this.completionProvider != null) {
                        this.getItems(this.completionProvider, items, cruParams, user, activitySearchMonitor);
                    }
                    if (this.reviewerJoinProvider != null) {
                        this.getItems(this.reviewerJoinProvider, items, cruParams, user, activitySearchMonitor);
                    }
                }
            }
            if (!activitySearchMonitor.isTimeExceeded()) continue;
            activitySearchMonitor.setSearchTruncated(true);
            break;
        }
    }

    private ActivityItemSearchParams addTrimAndOptimise(SortedList<ActivityItem> items, List<? extends ActivityItem> moreItems, ActivityItemSearchParams params) {
        for (ActivityItem activityItem : moreItems) {
            if (items.contains(activityItem)) continue;
            items.add(activityItem);
        }
        ActivityItemSearchUtil.trimToSize(items, params.getMaxItems());
        return ActivityItemSearchUtil.optimiseParams(items, params);
    }

    private ActivityItemSearchParams getCruData(SortedList<ActivityItem> items, ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        ActivityItemSearchParams mutatedParams = params;
        if (this.commentProvider != null) {
            mutatedParams = this.getItems(this.commentProvider, items, params, user, activitySearchMonitor);
        }
        if (this.stateProvider != null) {
            mutatedParams = this.getItems(this.stateProvider, items, mutatedParams, user, activitySearchMonitor);
        }
        if (this.completionProvider != null) {
            mutatedParams = this.getItems(this.completionProvider, items, mutatedParams, user, activitySearchMonitor);
        }
        if (this.reviewerJoinProvider != null) {
            mutatedParams = this.getItems(this.reviewerJoinProvider, items, mutatedParams, user, activitySearchMonitor);
        }
        return mutatedParams;
    }

    private ActivityItemSearchParams getItems(ActivityItemProvider provider, SortedList<ActivityItem> itemsSoFar, ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        List<ActivityItem> newItems = provider.findActivityItems(params, user, activitySearchMonitor).getItems();
        return this.addTrimAndOptimise(itemsSoFar, newItems, params);
    }
}

